/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeVarType;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.PyTypingNewTypeFactoryType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyNewTypeInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij.python.psi.impl"})
public final class PyNewTypeInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        return (PsiElementVisitor)new PyInspectionVisitor(holder, typeEvalContext){

            /*
             * Enabled aggressive block sorting
             */
            public void visitPyTargetExpression(PyTargetExpression node) {
                Object[] objectArray;
                PyExpression typeExpr;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PyExpression assignedValue = node.findAssignedValue();
                if (!(assignedValue instanceof PyCallExpression)) {
                    return;
                }
                PyExpression pyExpression = ((PyCallExpression)assignedValue).getCallee();
                if (!(pyExpression instanceof PyReferenceExpression)) return;
                PyReferenceExpression pyReferenceExpression = (PyReferenceExpression)pyExpression;
                if (pyReferenceExpression == null) {
                    return;
                }
                PyReferenceExpression callee = pyReferenceExpression;
                PsiElement psiElement = callee.followAssignmentsChain(this.getResolveContext()).getElement();
                if (psiElement == null) {
                    return;
                }
                PsiElement resolved = psiElement;
                boolean isNewTypeCall = resolved instanceof PyQualifiedNameOwner && Intrinsics.areEqual((Object)((PyQualifiedNameOwner)resolved).getQualifiedName(), (Object)"typing.NewType");
                if (!isNewTypeCall) return;
                String newTypeName = PyResolveUtil.resolveStrArgument((PyCallExpression)assignedValue, 0, "name");
                String targetName = node.getName();
                if (!Intrinsics.areEqual((Object)targetName, (Object)newTypeName)) {
                    Object[] objectArray2 = new Object[]{targetName, newTypeName};
                    this.registerProblem(node.getNameIdentifier(), PyPsiBundle.message("INSP.NAME.new.type.variable.name.does.not.match.new.type.name", objectArray2));
                }
                if ((typeExpr = PyPsiUtils.flattenParens((PyExpression)((PyExpression)((PyCallExpression)assignedValue).getArgument(1, "tp", PyExpression.class)))) == null) return;
                PyType type = (PyType)Ref.deref(PyTypingTypeProvider.getType(typeExpr, this.myTypeEvalContext));
                if (!(type instanceof PyClassType)) {
                    this.registerProblem((PsiElement)typeExpr, PyPsiBundle.message("INSP.NAME.new.type.expected.class", new Object[0]));
                    return;
                }
                if (type instanceof PyCollectionType) {
                    boolean bl;
                    block11: {
                        List<PyType> list = ((PyCollectionType)type).getElementTypes();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"getElementTypes(...)");
                        Iterable $this$any$iv = list;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                PyType it = (PyType)element$iv;
                                boolean bl2 = false;
                                if (!(it instanceof PyTypeVarType && ((PyTypeVarType)it).getScopeOwner() == null)) continue;
                                bl = true;
                                break block11;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        this.registerProblem((PsiElement)typeExpr, PyPsiBundle.message("INSP.NAME.new.type.new.type.cannot.be.generic", new Object[0]));
                        return;
                    }
                }
                if (type instanceof PyLiteralType) {
                    objectArray = new Object[]{((PyLiteralType)type).getName()};
                    this.registerProblem((PsiElement)typeExpr, PyPsiBundle.message("INSP.NAME.new.type.new.type.cannot.be.used.with", objectArray));
                    return;
                }
                if (!(type instanceof PyTypedDictType)) return;
                objectArray = new Object[]{"TypedDict"};
                this.registerProblem((PsiElement)typeExpr, PyPsiBundle.message("INSP.NAME.new.type.new.type.cannot.be.used.with", objectArray));
            }

            public void visitPyClass(PyClass node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                for (PyExpression superClassExpression : PyClassImpl.getUnfoldedSuperClassExpressions(node)) {
                    PyType superClassType = this.myTypeEvalContext.getType((PyTypedElement)superClassExpression);
                    if (!(superClassType instanceof PyTypingNewTypeFactoryType)) continue;
                    Object[] objectArray = new Object[]{((PyTypingNewTypeFactoryType)superClassType).getName()};
                    this.registerProblem((PsiElement)superClassExpression, PyPsiBundle.message("INSP.NAME.new.type.cannot.be.subclassed", objectArray), ProblemHighlightType.GENERIC_ERROR);
                }
            }
        };
    }
}

