/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/inspections/quickfix/PyEscapeBackslashQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "offsetInElement", "", "<init>", "(I)V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.python.psi.impl"})
public final class PyEscapeBackslashQuickFix
extends PsiUpdateModCommandQuickFix {
    private final int offsetInElement;

    public PyEscapeBackslashQuickFix(int offsetInElement) {
        this.offsetInElement = offsetInElement;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.escape.backslash", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (!(element instanceof PyStringLiteralExpression)) {
            return;
        }
        if (this.offsetInElement >= ((PyStringLiteralExpression)element).getTextLength() || ((PyStringLiteralExpression)element).getText().charAt(this.offsetInElement) != '\\') {
            return;
        }
        String string = new StringBuilder(((PyStringLiteralExpression)element).getText()).insert(this.offsetInElement, "\\").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String newText = string;
        PyStringLiteralExpression newElement = PyElementGenerator.getInstance((Project)project).createStringLiteralAlreadyEscaped(newText);
        element.replace((PsiElement)newElement);
    }
}

