/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonLexer;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a'\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\"\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"isNamespacePackage", "", "element", "Lcom/intellij/psi/PsiElement;", "isInNamespacePackage", "TOKENS_TO_SKIP", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "TWO_LINE_NAMESPACE_DECLARATIONS", "", "Ljava/util/regex/Pattern;", "ONE_LINE_NAMESPACE_DECLARATIONS", "patterns", "", "", "([Ljava/lang/String;)Ljava/util/List;", "intellij.python.psi.impl"})
@JvmName(name="PyNamespacePackageUtil")
@SourceDebugExtension(value={"SMAP\nPyNamespacePackageUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyNamespacePackageUtil.kt\ncom/jetbrains/python/psi/resolve/PyNamespacePackageUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,68:1\n1807#2,3:69\n1#3:72\n11705#4:73\n12052#4,3:74\n*S KotlinDebug\n*F\n+ 1 PyNamespacePackageUtil.kt\ncom/jetbrains/python/psi/resolve/PyNamespacePackageUtil\n*L\n32#1:69,3\n68#1:73\n68#1:74,3\n*E\n"})
public final class PyNamespacePackageUtil {
    @NotNull
    private static final TokenSet TOKENS_TO_SKIP;
    @NotNull
    private static final List<List<Pattern>> TWO_LINE_NAMESPACE_DECLARATIONS;
    @NotNull
    private static final List<Pattern> ONE_LINE_NAMESPACE_DECLARATIONS;

    public static final boolean isNamespacePackage(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof PsiDirectory) {
            LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)element);
            Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"forElement(...)");
            LanguageLevel level = languageLevel;
            PsiElement psiElement = PyUtil.turnDirIntoInit(element);
            if (psiElement == null) {
                return !level.isPython2();
            }
            PsiElement initFile = psiElement;
            PythonLexer lexer = new PythonLexer();
            lexer.start((CharSequence)initFile.getText());
            while (TOKENS_TO_SKIP.contains(lexer.getTokenType())) {
                lexer.advance();
            }
            String string = initFile.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string;
            int n = lexer.getTokenStart();
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String codeStart = string3;
            Object nextPattern = null;
            for (String line : StringsKt.lineSequence((CharSequence)codeStart)) {
                List matched;
                Object object;
                Object v6;
                block12: {
                    boolean bl;
                    String trimmed;
                    block11: {
                        trimmed = ((Object)StringsKt.trim((CharSequence)line)).toString();
                        if (((CharSequence)trimmed).length() == 0 || StringsKt.startsWith$default((String)trimmed, (String)"#", (boolean)false, (int)2, null)) continue;
                        Pattern pattern = nextPattern;
                        if (pattern != null) {
                            return pattern.matcher(trimmed).matches();
                        }
                        Iterable $this$any$iv = ONE_LINE_NAMESPACE_DECLARATIONS;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                Pattern it = (Pattern)element$iv;
                                boolean bl2 = false;
                                if (!it.matcher(trimmed).matches()) continue;
                                bl = true;
                                break block11;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        return true;
                    }
                    Iterable iterable = TWO_LINE_NAMESPACE_DECLARATIONS;
                    Iterator iterator = iterable.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        List it = (List)t;
                        boolean bl3 = false;
                        if (!((Pattern)it.get(0)).matcher(trimmed).matches()) continue;
                        v6 = t;
                        break block12;
                    }
                    v6 = null;
                }
                if ((object = (matched = (List)v6)) == null || (object = (Pattern)object.get(1)) == null) {
                    return false;
                }
                nextPattern = object;
            }
        }
        return false;
    }

    public static final boolean isInNamespacePackage(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile myFile = psiFile;
        PsiDirectory parentDirectory = myFile.getContainingDirectory();
        if (PyUtil.getSourceRoots(element).contains(parentDirectory.getVirtualFile())) {
            return false;
        }
        return parentDirectory != null && PyNamespacePackageUtil.isNamespacePackage((PsiElement)parentDirectory);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Pattern> patterns(String ... patterns) {
        void $this$mapTo$iv$iv;
        String[] $this$map$iv = patterns;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var11_11 = it;
            int n2 = 0;
            Pattern pattern = Pattern.compile((String)var11_11, n2);
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
            collection.add(pattern);
        }
        return (List)destination$iv$iv;
    }

    static {
        Object[] objectArray = new IElementType[]{PyTokenTypes.DOCSTRING, PyTokenTypes.END_OF_LINE_COMMENT, PyTokenTypes.LINE_BREAK, PyTokenTypes.SPACE, PyTokenTypes.TRY_KEYWORD, PyTokenTypes.COLON};
        TokenSet tokenSet = TokenSet.create((IElementType[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        TOKENS_TO_SKIP = tokenSet;
        Object[] objectArray2 = new List[4];
        objectArray = new String[]{"^from pkgutil import extend_path.*", "^__path__[ ]?=[ ]?extend_path\\(__path__,[ ]?__name__\\).*"};
        objectArray2[0] = PyNamespacePackageUtil.patterns((String[])objectArray);
        objectArray = new String[]{"^import pkgutil.*", "^__path__[ ]?=[ ]?pkgutil\\.extend_path\\(__path__,[ ]?__name__\\).*"};
        objectArray2[1] = PyNamespacePackageUtil.patterns((String[])objectArray);
        objectArray = new String[]{"^from pkg_resources import declare_namespace.*", "^declare_namespace\\(__name__\\).*"};
        objectArray2[2] = PyNamespacePackageUtil.patterns((String[])objectArray);
        objectArray = new String[]{"^import pkg_resources.*", "^pkg_resources.declare_namespace\\(__name__\\).*"};
        objectArray2[3] = PyNamespacePackageUtil.patterns((String[])objectArray);
        TWO_LINE_NAMESPACE_DECLARATIONS = CollectionsKt.listOf((Object[])objectArray2);
        objectArray2 = new String[]{"^__path__[ ]?=[ ]?__import__\\(['\"]pkgutil['\"]\\).extend_path\\(__path__, __name__\\).*", "^__import__\\(['\"]pkg_resources['\"]\\).declare_namespace\\(__name__\\).*"};
        ONE_LINE_NAMESPACE_DECLARATIONS = PyNamespacePackageUtil.patterns((String[])objectArray2);
    }
}

