/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.lang;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/diff/lang/DiffLanguage;", "", "<init>", "()V", "LANGUAGE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/lang/Language;", "getLanguage", "content", "Lcom/intellij/diff/contents/DiffContent;", "getLanguageOrCompute", "project", "Lcom/intellij/openapi/project/Project;", "computeAndCacheLanguage", "", "computeLanguage", "getLanguageByDataKey", "getLanguageByFileType", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nDiffLanguage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffLanguage.kt\ncom/intellij/diff/lang/DiffLanguage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class DiffLanguage {
    @NotNull
    public static final DiffLanguage INSTANCE = new DiffLanguage();
    @NotNull
    private static final Key<Language> LANGUAGE_KEY;

    private DiffLanguage() {
    }

    @Nullable
    public final Language getLanguage(@NotNull DiffContent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Language language = this.getLanguageByDataKey(content);
        if (language == null) {
            language = this.getLanguageByFileType(content);
        }
        return language;
    }

    @JvmStatic
    @RequiresBackgroundThread
    @Nullable
    public static final Language getLanguageOrCompute(@NotNull Project project, @NotNull DiffContent content) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Language language = INSTANCE.getLanguageByDataKey(content);
        if (language != null) {
            return language;
        }
        return INSTANCE.computeLanguage(content, project);
    }

    @JvmStatic
    @RequiresBackgroundThread
    public static final void computeAndCacheLanguage(@NotNull DiffContent content, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Language language = INSTANCE.computeLanguage(content, project);
        if (language != null) {
            content.putUserData(LANGUAGE_KEY, (Object)language);
        }
    }

    private final Language computeLanguage(DiffContent content, Project project) {
        Language languageForPsi;
        Language language;
        Language language2;
        if (project == null) {
            return this.getLanguageByFileType(content);
        }
        FileType fileType = content.getContentType();
        DocumentContent documentContent = content instanceof DocumentContent ? (DocumentContent)content : null;
        if (documentContent != null && (documentContent = documentContent.getHighlightFile()) != null) {
            DocumentContent highlightingFile = documentContent;
            boolean bl = false;
            language2 = (Language)ActionsKt.runReadAction(() -> DiffLanguage.computeLanguage$lambda$0$0(project, (VirtualFile)highlightingFile, fileType));
        } else {
            language2 = null;
        }
        if ((language = (languageForPsi = language2)) == null) {
            language = this.getLanguageByFileType(content);
        }
        return language;
    }

    private final Language getLanguageByDataKey(DiffContent content) {
        return (Language)content.getUserData(LANGUAGE_KEY);
    }

    private final Language getLanguageByFileType(DiffContent content) {
        Language language;
        FileType fileType = content.getContentType();
        if (fileType != null) {
            FileType p0 = fileType;
            boolean bl = false;
            language = LanguageUtil.getFileTypeLanguage((FileType)p0);
        } else {
            language = null;
        }
        return language;
    }

    private static final Language computeLanguage$lambda$0$0(Project $project, VirtualFile $highlightingFile, FileType $fileType) {
        return LanguageUtil.getLanguageForPsi((Project)$project, (VirtualFile)$highlightingFile, (FileType)$fileType);
    }

    static {
        Key key = Key.create((String)"DiffLanguage.Computed");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        LANGUAGE_KEY = key;
    }
}

