/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.settings;

import com.intellij.diff.settings.ExternalToolsModels;
import com.intellij.diff.settings.ExternalToolsTreePanel;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.tools.external.ExternalDiffToolUtil;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PathUtilRt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 32\u00020\u0001:\u00041234B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0002J\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\"\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u001e\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0'0&*\u00020\tH\u0002J&\u0010(\u001a\u00020\u0017*\u00020\t2\u0018\u0010)\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0'0*H\u0002J*\u0010+\u001a\u00020\u0017*\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00065"}, d2={"Lcom/intellij/diff/settings/ExternalToolsTreePanel;", "", "models", "Lcom/intellij/diff/settings/ExternalToolsModels;", "<init>", "(Lcom/intellij/diff/settings/ExternalToolsModels;)V", "treeState", "Lcom/intellij/ide/util/treeView/TreeState;", "treeModel", "Ljavax/swing/tree/DefaultTreeModel;", "root", "Ljavax/swing/tree/DefaultMutableTreeNode;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "onModified", "", "settings", "Lcom/intellij/diff/tools/external/ExternalDiffSettings;", "onApply", "", "onReset", "addTool", "findGroupNode", "externalToolGroup", "Lcom/intellij/diff/tools/external/ExternalDiffSettings$ExternalToolGroup;", "removeData", "editData", "isConfigurationRegistered", "externalTool", "Lcom/intellij/diff/tools/external/ExternalDiffSettings$ExternalTool;", "isExternalToolSelected", "selectionPath", "Ljavax/swing/tree/TreePath;", "toMap", "", "", "update", "value", "", "updateEntities", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/intellij/diff/tools/external/ExternalDiffSettings$ExternalToolConfiguration;", "toolGroup", "oldTool", "newTool", "ExternalToolsTreeCellRenderer", "AddToolDialog", "Companion", "MyTestOutputConsole", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nExternalToolsTreePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalToolsTreePanel.kt\ncom/intellij/diff/settings/ExternalToolsTreePanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,536:1\n1807#2,3:537\n1807#2,3:540\n1915#2,2:544\n1915#2,2:547\n221#3:543\n222#3:546\n*S KotlinDebug\n*F\n+ 1 ExternalToolsTreePanel.kt\ncom/intellij/diff/settings/ExternalToolsTreePanel\n*L\n188#1:537,3\n189#1:540,3\n460#1:544,2\n472#1:547,2\n456#1:543\n456#1:546\n*E\n"})
public final class ExternalToolsTreePanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExternalToolsModels models;
    @NotNull
    private TreeState treeState;
    @NotNull
    private final DefaultTreeModel treeModel;
    @NotNull
    private final DefaultMutableTreeNode root;
    @NotNull
    private final Tree tree;
    @NotNull
    private final JComponent component;
    @NotNull
    private static final String DIFF_TOOL_DEFAULT_ARGUMENT_PATTERN = "%1 %2 %3";
    @NotNull
    private static final String MERGE_TOOL_DEFAULT_ARGUMENT_PATTERN = "%1 %2 %3 %4";

    /*
     * WARNING - void declaration
     */
    public ExternalToolsTreePanel(@NotNull ExternalToolsModels models) {
        void $this$tree_u24lambda_u240;
        Tree tree2;
        Intrinsics.checkNotNullParameter((Object)models, (String)"models");
        this.models = models;
        this.treeModel = this.models.getTreeModel();
        Object object = this.treeModel.getRoot();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        this.root = (DefaultMutableTreeNode)object;
        Tree tree3 = tree2 = new Tree((TreeModel)this.treeModel);
        ExternalToolsTreePanel externalToolsTreePanel = this;
        boolean bl = false;
        $this$tree_u24lambda_u240.setVisibleRowCount(8);
        $this$tree_u24lambda_u240.setRootVisible(false);
        $this$tree_u24lambda_u240.setCellRenderer((TreeCellRenderer)new ExternalToolsTreeCellRenderer());
        TreeState treeState = TreeState.createOn((JTree)((JTree)$this$tree_u24lambda_u240));
        Intrinsics.checkNotNullExpressionValue((Object)treeState, (String)"createOn(...)");
        this.treeState = treeState;
        $this$tree_u24lambda_u240.addMouseListener((MouseListener)new MouseAdapter((Tree)$this$tree_u24lambda_u240, this){
            final /* synthetic */ Tree $this_apply;
            final /* synthetic */ ExternalToolsTreePanel this$0;
            {
                this.$this_apply = $this_apply;
                this.this$0 = $receiver;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
                TreePath treePath = this.$this_apply.getSelectionPath();
                if (treePath == null) {
                    return;
                }
                TreePath treePath2 = treePath;
                if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    mouseEvent.consume();
                    Object object = treePath2.getLastPathComponent();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
                    if (node.getUserObject() instanceof ExternalDiffSettings.ExternalTool) {
                        ExternalToolsTreePanel.access$editData(this.this$0);
                    }
                }
            }
        });
        $this$tree_u24lambda_u240.addTreeExpansionListener(new TreeExpansionListener(this, (Tree)$this$tree_u24lambda_u240){
            final /* synthetic */ ExternalToolsTreePanel this$0;
            final /* synthetic */ Tree $this_apply;
            {
                this.this$0 = $receiver;
                this.$this_apply = $this_apply;
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                TreeState treeState = TreeState.createOn((JTree)((JTree)this.$this_apply));
                Intrinsics.checkNotNullExpressionValue((Object)treeState, (String)"createOn(...)");
                ExternalToolsTreePanel.access$setTreeState$p(this.this$0, treeState);
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                TreeState treeState = TreeState.createOn((JTree)((JTree)this.$this_apply));
                Intrinsics.checkNotNullExpressionValue((Object)treeState, (String)"createOn(...)");
                ExternalToolsTreePanel.access$setTreeState$p(this.this$0, treeState);
            }
        });
        SmartExpander.installOn((JTree)((JTree)$this$tree_u24lambda_u240));
        externalToolsTreePanel.tree = tree2;
        JPanel jPanel = ToolbarDecorator.createDecorator((JTree)((JTree)this.tree)).setAddAction(arg_0 -> ExternalToolsTreePanel._init_$lambda$0(this, arg_0)).setRemoveActionUpdater(arg_0 -> ExternalToolsTreePanel._init_$lambda$1(this, arg_0)).setRemoveAction(arg_0 -> ExternalToolsTreePanel._init_$lambda$2(this, arg_0)).setEditActionUpdater(arg_0 -> ExternalToolsTreePanel._init_$lambda$3(this, arg_0)).setEditAction(arg_0 -> ExternalToolsTreePanel._init_$lambda$4(this, arg_0)).disableUpDownActions().createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel decoratedTree = jPanel;
        this.component = decoratedTree;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    public final boolean onModified(@NotNull ExternalDiffSettings settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        return !Intrinsics.areEqual(this.toMap(this.treeModel), settings.getExternalTools());
    }

    public final void onApply(@NotNull ExternalDiffSettings settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        settings.setExternalTools(this.toMap(this.treeModel));
        TreeState treeState = TreeState.createOn((JTree)((JTree)this.tree));
        Intrinsics.checkNotNullExpressionValue((Object)treeState, (String)"createOn(...)");
        this.treeState = treeState;
    }

    public final void onReset(@NotNull ExternalDiffSettings settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        this.update(this.treeModel, settings.getExternalTools());
        this.treeState.applyTo((JTree)this.tree);
    }

    private final void addTool() {
        AddToolDialog dialog = new AddToolDialog(this, null, false, 3, null);
        if (dialog.showAndGet()) {
            ExternalDiffSettings.ExternalTool tool = dialog.createExternalTool();
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(tool);
            DefaultMutableTreeNode groupNode = this.findGroupNode(dialog.getToolGroup());
            this.treeModel.insertNodeInto(node, groupNode, groupNode.getChildCount());
            this.treeModel.nodeChanged(this.root);
            this.tree.expandPath(new TreePath(groupNode.getPath()));
        }
    }

    private final DefaultMutableTreeNode findGroupNode(ExternalDiffSettings.ExternalToolGroup externalToolGroup) {
        Enumeration<TreeNode> enumeration = this.root.children();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"children(...)");
        Iterator iterator = CollectionsKt.iterator(enumeration);
        while (iterator.hasNext()) {
            TreeNode child = (TreeNode)iterator.next();
            Intrinsics.checkNotNull((Object)child, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)child;
            Object object = treeNode.getUserObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.diff.tools.external.ExternalDiffSettings.ExternalToolGroup");
            ExternalDiffSettings.ExternalToolGroup valueNode = (ExternalDiffSettings.ExternalToolGroup)((Object)object);
            if (valueNode != externalToolGroup) continue;
            return treeNode;
        }
        DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode((Object)externalToolGroup);
        this.treeModel.insertNodeInto(groupNode, this.root, this.root.getChildCount());
        return groupNode;
    }

    private final void removeData() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        TreePath treePath2 = treePath;
        Object object = treePath2.getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
        Object object2 = treePath2.getParentPath().getLastPathComponent();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)object2;
        Object object3 = parentNode.getUserObject();
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.intellij.diff.tools.external.ExternalDiffSettings.ExternalToolGroup");
        ExternalDiffSettings.ExternalToolGroup toolGroup = (ExternalDiffSettings.ExternalToolGroup)((Object)object3);
        Object object4 = node.getUserObject();
        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type com.intellij.diff.tools.external.ExternalDiffSettings.ExternalTool");
        ExternalDiffSettings.ExternalTool externalTool = (ExternalDiffSettings.ExternalTool)object4;
        if (this.isConfigurationRegistered(externalTool, toolGroup)) {
            Messages.showWarningDialog((String)DiffBundle.message((String)"settings.external.tool.tree.remove.warning.message", (Object[])new Object[0]), (String)DiffBundle.message((String)"settings.external.tool.tree.remove.warning.title", (Object[])new Object[0]));
            return;
        }
        String string = DiffBundle.message((String)"settings.external.diff.table.remove.dialog.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = DiffBundle.message((String)"settings.external.diff.table.remove.dialog.message", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        OkCancelDialogBuilder dialog = MessageDialogBuilder.Companion.okCancel(string, string2);
        if (dialog.guessWindowAndAsk()) {
            this.treeModel.removeNodeFromParent(node);
            if (parentNode.getChildCount() == 0) {
                this.treeModel.removeNodeFromParent(parentNode);
            }
        }
    }

    private final void editData() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        TreePath treePath2 = treePath;
        Object object = treePath2.getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
        if (!(node.getUserObject() instanceof ExternalDiffSettings.ExternalTool)) {
            return;
        }
        Object object2 = node.getUserObject();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.diff.tools.external.ExternalDiffSettings.ExternalTool");
        ExternalDiffSettings.ExternalTool currentTool = (ExternalDiffSettings.ExternalTool)object2;
        AddToolDialog dialog = new AddToolDialog(this, currentTool);
        if (dialog.showAndGet()) {
            ExternalDiffSettings.ExternalTool editedTool = dialog.createExternalTool();
            DefaultMutableTreeNode groupNode = this.findGroupNode(dialog.getToolGroup());
            Object object3 = groupNode.getUserObject();
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.intellij.diff.tools.external.ExternalDiffSettings.ExternalToolGroup");
            ExternalDiffSettings.ExternalToolGroup toolGroup = (ExternalDiffSettings.ExternalToolGroup)((Object)object3);
            node.setUserObject(editedTool);
            this.treeModel.nodeChanged(node);
            this.updateEntities(this.models.getTableModel(), toolGroup, currentTool, editedTool);
        }
    }

    private final boolean isConfigurationRegistered(ExternalDiffSettings.ExternalTool externalTool, ExternalDiffSettings.ExternalToolGroup externalToolGroup) {
        List list = this.models.getTableModel().getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        List configurations = list;
        return switch (WhenMappings.$EnumSwitchMapping$0[externalToolGroup.ordinal()]) {
            case 1 -> {
                Iterable $this$any$iv = configurations;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    yield false;
                }
                for (Object element$iv : $this$any$iv) {
                    ExternalDiffSettings.ExternalToolConfiguration it = (ExternalDiffSettings.ExternalToolConfiguration)element$iv;
                    boolean $i$a$-any-ExternalToolsTreePanel$isConfigurationRegistered$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getDiffToolName(), (Object)externalTool.getName())) continue;
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                Iterable $this$any$iv = configurations;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    yield false;
                }
                for (Object element$iv : $this$any$iv) {
                    ExternalDiffSettings.ExternalToolConfiguration it = (ExternalDiffSettings.ExternalToolConfiguration)element$iv;
                    boolean $i$a$-any-ExternalToolsTreePanel$isConfigurationRegistered$2 = false;
                    if (!Intrinsics.areEqual((Object)it.getMergeToolName(), (Object)externalTool.getName())) continue;
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean isExternalToolSelected(TreePath selectionPath) {
        if (selectionPath == null) {
            return false;
        }
        Object object = selectionPath.getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
        return node.getUserObject() instanceof ExternalDiffSettings.ExternalTool;
    }

    private final Map<ExternalDiffSettings.ExternalToolGroup, List<ExternalDiffSettings.ExternalTool>> toMap(DefaultTreeModel $this$toMap) {
        Object object = $this$toMap.getRoot();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)object;
        Map model = new LinkedHashMap();
        Enumeration<TreeNode> enumeration = root.children();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"children(...)");
        Iterator iterator = CollectionsKt.iterator(enumeration);
        while (iterator.hasNext()) {
            TreeNode group = (TreeNode)iterator.next();
            if (group.getChildCount() == 0) continue;
            Intrinsics.checkNotNull((Object)group, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)group;
            List tools = new ArrayList();
            Enumeration<TreeNode> enumeration2 = ((DefaultMutableTreeNode)group).children();
            Intrinsics.checkNotNullExpressionValue(enumeration2, (String)"children(...)");
            Object object2 = CollectionsKt.iterator(enumeration2);
            while (object2.hasNext()) {
                TreeNode child = (TreeNode)object2.next();
                Intrinsics.checkNotNull((Object)child, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)child;
                Object object3 = childNode.getUserObject();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.intellij.diff.tools.external.ExternalDiffSettings.ExternalTool");
                ExternalDiffSettings.ExternalTool tool = (ExternalDiffSettings.ExternalTool)object3;
                tools.add(tool);
            }
            object2 = model;
            Object object4 = groupNode.getUserObject();
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type com.intellij.diff.tools.external.ExternalDiffSettings.ExternalToolGroup");
            object2.put((ExternalDiffSettings.ExternalToolGroup)((Object)object4), tools);
        }
        return model;
    }

    private final void update(DefaultTreeModel $this$update, Map<ExternalDiffSettings.ExternalToolGroup, ? extends List<ExternalDiffSettings.ExternalTool>> value) {
        Object object = $this$update.getRoot();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)object;
        root.removeAllChildren();
        Map $this$forEach$iv = MapsKt.toSortedMap(value);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            ExternalDiffSettings.ExternalToolGroup group = (ExternalDiffSettings.ExternalToolGroup)((Object)entry.getKey());
            List tools = (List)entry.getValue();
            if (tools.isEmpty()) continue;
            DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode((Object)group);
            Intrinsics.checkNotNull((Object)tools);
            Iterable $this$forEach$iv2 = tools;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ExternalDiffSettings.ExternalTool it = (ExternalDiffSettings.ExternalTool)element$iv2;
                boolean bl2 = false;
                groupNode.add(new DefaultMutableTreeNode(it));
            }
            $this$update.insertNodeInto(groupNode, root, root.getChildCount());
        }
        $this$update.nodeStructureChanged(root);
    }

    private final void updateEntities(ListTableModel<ExternalDiffSettings.ExternalToolConfiguration> $this$updateEntities, ExternalDiffSettings.ExternalToolGroup toolGroup, ExternalDiffSettings.ExternalTool oldTool, ExternalDiffSettings.ExternalTool newTool) {
        List list = $this$updateEntities.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExternalDiffSettings.ExternalToolConfiguration configuration = (ExternalDiffSettings.ExternalToolConfiguration)element$iv;
            boolean bl = false;
            if (toolGroup == ExternalDiffSettings.ExternalToolGroup.DIFF_TOOL) {
                if (!Intrinsics.areEqual((Object)configuration.getDiffToolName(), (Object)oldTool.getName())) continue;
                configuration.setDiffToolName(newTool.getName());
                continue;
            }
            if (!Intrinsics.areEqual((Object)configuration.getMergeToolName(), (Object)oldTool.getName())) continue;
            configuration.setMergeToolName(newTool.getName());
        }
    }

    private static final void _init_$lambda$0(ExternalToolsTreePanel this$0, AnActionButton it) {
        this$0.addTool();
    }

    private static final boolean _init_$lambda$1(ExternalToolsTreePanel this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isExternalToolSelected(this$0.tree.getSelectionPath());
    }

    private static final void _init_$lambda$2(ExternalToolsTreePanel this$0, AnActionButton it) {
        this$0.removeData();
    }

    private static final boolean _init_$lambda$3(ExternalToolsTreePanel this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isExternalToolSelected(this$0.tree.getSelectionPath());
    }

    private static final void _init_$lambda$4(ExternalToolsTreePanel this$0, AnActionButton it) {
        this$0.editData();
    }

    public static final /* synthetic */ void access$editData(ExternalToolsTreePanel $this) {
        $this.editData();
    }

    public static final /* synthetic */ void access$setTreeState$p(ExternalToolsTreePanel $this, TreeState treeState) {
        $this.treeState = treeState;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\b\u0010\u001f\u001a\u00020 H\u0014J\u0006\u0010!\u001a\u00020\tJ\u0006\u0010\"\u001a\u00020\rJ\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u0003H\u0002J\u0018\u0010'\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u0003H\u0002J\u0010\u0010(\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\rH\u0003J\b\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020*H\u0002J\b\u0010,\u001a\u00020*H\u0002J\b\u0010-\u001a\u00020.H\u0003R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/diff/settings/ExternalToolsTreePanel$AddToolDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "oldToolName", "", "isEditMode", "", "<init>", "(Lcom/intellij/diff/settings/ExternalToolsTreePanel;Ljava/lang/String;Z)V", "externalTool", "Lcom/intellij/diff/tools/external/ExternalDiffSettings$ExternalTool;", "(Lcom/intellij/diff/settings/ExternalToolsTreePanel;Lcom/intellij/diff/tools/external/ExternalDiffSettings$ExternalTool;)V", "groupField", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/diff/tools/external/ExternalDiffSettings$ExternalToolGroup;", "kotlin.jvm.PlatformType", "isAutocompleteToolName", "toolNameField", "Lcom/intellij/ui/components/JBTextField;", "programPathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "argumentPatternField", "isMergeTrustExitCode", "Lcom/intellij/ui/components/JBCheckBox;", "testDiffButton", "Ljavax/swing/JButton;", "testThreeSideDiffButton", "testMergeButton", "toolOutputEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "toolOutputConsole", "Lcom/intellij/diff/settings/ExternalToolsTreePanel$MyTestOutputConsole;", "createCenterPanel", "Ljavax/swing/JComponent;", "createExternalTool", "getToolGroup", "toolFieldValidation", "Lcom/intellij/openapi/ui/ValidationInfo;", "toolGroup", "toolName", "isToolAlreadyExist", "createDescription", "showTestDiff", "", "showTestThreeDiff", "showTestMerge", "resetToolOutputConsole", "Lcom/intellij/diff/tools/external/ExternalDiffToolUtil$TestOutputConsole;", "intellij.platform.diff.impl"})
    @SourceDebugExtension(value={"SMAP\nExternalToolsTreePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalToolsTreePanel.kt\ncom/intellij/diff/settings/ExternalToolsTreePanel$AddToolDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,536:1\n1#2:537\n*E\n"})
    private final class AddToolDialog
    extends DialogWrapper {
        @Nullable
        private final String oldToolName;
        private final boolean isEditMode;
        @NotNull
        private final ComboBox<ExternalDiffSettings.ExternalToolGroup> groupField;
        private boolean isAutocompleteToolName;
        @NotNull
        private final JBTextField toolNameField;
        @NotNull
        private final TextFieldWithBrowseButton programPathField;
        @NotNull
        private final JBTextField argumentPatternField;
        @NotNull
        private final JBCheckBox isMergeTrustExitCode;
        @NotNull
        private final JButton testDiffButton;
        @NotNull
        private final JButton testThreeSideDiffButton;
        @NotNull
        private final JButton testMergeButton;
        @NotNull
        private final EditorEx toolOutputEditor;
        @Nullable
        private MyTestOutputConsole toolOutputConsole;
        final /* synthetic */ ExternalToolsTreePanel this$0;

        /*
         * WARNING - void declaration
         */
        public AddToolDialog(@Nullable ExternalToolsTreePanel this$0, String oldToolName, boolean isEditMode) {
            void it;
            void $this$testMergeButton_u24lambda_u240;
            Object $this$testThreeSideDiffButton_u24lambda_u240;
            Object $this$testDiffButton_u24lambda_u240;
            Object $this$programPathField_u24lambda_u240;
            ComboBox $this$toolNameField_u24lambda_u240;
            ComboBox $this$groupField_u24lambda_u240;
            this.this$0 = this$0;
            super(null);
            this.oldToolName = oldToolName;
            this.isEditMode = isEditMode;
            Object object = new ComboBox[]{ExternalDiffSettings.ExternalToolGroup.DIFF_TOOL, ExternalDiffSettings.ExternalToolGroup.MERGE_TOOL};
            ComboBox comboBox = object = new ComboBox((Object[])object);
            AddToolDialog addToolDialog = this;
            boolean bl = false;
            $this$groupField_u24lambda_u240.setRenderer((ListCellRenderer)new ColoredListCellRenderer<ExternalDiffSettings.ExternalToolGroup>(){

                protected void customizeCellRenderer(JList<? extends ExternalDiffSettings.ExternalToolGroup> list, ExternalDiffSettings.ExternalToolGroup value, int index, boolean selected, boolean hasFocus) {
                    Intrinsics.checkNotNullParameter(list, (String)"list");
                    Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
                    this.append(value.getGroupName());
                }
            });
            addToolDialog.groupField = object;
            this.isAutocompleteToolName = true;
            $this$groupField_u24lambda_u240 = object = new JBTextField();
            addToolDialog = this;
            boolean bl2 = false;
            $this$toolNameField_u24lambda_u240.getDocument().addDocumentListener(new DocumentListener((JBTextField)$this$toolNameField_u24lambda_u240, this){
                final /* synthetic */ JBTextField $this_apply;
                final /* synthetic */ AddToolDialog this$0;
                {
                    this.$this_apply = $this_apply;
                    this.this$0 = $receiver;
                }

                public void insertUpdate(DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (this.$this_apply.isFocusOwner()) {
                        AddToolDialog.access$setAutocompleteToolName$p(this.this$0, false);
                    }
                }

                public void removeUpdate(DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                }

                public void changedUpdate(DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                }
            });
            addToolDialog.toolNameField = object;
            $this$toolNameField_u24lambda_u240 = object = new TextFieldWithBrowseButton();
            addToolDialog = this;
            boolean bl3 = false;
            $this$programPathField_u24lambda_u240.addBrowseFolderListener(null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(DiffBundle.message((String)"select.external.program.dialog.title", (Object[])new Object[0])));
            $this$programPathField_u24lambda_u240.getTextField().getDocument().addDocumentListener(new DocumentListener(this, (TextFieldWithBrowseButton)$this$programPathField_u24lambda_u240){
                final /* synthetic */ AddToolDialog this$0;
                final /* synthetic */ TextFieldWithBrowseButton $this_apply;
                {
                    this.this$0 = $receiver;
                    this.$this_apply = $this_apply;
                }

                public void insertUpdate(DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (AddToolDialog.access$isAutocompleteToolName$p(this.this$0)) {
                        String string = StringUtil.capitalize((String)PathUtilRt.getFileName((String)this.$this_apply.getText()));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"capitalize(...)");
                        String guessToolName = string;
                        AddToolDialog.access$getToolNameField$p(this.this$0).setText(guessToolName);
                    }
                }

                public void removeUpdate(DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                }

                public void changedUpdate(DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                }
            });
            addToolDialog.programPathField = object;
            this.argumentPatternField = new JBTextField(ExternalToolsTreePanel.DIFF_TOOL_DEFAULT_ARGUMENT_PATTERN);
            this.isMergeTrustExitCode = new JBCheckBox(DiffBundle.message((String)"settings.external.diff.trust.process.exit.code", (Object[])new Object[0]));
            $this$programPathField_u24lambda_u240 = object = new JButton(DiffBundle.message((String)"settings.external.diff.test.diff", (Object[])new Object[0]));
            addToolDialog = this;
            boolean bl4 = false;
            $this$testDiffButton_u24lambda_u240.addActionListener(arg_0 -> AddToolDialog.testDiffButton$lambda$0$0(this, arg_0));
            addToolDialog.testDiffButton = object;
            $this$testDiffButton_u24lambda_u240 = object = new JButton(DiffBundle.message((String)"settings.external.diff.test.three.side.diff", (Object[])new Object[0]));
            addToolDialog = this;
            boolean bl5 = false;
            $this$testThreeSideDiffButton_u24lambda_u240.addActionListener(arg_0 -> AddToolDialog.testThreeSideDiffButton$lambda$0$0(this, arg_0));
            addToolDialog.testThreeSideDiffButton = object;
            $this$testThreeSideDiffButton_u24lambda_u240 = object = new JButton(DiffBundle.message((String)"settings.external.diff.test.merge", (Object[])new Object[0]));
            addToolDialog = this;
            boolean $i$a$-apply-ExternalToolsTreePanel$AddToolDialog$testMergeButton$22 = false;
            $this$testMergeButton_u24lambda_u240.addActionListener(arg_0 -> AddToolDialog.testMergeButton$lambda$0$0(this, arg_0));
            addToolDialog.testMergeButton = object;
            ComboBox $i$a$-apply-ExternalToolsTreePanel$AddToolDialog$testMergeButton$22 = comboBox = ConsoleViewUtil.setupConsoleEditor(null, (boolean)false, (boolean)false);
            addToolDialog = this;
            boolean bl6 = false;
            it.getSettings().setAdditionalLinesCount(3);
            ComboBox comboBox2 = comboBox;
            Intrinsics.checkNotNullExpressionValue((Object)comboBox2, (String)"also(...)");
            addToolDialog.toolOutputEditor = comboBox2;
            this.setTitle(DiffBundle.message((String)"settings.external.tool.tree.add.dialog.title", (Object[])new Object[0]));
            Disposer.register((Disposable)this.getDisposable(), () -> AddToolDialog._init_$lambda$0(this));
            this.init();
        }

        public /* synthetic */ AddToolDialog(ExternalToolsTreePanel externalToolsTreePanel, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            this(externalToolsTreePanel, string, bl);
        }

        public AddToolDialog(@NotNull ExternalToolsTreePanel this$0, ExternalDiffSettings.ExternalTool externalTool) {
            Intrinsics.checkNotNullParameter((Object)externalTool, (String)"externalTool");
            this(this$0, externalTool.getName(), true);
            this.isAutocompleteToolName = false;
            this.toolNameField.setText(externalTool.getName());
            this.programPathField.setText(externalTool.getProgramPath());
            this.argumentPatternField.setText(externalTool.getArgumentPattern());
            this.isMergeTrustExitCode.setSelected(externalTool.isMergeTrustExitCode());
            this.groupField.setSelectedItem((Object)externalTool.getGroupName());
            this.setTitle(DiffBundle.message((String)"settings.external.tool.tree.edit.dialog.title", (Object[])new Object[0]));
        }

        @NotNull
        protected JComponent createCenterPanel() {
            return (JComponent)BuilderKt.panel(arg_0 -> AddToolDialog.createCenterPanel$lambda$0(this, arg_0));
        }

        @NotNull
        public final ExternalDiffSettings.ExternalTool createExternalTool() {
            String string = this.toolNameField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = this.programPathField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String string3 = this.argumentPatternField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            boolean bl = this.isMergeTrustExitCode.isVisible() && this.isMergeTrustExitCode.isSelected();
            Object object = this.groupField.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
            return new ExternalDiffSettings.ExternalTool(string, string2, string3, bl, (ExternalDiffSettings.ExternalToolGroup)((Object)object));
        }

        @NotNull
        public final ExternalDiffSettings.ExternalToolGroup getToolGroup() {
            Object object = this.groupField.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
            return (ExternalDiffSettings.ExternalToolGroup)((Object)object);
        }

        private final ValidationInfo toolFieldValidation(ExternalDiffSettings.ExternalToolGroup toolGroup, String toolName) {
            if (((CharSequence)toolName).length() == 0) {
                return new ValidationInfo(DiffBundle.message((String)"settings.external.tool.tree.validation.empty", (Object[])new Object[0]));
            }
            if (this.isToolAlreadyExist(toolGroup, toolName) && !Intrinsics.areEqual((Object)toolName, (Object)this.oldToolName)) {
                Object[] objectArray = new Object[]{toolGroup, toolName};
                return new ValidationInfo(DiffBundle.message((String)"settings.external.tool.tree.validation.already.exist", (Object[])objectArray));
            }
            return null;
        }

        private final boolean isToolAlreadyExist(ExternalDiffSettings.ExternalToolGroup toolGroup, String toolName) {
            DefaultMutableTreeNode isNodeExist = TreeUtil.findNode((DefaultMutableTreeNode)this.this$0.findGroupNode(toolGroup), arg_0 -> AddToolDialog.isToolAlreadyExist$lambda$1(arg_0 -> AddToolDialog.isToolAlreadyExist$lambda$0(toolName, arg_0), arg_0));
            return isNodeExist != null;
        }

        @NlsContexts.DetailedDescription
        private final String createDescription(ExternalDiffSettings.ExternalToolGroup toolGroup) {
            String string = DiffBundle.message((String)"settings.external.tools.parameters.description", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String title = string;
            String string2 = switch (WhenMappings.$EnumSwitchMapping$0[toolGroup.ordinal()]) {
                case 1 -> DiffBundle.message((String)"settings.external.tools.parameters.diff", (Object[])new Object[0]);
                case 2 -> DiffBundle.message((String)"settings.external.tools.parameters.merge", (Object[])new Object[0]);
                default -> throw new NoWhenBranchMatchedException();
            };
            Intrinsics.checkNotNull((Object)string2);
            String argumentPattern = string2;
            return title + "<br>" + argumentPattern;
        }

        private final void showTestDiff() {
            ExternalDiffToolUtil.testDiffTool2(null, this.createExternalTool(), this.resetToolOutputConsole());
        }

        private final void showTestThreeDiff() {
            ExternalDiffToolUtil.testDiffTool3(null, this.createExternalTool(), this.resetToolOutputConsole());
        }

        private final void showTestMerge() {
            ExternalDiffToolUtil.testMergeTool(null, this.createExternalTool(), this.resetToolOutputConsole());
        }

        @RequiresEdt
        private final ExternalDiffToolUtil.TestOutputConsole resetToolOutputConsole() {
            MyTestOutputConsole myTestOutputConsole = this.toolOutputConsole;
            if (myTestOutputConsole != null) {
                MyTestOutputConsole it = myTestOutputConsole;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            MyTestOutputConsole myTestOutputConsole2 = this.toolOutputConsole = new MyTestOutputConsole((Editor)this.toolOutputEditor);
            Intrinsics.checkNotNull((Object)myTestOutputConsole2);
            return myTestOutputConsole2;
        }

        private static final void testDiffButton$lambda$0$0(AddToolDialog this$0, ActionEvent it) {
            this$0.showTestDiff();
        }

        private static final void testThreeSideDiffButton$lambda$0$0(AddToolDialog this$0, ActionEvent it) {
            this$0.showTestThreeDiff();
        }

        private static final void testMergeButton$lambda$0$0(AddToolDialog this$0, ActionEvent it) {
            this$0.showTestMerge();
        }

        private static final void _init_$lambda$0(AddToolDialog this$0) {
            MyTestOutputConsole myTestOutputConsole = this$0.toolOutputConsole;
            if (myTestOutputConsole != null) {
                MyTestOutputConsole it = myTestOutputConsole;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            EditorFactory.getInstance().releaseEditor((Editor)this$0.toolOutputEditor);
        }

        private static final ValidationInfo createCenterPanel$lambda$0$2$0(AddToolDialog this$0, ValidationInfoBuilder $this$validationOnApply, JBTextField it) {
            Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Object object = this$0.groupField.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
            ExternalDiffSettings.ExternalToolGroup externalToolGroup = (ExternalDiffSettings.ExternalToolGroup)((Object)object);
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return this$0.toolFieldValidation(externalToolGroup, string);
        }

        private static final Unit createCenterPanel$lambda$0$7$0(JComponent $this$applyToComponent) {
            Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
            $this$applyToComponent.setPreferredSize((Dimension)JBUI.size((int)400, (int)150));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$0(AddToolDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.cell((JComponent)this$0.groupField).align((Align)AlignX.FILL.INSTANCE);
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$1(AddToolDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.cell((JComponent)this$0.programPathField).align((Align)AlignX.FILL.INSTANCE);
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$2(AddToolDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.cell((JComponent)this$0.toolNameField).align((Align)AlignX.FILL.INSTANCE).validationOnApply((arg_0, arg_1) -> AddToolDialog.createCenterPanel$lambda$0$2$0(this$0, arg_0, arg_1));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$3(AddToolDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.cell((JComponent)this$0.argumentPatternField).align((Align)AlignX.FILL.INSTANCE);
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$4(AddToolDialog this$0, Ref.ObjectRef $argumentPatternDescription, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.cell((JComponent)this$0.isMergeTrustExitCode).align((Align)AlignX.FILL.INSTANCE).visibleIf(new ComponentPredicate(this$0, (Ref.ObjectRef<JEditorPane>)$argumentPatternDescription){
                final /* synthetic */ AddToolDialog this$0;
                final /* synthetic */ Ref.ObjectRef<JEditorPane> $argumentPatternDescription;
                {
                    this.this$0 = $receiver;
                    this.$argumentPatternDescription = $argumentPatternDescription;
                }

                public void addListener(Function1<? super Boolean, Unit> listener) {
                    Intrinsics.checkNotNullParameter(listener, (String)"listener");
                    AddToolDialog.access$getGroupField$p(this.this$0).addItemListener(arg_0 -> createCenterPanel.1.5.1.addListener$lambda$0(this, this.this$0, this.$argumentPatternDescription, listener, arg_0));
                }

                public Boolean invoke() {
                    Object object = AddToolDialog.access$getGroupField$p(this.this$0).getSelectedItem();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.diff.tools.external.ExternalDiffSettings.ExternalToolGroup");
                    ExternalDiffSettings.ExternalToolGroup item = (ExternalDiffSettings.ExternalToolGroup)((Object)object);
                    return item == ExternalDiffSettings.ExternalToolGroup.MERGE_TOOL;
                }

                private static final void addListener$lambda$0(createCenterPanel.1.5.1 this$0, AddToolDialog this$1, Ref.ObjectRef $argumentPatternDescription, Function1 $listener, ItemEvent it) {
                    JEditorPane jEditorPane;
                    boolean isMergeGroup = this$0.invoke();
                    AddToolDialog.access$getTestDiffButton$p(this$1).setVisible(!isMergeGroup);
                    AddToolDialog.access$getTestThreeSideDiffButton$p(this$1).setVisible(!isMergeGroup);
                    AddToolDialog.access$getTestMergeButton$p(this$1).setVisible(isMergeGroup);
                    if (!AddToolDialog.access$isEditMode$p(this$1)) {
                        AddToolDialog.access$getArgumentPatternField$p(this$1).setText(isMergeGroup ? "%1 %2 %3 %4" : "%1 %2 %3");
                    }
                    if ($argumentPatternDescription.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"argumentPatternDescription");
                        jEditorPane = null;
                    } else {
                        jEditorPane = (JEditorPane)$argumentPatternDescription.element;
                    }
                    jEditorPane.setText(isMergeGroup ? AddToolDialog.access$createDescription(this$1, ExternalDiffSettings.ExternalToolGroup.MERGE_TOOL) : AddToolDialog.access$createDescription(this$1, ExternalDiffSettings.ExternalToolGroup.DIFF_TOOL));
                    $listener.invoke((Object)isMergeGroup);
                }
            });
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$5(Ref.ObjectRef $argumentPatternDescription, AddToolDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $argumentPatternDescription.element = Row.comment$default((Row)$this$row, (String)this$0.createDescription(ExternalDiffSettings.ExternalToolGroup.DIFF_TOOL), (int)70, null, (int)4, null).getComponent();
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$6(AddToolDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            boolean isMergeGroup = this$0.isMergeTrustExitCode.isVisible();
            $this$row.cell((JComponent)this$0.testDiffButton).visible(!isMergeGroup);
            $this$row.cell((JComponent)this$0.testThreeSideDiffButton).visible(!isMergeGroup);
            $this$row.cell((JComponent)this$0.testMergeButton).visible(isMergeGroup);
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$7(AddToolDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            JComponent jComponent = this$0.toolOutputEditor.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            $this$row.cell(jComponent).align(Align.FILL).applyToComponent(AddToolDialog::createCenterPanel$lambda$0$7$0);
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0(AddToolDialog this$0, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            Ref.ObjectRef argumentPatternDescription = new Ref.ObjectRef();
            String string = DiffBundle.message((String)"settings.external.tool.tree.add.dialog.field.group", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$panel.row(string, arg_0 -> AddToolDialog.createCenterPanel$lambda$0$0(this$0, arg_0)).visible(!this$0.isEditMode);
            String string2 = DiffBundle.message((String)"settings.external.tool.tree.add.dialog.field.program.path", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            $this$panel.row(string2, arg_0 -> AddToolDialog.createCenterPanel$lambda$0$1(this$0, arg_0));
            String string3 = DiffBundle.message((String)"settings.external.tool.tree.add.dialog.field.tool.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            $this$panel.row(string3, arg_0 -> AddToolDialog.createCenterPanel$lambda$0$2(this$0, arg_0));
            String string4 = DiffBundle.message((String)"settings.external.tool.tree.add.dialog.field.argument.pattern", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            $this$panel.row(string4, arg_0 -> AddToolDialog.createCenterPanel$lambda$0$3(this$0, arg_0));
            Panel.row$default((Panel)$this$panel, null, arg_0 -> AddToolDialog.createCenterPanel$lambda$0$4(this$0, argumentPatternDescription, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> AddToolDialog.createCenterPanel$lambda$0$5(argumentPatternDescription, this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> AddToolDialog.createCenterPanel$lambda$0$6(this$0, arg_0), (int)1, null).topGap(TopGap.MEDIUM);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> AddToolDialog.createCenterPanel$lambda$0$7(this$0, arg_0), (int)1, null).resizableRow();
            return Unit.INSTANCE;
        }

        private static final boolean isToolAlreadyExist$lambda$0(String $toolName, DefaultMutableTreeNode node) {
            Object externalTool = node.getUserObject();
            return externalTool instanceof ExternalDiffSettings.ExternalTool ? Intrinsics.areEqual((Object)((ExternalDiffSettings.ExternalTool)externalTool).getName(), (Object)$toolName) : false;
        }

        private static final boolean isToolAlreadyExist$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ void access$setAutocompleteToolName$p(AddToolDialog $this, boolean bl) {
            $this.isAutocompleteToolName = bl;
        }

        public static final /* synthetic */ boolean access$isAutocompleteToolName$p(AddToolDialog $this) {
            return $this.isAutocompleteToolName;
        }

        public static final /* synthetic */ JBTextField access$getToolNameField$p(AddToolDialog $this) {
            return $this.toolNameField;
        }

        public static final /* synthetic */ ComboBox access$getGroupField$p(AddToolDialog $this) {
            return $this.groupField;
        }

        public static final /* synthetic */ JButton access$getTestDiffButton$p(AddToolDialog $this) {
            return $this.testDiffButton;
        }

        public static final /* synthetic */ JButton access$getTestThreeSideDiffButton$p(AddToolDialog $this) {
            return $this.testThreeSideDiffButton;
        }

        public static final /* synthetic */ JButton access$getTestMergeButton$p(AddToolDialog $this) {
            return $this.testMergeButton;
        }

        public static final /* synthetic */ boolean access$isEditMode$p(AddToolDialog $this) {
            return $this.isEditMode;
        }

        public static final /* synthetic */ JBTextField access$getArgumentPatternField$p(AddToolDialog $this) {
            return $this.argumentPatternField;
        }

        public static final /* synthetic */ String access$createDescription(AddToolDialog $this, ExternalDiffSettings.ExternalToolGroup toolGroup) {
            return $this.createDescription(toolGroup);
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ExternalDiffSettings.ExternalToolGroup.values().length];
                try {
                    nArray[ExternalDiffSettings.ExternalToolGroup.DIFF_TOOL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExternalDiffSettings.ExternalToolGroup.MERGE_TOOL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/diff/settings/ExternalToolsTreePanel$Companion;", "", "<init>", "()V", "DIFF_TOOL_DEFAULT_ARGUMENT_PATTERN", "", "MERGE_TOOL_DEFAULT_ARGUMENT_PATTERN", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/diff/settings/ExternalToolsTreePanel$ExternalToolsTreeCellRenderer;", "Ljavax/swing/tree/TreeCellRenderer;", "<init>", "()V", "renderer", "Lcom/intellij/ui/SimpleColoredComponent;", "getTreeCellRendererComponent", "Ljava/awt/Component;", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.platform.diff.impl"})
    private static final class ExternalToolsTreeCellRenderer
    implements TreeCellRenderer {
        @NotNull
        private final SimpleColoredComponent renderer = new SimpleColoredComponent();

        @Override
        @NotNull
        public Component getTreeCellRendererComponent(@NotNull JTree tree2, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            SimpleColoredComponent simpleColoredComponent;
            Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            SimpleColoredComponent $this$getTreeCellRendererComponent_u24lambda_u240 = simpleColoredComponent = this.renderer;
            boolean bl = false;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object userObject = node.getUserObject();
            String text = userObject == null ? "" : (userObject instanceof ExternalDiffSettings.ExternalToolGroup ? ((ExternalDiffSettings.ExternalToolGroup)((Object)userObject)).getGroupName() : (userObject instanceof ExternalDiffSettings.ExternalTool ? ((ExternalDiffSettings.ExternalTool)userObject).getName() : userObject.toString()));
            $this$getTreeCellRendererComponent_u24lambda_u240.clear();
            $this$getTreeCellRendererComponent_u24lambda_u240.append(text);
            return (Component)simpleColoredComponent;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\rH\u0002J\b\u0010\u001d\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/diff/settings/ExternalToolsTreePanel$MyTestOutputConsole;", "Lcom/intellij/diff/tools/external/ExternalDiffToolUtil$TestOutputConsole;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "document", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/NotNull;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "isDisposed", "", "wasTerminated", "getComponent", "Ljavax/swing/JComponent;", "appendOutput", "", "outputType", "Lcom/intellij/openapi/util/Key;", "line", "", "processTerminated", "exitCode", "", "appendText", "text", "isTermination", "dispose", "intellij.platform.diff.impl"})
    private static final class MyTestOutputConsole
    implements ExternalDiffToolUtil.TestOutputConsole,
    Disposable {
        @NotNull
        private final Editor editor;
        @NotNull
        private final Document document;
        @NotNull
        private final ModalityState modalityState;
        private boolean isDisposed;
        private boolean wasTerminated;

        public MyTestOutputConsole(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
            Document document = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            this.document = document;
            ModalityState modalityState = ModalityState.stateForComponent((Component)this.editor.getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
            this.modalityState = modalityState;
            this.document.setText((CharSequence)"");
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.editor.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            return jComponent;
        }

        @Override
        public void appendOutput(@NotNull Key<?> outputType, @NotNull String line) {
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            this.appendText(outputType + ": " + line, false);
        }

        @Override
        public void processTerminated(int exitCode) {
            Object[] objectArray = new Object[]{exitCode};
            String string = DiffBundle.message((String)"settings.external.tools.test.process.exit.text", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.appendText(string, true);
        }

        private final void appendText(String text, boolean isTermination) {
            ActionsKt.runInEdt((ModalityState)this.modalityState, () -> MyTestOutputConsole.appendText$lambda$0(this, isTermination, text));
        }

        public void dispose() {
            this.isDisposed = true;
        }

        private static final Unit appendText$lambda$0(MyTestOutputConsole this$0, boolean $isTermination, String $text) {
            if (this$0.isDisposed) {
                return Unit.INSTANCE;
            }
            if ($isTermination) {
                this$0.wasTerminated = true;
            }
            int offset = !$isTermination && this$0.wasTerminated && this$0.document.getLineCount() > 1 ? this$0.document.getLineStartOffset(this$0.document.getLineCount() - 2) : this$0.document.getTextLength();
            Object line = StringsKt.endsWith$default((CharSequence)$text, (char)'\n', (boolean)false, (int)2, null) ? $text : $text + "\n";
            this$0.document.insertString(offset, (CharSequence)line);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExternalDiffSettings.ExternalToolGroup.values().length];
            try {
                nArray[ExternalDiffSettings.ExternalToolGroup.DIFF_TOOL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExternalDiffSettings.ExternalToolGroup.MERGE_TOOL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

