/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.HyperlinkEventAction;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsY;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u000b\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J2\u0010\u0010\u001a\u00020\u00052\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u000b\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007JX\u0010\u0011\u001a\u00020\u00052\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u000b\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/diff/util/DiffBalloons;", "", "<init>", "()V", "showSuccessPopup", "", "title", "", "Lcom/intellij/openapi/util/NlsContexts$PopupContent;", "message", "point", "Lcom/intellij/ui/awt/RelativePoint;", "disposable", "Lcom/intellij/openapi/Disposable;", "hyperlinkHandler", "Ljava/lang/Runnable;", "showWarningPopup", "createAndShowBalloon", "icon", "Ljavax/swing/Icon;", "fillColor", "Ljava/awt/Color;", "borderColor", "listener", "Lcom/intellij/ui/dsl/builder/HyperlinkEventAction;", "intellij.platform.diff.impl"})
public final class DiffBalloons {
    @NotNull
    public static final DiffBalloons INSTANCE = new DiffBalloons();

    private DiffBalloons() {
    }

    @JvmStatic
    public static final void showSuccessPopup(@NotNull String title, @NotNull String message, @NotNull RelativePoint point, @NotNull Disposable disposable, @NotNull Runnable hyperlinkHandler) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)hyperlinkHandler, (String)"hyperlinkHandler");
        Icon icon = ExperimentalUI.Companion.isNewUI() ? AllIcons.Status.Success : null;
        Color color = JBUI.CurrentTheme.Editor.Tooltip.SUCCESS_BACKGROUND;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"SUCCESS_BACKGROUND");
        Color color2 = JBUI.CurrentTheme.Editor.Tooltip.SUCCESS_BORDER;
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"SUCCESS_BORDER");
        INSTANCE.createAndShowBalloon(title, message, icon, color, color2, point, disposable, arg_0 -> DiffBalloons.showSuccessPopup$lambda$0(hyperlinkHandler, arg_0));
    }

    @JvmStatic
    public static final void showWarningPopup(@NotNull String title, @NotNull String message, @NotNull RelativePoint point, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Color color = JBUI.CurrentTheme.Editor.Tooltip.WARNING_BACKGROUND;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WARNING_BACKGROUND");
        Color color2 = JBUI.CurrentTheme.Editor.Tooltip.WARNING_BORDER;
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"WARNING_BORDER");
        DiffBalloons.createAndShowBalloon$default(INSTANCE, title, message, AllIcons.General.Warning, color, color2, point, disposable, null, 128, null);
    }

    private final void createAndShowBalloon(String title, String message, Icon icon, Color fillColor, Color borderColor, RelativePoint point, Disposable disposable, HyperlinkEventAction listener) {
        DialogPanel balloonContent = (DialogPanel)BuilderKt.panel(arg_0 -> DiffBalloons.createAndShowBalloon$lambda$0(icon, title, message, listener, arg_0)).andTransparent();
        Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)balloonContent).setBorderInsets((Insets)JBUI.insets((int)12, (int)13, (int)12, (int)21)).setFillColor(fillColor).setBorderColor(borderColor).setAnimationCycle(200).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
        Balloon balloon2 = balloon;
        balloon2.show(point, Balloon.Position.below);
        Disposer.register((Disposable)disposable, (Disposable)((Disposable)balloon2));
    }

    static /* synthetic */ void createAndShowBalloon$default(DiffBalloons diffBalloons, String string, String string2, Icon icon, Color color, Color color2, RelativePoint relativePoint, Disposable disposable, HyperlinkEventAction hyperlinkEventAction, int n, Object object) {
        if ((n & 0x80) != 0) {
            hyperlinkEventAction = null;
        }
        diffBalloons.createAndShowBalloon(string, string2, icon, color, color2, relativePoint, disposable, hyperlinkEventAction);
    }

    private static final void showSuccessPopup$lambda$0(Runnable $hyperlinkHandler, HyperlinkEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $hyperlinkHandler.run();
    }

    private static final Unit createAndShowBalloon$lambda$0$0(Icon $icon, int $gap, String $title, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        if ($icon != null) {
            $this$row.icon($icon).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)0, (int)$gap, (int)$gap, (int)3, null));
        }
        Row.text$default((Row)$this$row, (String)$title, (int)0, null, (int)6, null).bold().customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)0, (int)$gap, (int)0, (int)11, null));
        return Unit.INSTANCE;
    }

    private static final Unit createAndShowBalloon$lambda$0$1(Icon $icon, int $gap, String $message, HyperlinkEventAction $listener, Row $this$row) {
        HyperlinkEventAction hyperlinkEventAction;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        if ($icon != null) {
            EmptyIcon emptyIcon = EmptyIcon.create((Icon)$icon);
            Intrinsics.checkNotNullExpressionValue((Object)emptyIcon, (String)"create(...)");
            $this$row.icon((Icon)emptyIcon).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)0, (int)0, (int)$gap, (int)7, null));
        }
        if ((hyperlinkEventAction = $listener) == null) {
            hyperlinkEventAction = HyperlinkEventAction.HTML_HYPERLINK_INSTANCE;
        }
        Row.text$default((Row)$this$row, (String)$message, (int)0, (HyperlinkEventAction)hyperlinkEventAction, (int)2, null).customize(UnscaledGaps.EMPTY);
        return Unit.INSTANCE;
    }

    private static final Unit createAndShowBalloon$lambda$0(Icon $icon, String $title, String $message, HyperlinkEventAction $listener, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        int gap = 6;
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DiffBalloons.createAndShowBalloon$lambda$0$0($icon, gap, $title, arg_0), (int)1, null).customize(UnscaledGapsY.EMPTY);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DiffBalloons.createAndShowBalloon$lambda$0$1($icon, gap, $message, $listener, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }
}

