/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface PsiFileEx
extends PsiFile {
    public static final Key<Boolean> BATCH_REFERENCE_PROCESSING = Key.create((String)"BATCH_REFERENCE_PROCESSING");

    public boolean isContentsLoaded();

    public void onContentReload();

    public void markInvalidated();

    @ApiStatus.Experimental
    public static boolean isBatchReferenceProcessingEnabled(@NotNull PsiFile file) {
        if (file == null) {
            PsiFileEx.$$$reportNull$$$0(0);
        }
        if (file.getUserData(BATCH_REFERENCE_PROCESSING) != Boolean.TRUE) {
            return false;
        }
        return BatchReferenceProcessingSuppressor.EP_NAME.findFirstSafe(suppressor -> suppressor.isSuppressed(file)) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/PsiFileEx", "isBatchReferenceProcessingEnabled"));
    }

    @ApiStatus.Experimental
    public static interface BatchReferenceProcessingSuppressor {
        public static final ExtensionPointName<BatchReferenceProcessingSuppressor> EP_NAME = ExtensionPointName.create((String)"com.intellij.psi.batchReferenceProcessingSuppressor");

        public boolean isSuppressed(@NotNull PsiFile var1);
    }
}

