/*
 * Decompiled with CFR 0.152.
 */
package fleet.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a2\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a8\u0006\b"}, d2={"parseParameters", "", "", "parameterString", "keepQuotes", "", "supportSingleQuotes", "keepEmptyParameters", "fleet.util.core"})
public final class ParametersListUtilKt {
    @NotNull
    public static final List<String> parseParameters(@NotNull String parameterString, boolean keepQuotes, boolean supportSingleQuotes, boolean keepEmptyParameters) {
        Intrinsics.checkNotNullParameter((Object)parameterString, (String)"parameterString");
        String paramsStr = parameterString;
        if (!keepEmptyParameters) {
            paramsStr = ((Object)StringsKt.trim((CharSequence)paramsStr)).toString();
        }
        List params = new ArrayList();
        if (((CharSequence)paramsStr).length() == 0) {
            return params;
        }
        StringBuilder token = new StringBuilder(128);
        boolean inQuotes = false;
        boolean escapedQuote = false;
        HashSet<Integer> possibleQuoteChars = new HashSet<Integer>();
        possibleQuoteChars.add(34);
        if (supportSingleQuotes) {
            possibleQuoteChars.add(39);
        }
        char currentQuote = '\u0000';
        boolean nonEmpty = false;
        int n = ((CharSequence)paramsStr).length();
        for (int i = 0; i < n; ++i) {
            char ch = paramsStr.charAt(i);
            boolean bl = inQuotes ? currentQuote == ch : possibleQuoteChars.contains(ch);
            if (bl) {
                if (!escapedQuote) {
                    inQuotes = !inQuotes;
                    currentQuote = ch;
                    nonEmpty = true;
                    if (!keepQuotes) continue;
                }
                escapedQuote = false;
            } else if (CharsKt.isWhitespace((char)ch)) {
                if (!inQuotes) {
                    if (!keepEmptyParameters && !(((CharSequence)token).length() > 0) && !nonEmpty) continue;
                    String string = token.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    params.add(string);
                    token.setLength(0);
                    nonEmpty = false;
                    continue;
                }
            } else if (ch == '\\' && i < paramsStr.length() - 1) {
                char nextChar = paramsStr.charAt(i + 1);
                boolean bl2 = inQuotes ? currentQuote == nextChar : possibleQuoteChars.contains(nextChar);
                if (bl2) {
                    escapedQuote = true;
                    if (!keepQuotes) continue;
                }
            }
            token.append(ch);
        }
        if (keepEmptyParameters || ((CharSequence)token).length() > 0 || nonEmpty) {
            String string = token.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            params.add(string);
        }
        return params;
    }

    public static /* synthetic */ List parseParameters$default(String string, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        return ParametersListUtilKt.parseParameters(string, bl, bl2, bl3);
    }
}

