/*
 * Decompiled with CFR 0.152.
 */
package git4idea.editor;

import externalApp.ExternalApp;
import externalApp.ExternalAppEntry;
import externalApp.ExternalAppUtil;
import externalApp.ExternalCli;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitRebaseEditorApp
implements ExternalApp,
ExternalCli {
    @NotNull
    private static final Character REPLACEMENT_CHARACTER = Character.valueOf('\ufffd');

    public int entryPoint(ExternalAppEntry entry) {
        try {
            if (entry.getArgs().length != 1) {
                entry.getStderr().println("Invalid arguments: " + String.valueOf(Arrays.asList(entry.getArgs())));
                return 2;
            }
            String handlerId = ExternalAppUtil.getEnv((String)"INTELLIJ_REBASE_HANDER_NO", (Map)entry.getEnvironment());
            int idePort = ExternalAppUtil.getEnvInt((String)"INTELLIJ_REBASE_HANDER_PORT", (Map)entry.getEnvironment());
            String workingDir = entry.getWorkingDirectory();
            String path = entry.getArgs()[0];
            if (GitRebaseEditorApp.hasEncodingProblem(path) || GitRebaseEditorApp.hasEncodingProblem(workingDir)) {
                GitRebaseEditorApp.logEncodingProblem(entry, path, workingDir);
                return 2;
            }
            String bodyContent = path + "\n" + workingDir;
            ExternalAppUtil.Result result = ExternalAppUtil.sendIdeRequest((String)"gitEditor", (int)idePort, (String)handlerId, (String)bodyContent);
            if (result.isError) {
                entry.getStderr().println(result.getPresentableError());
                return 2;
            }
            String response = result.response;
            if (response == null) {
                return 2;
            }
            int exitCode = Integer.parseInt(response);
            return exitCode;
        }
        catch (Throwable t) {
            entry.getStderr().println(t.getMessage());
            t.printStackTrace(entry.getStderr());
            return 2;
        }
    }

    private static void logEncodingProblem(ExternalAppEntry entry, String path, String workingDir) {
        entry.getStderr().printf("Path to rebase todo file is malformed - %s%nWorking dir - %s%n", path, workingDir);
        entry.getStderr().printf("Ensure that the default locale '%s' is registered in the system.%n%n", Locale.getDefault());
    }

    private static boolean hasEncodingProblem(String path) {
        return path.indexOf(REPLACEMENT_CHARACTER.charValue()) != -1;
    }

    public static void main(String[] args) {
        int exitCode = new GitRebaseEditorApp().entryPoint(ExternalAppEntry.fromMain((String[])args));
        System.exit(exitCode);
    }
}

