/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.IdeGlassPane;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/UIMouseTracker;", "Lcom/intellij/ide/IdeEventQueue$EventDispatcher;", "<init>", "()V", "mouseCoordinates", "Ljava/awt/Point;", "totalMouseTrack", "", "dispatch", "", "e", "Ljava/awt/AWTEvent;", "onMouseMove", "", "Ljava/awt/event/MouseEvent;", "onMouseClicked", "componentClicked", "comp", "Ljava/awt/Component;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class UIMouseTracker
implements IdeEventQueue.EventDispatcher {
    @NotNull
    private Point mouseCoordinates;
    private float totalMouseTrack;

    public UIMouseTracker() {
        Point point = MouseInfo.getPointerInfo().getLocation();
        if (point == null) {
            point = new Point(0, 0);
        }
        this.mouseCoordinates = point;
    }

    @Override
    public boolean dispatch(@NotNull AWTEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof MouseEvent) {
            switch (((MouseEvent)e).getID()) {
                case 502: {
                    this.onMouseClicked((MouseEvent)e);
                    break;
                }
                case 503: {
                    this.onMouseMove((MouseEvent)e);
                }
            }
        }
        return false;
    }

    private final void onMouseMove(MouseEvent e) {
        float dX = e.getXOnScreen() - this.mouseCoordinates.x;
        float dY = e.getYOnScreen() - this.mouseCoordinates.y;
        this.mouseCoordinates.x = e.getXOnScreen();
        this.mouseCoordinates.y = e.getYOnScreen();
        this.totalMouseTrack += (float)Math.sqrt(dX * dX + dY * dY);
    }

    private final void onMouseClicked(MouseEvent e) {
        Component clickedComponent;
        if (e.getClickCount() == 0) {
            return;
        }
        Component component2 = e.getComponent();
        Component component3 = clickedComponent = component2 instanceof Container ? ((Container)component2).findComponentAt(e.getPoint()) : null;
        if (clickedComponent != null) {
            if (clickedComponent instanceof IdeGlassPane) {
                DialogWrapper dialog2 = DialogWrapper.findInstance((Component)clickedComponent);
                if (dialog2 != null) {
                    Point pointOnDialog = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), dialog2.getContentPane());
                    Component comp = dialog2.getContentPane().findComponentAt(pointOnDialog.x, pointOnDialog.y);
                    if (comp != null) {
                        this.componentClicked(comp);
                    }
                }
            } else {
                this.componentClicked(clickedComponent);
            }
        }
    }

    private final void componentClicked(Component comp) {
    }
}

