/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl.islands;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.impl.islands.IslandsTabTheme;
import com.intellij.openapi.rd.GraphicsExKt;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.impl.themes.DefaultTabTheme;
import com.intellij.ui.tabs.impl.themes.TabTheme;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016JB\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0016JB\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J(\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J0\u0010 \u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010!\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\fH\u0002JB\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0018\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J,\u00101\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0,2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020)0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020)0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020)0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020)0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020)0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/openapi/application/impl/islands/IslandsTabPainter;", "Lcom/intellij/ui/tabs/JBTabPainter;", "isDefault", "", "isToolWindow", "<init>", "(ZZ)V", "myTheme", "Lcom/intellij/ui/tabs/impl/themes/TabTheme;", "myFillBackground", "getTabTheme", "getBackgroundColor", "Ljava/awt/Color;", "paintTab", "", "position", "Lcom/intellij/ui/tabs/JBTabsPosition;", "g", "Ljava/awt/Graphics2D;", "rect", "Ljava/awt/Rectangle;", "borderThickness", "", "tabColor", "active", "hovered", "paintSelectedTab", "paintBorderLine", "thickness", "from", "Ljava/awt/Point;", "to", "paintUnderline", "fillBackground", "component", "Ljava/awt/Component;", "color", "selected", "getHOffsetUnscaled", "compactMode", "hoverBackground", "Lcom/intellij/ui/JBColor;", "inactiveBorderColor", "regularColors", "Lkotlin/Pair;", "hoveredColors", "selectedColors", "selectedInactiveColors", "selectedHoveredInactiveColors", "getColors", "intellij.platform.ide.impl"})
public class IslandsTabPainter
implements JBTabPainter {
    @NotNull
    private final TabTheme myTheme;
    private final boolean myFillBackground;
    @NotNull
    private final JBColor hoverBackground;
    @NotNull
    private final JBColor inactiveBorderColor;
    @NotNull
    private final Pair<JBColor, JBColor> regularColors;
    @NotNull
    private final Pair<JBColor, JBColor> hoveredColors;
    @NotNull
    private final Pair<JBColor, JBColor> selectedColors;
    @NotNull
    private final Pair<JBColor, JBColor> selectedInactiveColors;
    @NotNull
    private final Pair<JBColor, JBColor> selectedHoveredInactiveColors;

    public IslandsTabPainter(boolean isDefault, boolean isToolWindow) {
        this.myTheme = isToolWindow ? (TabTheme)new DefaultTabTheme(){

            public Color getBackground() {
                Color color = JBUI.CurrentTheme.ToolWindow.background();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background(...)");
                return color;
            }
        } : (isDefault ? (TabTheme)new DefaultTabTheme() : (TabTheme)new IslandsTabTheme());
        this.myFillBackground = isToolWindow || !isDefault;
        this.hoverBackground = new JBColor("EditorTabs.hoverBackground", (Color)new JBColor(new Color(229, 238, 255, 128), new Color(52, 62, 81, 128)));
        this.inactiveBorderColor = new JBColor("EditorTabs.inactiveUnderlinedTabBorderColor", (Color)new JBColor(new Color(127, 153, 195, 128), new Color(127, 153, 195, 128)));
        this.regularColors = TuplesKt.to((Object)new JBColor("EditorTabs.regularBackground", null), (Object)new JBColor("EditorTabs.regularBorderColor", null));
        this.hoveredColors = TuplesKt.to((Object)this.hoverBackground, (Object)new JBColor("EditorTabs.hoverBorderColor", null));
        this.selectedColors = TuplesKt.to((Object)new JBColor("EditorTabs.underlinedTabBackground", (Color)new JBColor(0xE5EEFF, 3423825)), (Object)new JBColor("EditorTabs.underlinedBorderColor", (Color)new JBColor(8362435, 8362435)));
        this.selectedInactiveColors = TuplesKt.to((Object)new JBColor("EditorTabs.inactiveUnderlinedTabBackground", null), (Object)this.inactiveBorderColor);
        this.selectedHoveredInactiveColors = TuplesKt.to((Object)this.hoverBackground, (Object)this.inactiveBorderColor);
    }

    @NotNull
    public TabTheme getTabTheme() {
        return this.myTheme;
    }

    @NotNull
    public Color getBackgroundColor() {
        Color color = this.myTheme.getBackground();
        Intrinsics.checkNotNull((Object)color);
        return color;
    }

    public void paintTab(@NotNull JBTabsPosition position2, @NotNull Graphics2D g, @NotNull Rectangle rect, int borderThickness, @Nullable Color tabColor, boolean active, boolean hovered) {
        Intrinsics.checkNotNullParameter((Object)position2, (String)"position");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.paintTab(g, position2, rect, tabColor, active, hovered, false);
    }

    public void paintSelectedTab(@NotNull JBTabsPosition position2, @NotNull Graphics2D g, @NotNull Rectangle rect, int borderThickness, @Nullable Color tabColor, boolean active, boolean hovered) {
        Intrinsics.checkNotNullParameter((Object)position2, (String)"position");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.paintTab(g, position2, rect, tabColor, active, hovered, true);
    }

    public void paintBorderLine(@NotNull Graphics2D g, int thickness, @NotNull Point from, @NotNull Point to) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        GraphicsExKt.paint2DLine((Graphics2D)g, (Point)from, (Point)to, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)thickness, (Color)this.myTheme.getBorderColor());
    }

    public void paintUnderline(@NotNull JBTabsPosition position2, @NotNull Rectangle rect, int borderThickness, @NotNull Graphics2D g, boolean active) {
        Intrinsics.checkNotNullParameter((Object)position2, (String)"position");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
    }

    public void fillBackground(@NotNull Graphics2D g, @NotNull Rectangle rect) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        if (this.myFillBackground) {
            this.fillBackground(g, rect, this.getBackgroundColor());
        }
    }

    public void fillBackground(@NotNull Component component2, @NotNull Graphics2D g, @NotNull Rectangle rect) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        if (this.myFillBackground) {
            color = this.getBackgroundColor();
        } else {
            Color color2 = UIUtil.getBgFillColor((Component)component2);
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getBgFillColor(...)");
        }
        this.fillBackground(g, rect, color);
    }

    private final void fillBackground(Graphics2D g, Rectangle rect, Color color) {
        g.setColor(color);
        RectanglePainter2D.FILL.paint(g, (double)rect.x, (double)rect.y, (double)rect.width, (double)rect.height);
    }

    public void paintTab(@NotNull Graphics2D g, @NotNull JBTabsPosition position2, @NotNull Rectangle rect, @Nullable Color tabColor, boolean active, boolean hovered, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)position2, (String)"position");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        double arc = JBUI.CurrentTheme.MainToolbar.Button.hoverArc().getFloat();
        boolean compactMode = UISettings.Companion.getInstance().getCompactMode();
        double hOffset = JBUIScale.scale((float)this.getHOffsetUnscaled(compactMode, position2));
        double minVOffset = JBUIScale.scale((float)(compactMode ? 4.0f : 8.0f));
        double fullHeight = JBUIScale.scale((float)(compactMode ? 24.0f : 28.0f));
        double vOffset = RangesKt.coerceAtLeast((double)((double)rect.height - fullHeight), (double)minVOffset);
        double x = (double)rect.x + hOffset;
        double y = Math.floor((double)rect.y + vOffset / 2.0);
        double width = (double)rect.width - hOffset * 2.0;
        double height = (double)rect.height - vOffset;
        if (tabColor != null) {
            g.setColor(ColorUtil.withAlpha((Color)tabColor, (double)0.9));
            RectanglePainter2D.FILL.paint(g, x, y, width, height, (Object)arc);
        }
        Pair<Color, Color> pair = this.getColors(active, hovered, selected);
        Color fill = (Color)pair.component1();
        Color draw = (Color)pair.component2();
        g.setColor(fill);
        RectanglePainter2D.FILL.paint(g, x, y, width, height, (Object)arc);
        g.setColor(draw);
        RectanglePainter2D.DRAW.paint(g, x, y, width, height, (Object)arc);
    }

    private final int getHOffsetUnscaled(boolean compactMode, JBTabsPosition position2) {
        int n;
        boolean bl = position2.isSide();
        if (bl) {
            n = 6;
        } else if (!bl) {
            n = compactMode ? 2 : 4;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    private final Pair<Color, Color> getColors(boolean active, boolean hovered, boolean selected) {
        if (selected) {
            if (active) {
                return this.selectedColors;
            }
            if (hovered) {
                return this.selectedHoveredInactiveColors;
            }
            return this.selectedInactiveColors;
        }
        if (hovered) {
            return this.hoveredColors;
        }
        return this.regularColors;
    }
}

