/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.content.ContentLabel;
import com.intellij.openapi.wm.impl.content.SingleContentLayout;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.openapi.wm.impl.content.tabActions.ContentTabAction;
import com.intellij.ui.EngravedTextGraphics;
import com.intellij.ui.Gray;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentManagerImpl;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.concurrency.EdtScheduler;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ContentTabLabel
extends ContentLabel {
    private static final int MAX_WIDTH = JBUIScale.scale((int)400);
    private final LayeredIcon myActiveCloseIcon;
    private final LayeredIcon myRegularCloseIcon;
    @NotNull
    protected final Content myContent;
    private final TabContentLayout myLayout;
    private @NlsContexts.Label String myText;
    private boolean textUpdateScheduled;

    @Override
    protected void handleMouseClick(@NotNull MouseEvent e) {
        if (e == null) {
            ContentTabLabel.$$$reportNull$$$0(0);
        }
        if (e.getID() == 502) {
            if (e.isAltDown()) {
                this.closeAllOtherTabs();
                return;
            }
            if (this.handleActionsClick(e)) {
                return;
            }
            this.selectContent();
            this.handleDoubleClick(e);
        }
    }

    private void handleDoubleClick(@NotNull MouseEvent e) {
        if (e == null) {
            ContentTabLabel.$$$reportNull$$$0(1);
        }
        if (e.getClickCount() == 2 && e.getButton() == 1 && !this.myLayout.doubleClickActions.isEmpty()) {
            DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)this);
            for (AnAction action2 : this.myLayout.doubleClickActions) {
                AnActionEvent event = AnActionEvent.createFromInputEvent((InputEvent)e, (String)"unknown", null, (DataContext)dataContext2);
                ActionUtil.performAction((AnAction)action2, (AnActionEvent)event);
            }
        }
    }

    @Override
    boolean showLabelText(@NotNull Content content2) {
        if (content2 == null) {
            ContentTabLabel.$$$reportNull$$$0(2);
        }
        return !Boolean.FALSE.equals(content2.getUserData(ToolWindow.SHOW_CONTENT_TAB_LABEL_TEXT));
    }

    @Override
    public void setText(@NlsContexts.Label String text2) {
        this.myText = text2;
        this.updateText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateText() {
        try {
            int maxWidth;
            if (this.myText != null && this.myText.startsWith("<html>")) {
                super.setText(this.myText);
                return;
            }
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int textWidth = UIUtilities.stringWidth(this, fm, this.myText);
            int prefWidth = this.myIconWithInsetsWidth + textWidth;
            if (prefWidth > (maxWidth = this.getMaximumSize().width)) {
                int offset = maxWidth - this.myIconWithInsetsWidth;
                String s = UIUtilities.clipString(this, fm, this.myText, offset);
                super.setText(s);
                return;
            }
            super.setText(this.myText);
        }
        finally {
            if (!(this.myContent == null || this.myContent instanceof SingleContentLayout.SubContent || Disposer.isDisposed((Disposable)this.myContent) || this.textUpdateScheduled)) {
                this.textUpdateScheduled = true;
                EdtScheduler.getInstance().schedule(50, () -> {
                    this.textUpdateScheduled = false;
                    Container parent = this.getParent();
                    if (parent != null) {
                        parent.revalidate();
                        parent.repaint();
                    }
                });
            }
        }
    }

    ContentTabLabel(@NotNull Content content2, @NotNull TabContentLayout layout2) {
        if (content2 == null) {
            ContentTabLabel.$$$reportNull$$$0(3);
        }
        if (layout2 == null) {
            ContentTabLabel.$$$reportNull$$$0(4);
        }
        super(layout2.ui, false);
        this.myActiveCloseIcon = LayeredIcon.layeredIcon(() -> new Icon[]{JBUI.CurrentTheme.ToolWindow.closeTabIcon((boolean)true)});
        this.myRegularCloseIcon = LayeredIcon.layeredIcon(() -> new Icon[]{JBUI.CurrentTheme.ToolWindow.closeTabIcon((boolean)false)});
        this.myLayout = layout2;
        this.myContent = content2;
        this.updateAdditionalActions();
        this.myContent.addPropertyChangeListener(event -> {
            String property = event.getPropertyName();
            if ("isClosable".equals(property)) {
                this.repaint();
            }
            if ("pinned".equals(property)) {
                this.updateCloseIcon();
            }
        });
        if (this.myContent.isPinned()) {
            SwingUtilities.invokeLater(this::updateCloseIcon);
        }
        this.setMaximumSize(new Dimension(MAX_WIDTH, this.getMaximumSize().height));
    }

    @Override
    protected String getOriginalText() {
        return this.myText;
    }

    private void updateCloseIcon() {
        boolean pinned = this.getContent().isPinned();
        this.myActiveCloseIcon.setIcon(pinned ? AllIcons.Actions.PinTab : JBUI.CurrentTheme.ToolWindow.closeTabIcon((boolean)true), 0);
        this.myRegularCloseIcon.setIcon(pinned ? AllIcons.Actions.PinTab : JBUI.CurrentTheme.ToolWindow.closeTabIcon((boolean)false), 0);
        this.repaint();
    }

    @Override
    protected void fillActions(@NotNull List<? super ContentTabAction> actions) {
        if (actions == null) {
            ContentTabLabel.$$$reportNull$$$0(5);
        }
        super.fillActions(actions);
        actions.add(new CloseContentTabAction());
    }

    public final boolean canBeClosed() {
        return this.myContent.isCloseable() && this.myUi.window.canCloseContents();
    }

    protected void selectContent() {
        ContentManager manager2 = this.getContentManager();
        if (manager2.getIndexOfContent(this.myContent) >= 0) {
            manager2.setSelectedContent(this.myContent, true);
        }
    }

    protected void closeContent() {
        this.getContentManager().removeContent(this.myContent, true);
    }

    public void update() {
        this.setHorizontalAlignment(2);
        if (this.myLayout.isToDrawTabs() == TabContentLayout.TabsDrawMode.HIDE) {
            this.myBorder.setBorderInsets(0, 0, 0, 0);
        }
        this.updateTextAndIcon(this.myContent, this.isSelected(), false);
    }

    @Override
    protected boolean allowEngravement() {
        return this.isSelected() || this.myUi != null && this.myUi.window.isActive();
    }

    @Override
    protected Color getActiveFg(boolean selected) {
        ContentManager contentManager = this.getContentManager();
        if (contentManager.getContentCount() > 1) {
            return selected ? JBUI.CurrentTheme.ToolWindow.underlinedTabForeground() : JBUI.CurrentTheme.Label.foreground((boolean)false);
        }
        return super.getActiveFg(selected);
    }

    @Override
    protected Color getPassiveFg(boolean selected) {
        ContentManagerImpl contentManager = this.myUi.window.getContentManagerIfCreated();
        if (contentManager != null && contentManager.getContentCount() > 1) {
            return selected ? JBUI.CurrentTheme.ToolWindow.underlinedTabInactiveForeground() : JBUI.CurrentTheme.Label.foreground((boolean)false);
        }
        return super.getPassiveFg(selected);
    }

    public boolean isSelected() {
        return this.getContentManager().isSelected(this.myContent);
    }

    @Override
    protected Graphics _getGraphics(Graphics2D g) {
        if (this.isSelected() && this.getContentManager().getContentCount() > 1) {
            return new EngravedTextGraphics(g, 1, 1, Gray._0.withAlpha(this.myUi.window.isActive() ? 120 : 130));
        }
        return super._getGraphics(g);
    }

    @NotNull
    private ContentManager getContentManager() {
        ContentManager contentManager = this.myUi.getContentManager();
        if (contentManager == null) {
            ContentTabLabel.$$$reportNull$$$0(6);
        }
        return contentManager;
    }

    @Override
    @NotNull
    public Content getContent() {
        Content content2 = this.myContent;
        if (content2 == null) {
            ContentTabLabel.$$$reportNull$$$0(7);
        }
        return content2;
    }

    private void closeAllOtherTabs() {
        ContentManager contentManager = this.getContentManager();
        for (Content content2 : contentManager.getContents()) {
            if (content2 == this.myContent || !content2.isCloseable()) continue;
            contentManager.removeContent(content2, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/content/ContentTabLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/content/ContentTabLabel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleMouseClick";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleDoubleClick";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showLabelText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fillActions";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }

    private final class CloseContentTabAction
    extends ContentTabAction {
        private CloseContentTabAction() {
            super(new ActiveIcon((Icon)ContentTabLabel.this.myActiveCloseIcon, (Icon)ContentTabLabel.this.myRegularCloseIcon));
        }

        @Override
        public boolean getAvailable() {
            return ContentTabLabel.this.canBeClosed();
        }

        @Override
        public void runAction() {
            Content content2 = ContentTabLabel.this.getContent();
            if (content2.isPinned()) {
                content2.setPinned(false);
                return;
            }
            if (Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() == 512) {
                ContentTabLabel.this.closeAllOtherTabs();
            } else {
                ContentTabLabel.this.closeContent();
            }
        }

        @Override
        public boolean getAfterText() {
            return UISettings.getShadowInstance().getCloseTabButtonOnTheRight() || !UISettings.getShadowInstance().getShowCloseButton();
        }

        @Override
        @NotNull
        public String getTooltip() {
            if (ContentTabLabel.this.getContent().isPinned()) {
                String string = IdeBundle.message((String)"action.unpin.tab.tooltip", (Object[])new Object[0]);
                if (string == null) {
                    CloseContentTabAction.$$$reportNull$$$0(0);
                }
                return string;
            }
            Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts("CloseActiveTab");
            String text2 = KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
            Object object = text2.isEmpty() || !ContentTabLabel.this.isSelected() ? IdeBundle.message((String)"tooltip.close.tab", (Object[])new Object[0]) : IdeBundle.message((String)"tooltip.close.tab", (Object[])new Object[0]) + " (" + text2 + ")";
            if (object == null) {
                CloseContentTabAction.$$$reportNull$$$0(1);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/content/ContentTabLabel$CloseContentTabAction", "getTooltip"));
        }
    }
}

