/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.charts;

import com.intellij.ui.JBColor;
import com.intellij.ui.charts.ChartComponent;
import com.intellij.ui.charts.Overlay;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001:\u0002/0B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0006\u0010'\u001a\u00020\u001eJ\b\u0010(\u001a\u00020\"H\u0014R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R0\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001b\u0010!\u001a\u00020\"8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b#\u0010$R(\u0010*\u001a\u0004\u0018\u00010)2\b\u0010\u0004\u001a\u0004\u0018\u00010)@BX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u00061"}, d2={"Lcom/intellij/ui/charts/ChartWrapper;", "Lcom/intellij/ui/charts/ChartComponent;", "<init>", "()V", "value", "", "width", "getWidth", "()I", "height", "getHeight", "background", "Ljava/awt/Color;", "getBackground", "()Ljava/awt/Color;", "setBackground", "(Ljava/awt/Color;)V", "", "overlays", "getOverlays", "()Ljava/util/List;", "setOverlays", "(Ljava/util/List;)V", "margins", "Ljava/awt/Insets;", "getMargins", "()Ljava/awt/Insets;", "setMargins", "(Ljava/awt/Insets;)V", "paintOverlay", "", "g", "Ljava/awt/Graphics2D;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "component$delegate", "Lkotlin/Lazy;", "update", "createCentralPanel", "Ljava/awt/Point;", "mouseLocation", "getMouseLocation", "()Ljava/awt/Point;", "setMouseLocation", "(Ljava/awt/Point;)V", "MouseAware", "CentralPanel", "intellij.platform.ide.ui"})
@SourceDebugExtension(value={"SMAP\nChartWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartWrapper.kt\ncom/intellij/ui/charts/ChartWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,404:1\n1915#2,2:405\n1915#2,2:407\n1915#2,2:409\n1915#2,2:411\n*S KotlinDebug\n*F\n+ 1 ChartWrapper.kt\ncom/intellij/ui/charts/ChartWrapper\n*L\n164#1:405,2\n166#1:407,2\n171#1:409,2\n193#1:411,2\n*E\n"})
public abstract class ChartWrapper
implements ChartComponent {
    private int width;
    private int height;
    @NotNull
    private Color background;
    @NotNull
    private List<? extends ChartComponent> overlays;
    @NotNull
    private Insets margins;
    @NotNull
    private final Lazy component$delegate;
    @Nullable
    private Point mouseLocation;

    public ChartWrapper() {
        Color color = JBColor.background();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background(...)");
        this.background = color;
        this.overlays = new ArrayList();
        this.margins = new Insets(0, 0, 0, 0);
        this.component$delegate = LazyKt.lazy(() -> ChartWrapper.component_delegate$lambda$0(this));
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final Color getBackground() {
        return this.background;
    }

    public final void setBackground(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.background = color;
    }

    @NotNull
    public final List<ChartComponent> getOverlays() {
        return this.overlays;
    }

    public final void setOverlays(@NotNull List<? extends ChartComponent> value) {
        ChartComponent it;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Iterable $this$forEach$iv = this.overlays;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ChartComponent)element$iv;
            boolean bl = false;
            if (!(it instanceof Overlay)) continue;
            ((Overlay)it).setWrapper(null);
        }
        List<? extends ChartComponent> list2 = this.overlays;
        Intrinsics.checkNotNull(list2, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.ui.charts.ChartComponent>");
        TypeIntrinsics.asMutableList(list2).addAll((Collection)value);
        $this$forEach$iv = this.overlays;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ChartComponent)element$iv;
            boolean bl = false;
            if (!(it instanceof Overlay)) continue;
            ((Overlay)it).setWrapper(this);
        }
    }

    @NotNull
    public final Insets getMargins() {
        return this.margins;
    }

    public final void setMargins(@NotNull Insets insets) {
        Intrinsics.checkNotNullParameter((Object)insets, (String)"<set-?>");
        this.margins = insets;
    }

    public void paintOverlay(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Iterable $this$forEach$iv = this.overlays;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChartComponent it = (ChartComponent)element$iv;
            boolean bl = false;
            it.paintComponent(g);
        }
    }

    @NotNull
    public JComponent getComponent() {
        Lazy lazy = this.component$delegate;
        return (JComponent)lazy.getValue();
    }

    public final void update() {
        this.getComponent().repaint();
    }

    @NotNull
    protected JComponent createCentralPanel() {
        return new CentralPanel();
    }

    @Nullable
    protected final Point getMouseLocation() {
        return this.mouseLocation;
    }

    private final void setMouseLocation(Point value) {
        this.mouseLocation = value;
        Iterable $this$forEach$iv = this.overlays;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChartComponent it = (ChartComponent)element$iv;
            boolean bl = false;
            if (!(it instanceof Overlay)) continue;
            ((Overlay)it).setMouseLocation(value);
        }
    }

    private static final JComponent component_delegate$lambda$0(ChartWrapper this$0) {
        JComponent jComponent;
        JComponent $this$component_delegate_u24lambda_u240_u240 = jComponent = this$0.createCentralPanel();
        boolean bl = false;
        $this$component_delegate_u24lambda_u240_u240.setBackground(this$0.background);
        MouseAware $this$component_delegate_u24lambda_u240_u240_u240 = this$0.new MouseAware();
        boolean bl2 = false;
        $this$component_delegate_u24lambda_u240_u240.addMouseMotionListener($this$component_delegate_u24lambda_u240_u240_u240);
        $this$component_delegate_u24lambda_u240_u240.addMouseListener($this$component_delegate_u24lambda_u240_u240_u240);
        return jComponent;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/ui/charts/ChartWrapper$CentralPanel;", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/ui/charts/ChartWrapper;)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.platform.ide.ui"})
    private final class CentralPanel
    extends JComponent {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(@NotNull Graphics g) {
            Graphics2D graphics2D;
            Graphics2D graphics2D2;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            ((Graphics2D)g).clip(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            ((Graphics2D)g).setColor(this.getBackground());
            ((Graphics2D)g).fill(((Graphics2D)g).getClip());
            ChartWrapper.this.height = this.getHeight();
            ChartWrapper.this.width = this.getWidth();
            Graphics graphics = g.create(0, 0, ChartWrapper.this.getWidth(), ChartWrapper.this.getHeight());
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D $this$paintComponent_u24lambda_u240 = graphics2D2 = (Graphics2D)graphics;
            boolean bl = false;
            $this$paintComponent_u24lambda_u240.clip(this.getVisibleRect());
            $this$paintComponent_u24lambda_u240.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            $this$paintComponent_u24lambda_u240.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            $this$paintComponent_u24lambda_u240.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            GraphicsUtil.setupAntialiasing((Graphics)$this$paintComponent_u24lambda_u240);
            Graphics2D gridGraphics = graphics2D2;
            try {
                ChartWrapper.this.paintComponent(gridGraphics);
            }
            finally {
                gridGraphics.dispose();
            }
            Graphics graphics2 = g.create();
            Intrinsics.checkNotNull((Object)graphics2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D $this$paintComponent_u24lambda_u241 = graphics2D = (Graphics2D)graphics2;
            boolean bl2 = false;
            $this$paintComponent_u24lambda_u241.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            $this$paintComponent_u24lambda_u241.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            $this$paintComponent_u24lambda_u241.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            GraphicsUtil.setupAntialiasing((Graphics)$this$paintComponent_u24lambda_u241);
            Graphics2D overlayGraphics = graphics2D;
            try {
                ChartWrapper.this.paintOverlay(overlayGraphics);
            }
            finally {
                overlayGraphics.dispose();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ui/charts/ChartWrapper$MouseAware;", "Ljava/awt/event/MouseAdapter;", "<init>", "(Lcom/intellij/ui/charts/ChartWrapper;)V", "mouseMoved", "", "e", "Ljava/awt/event/MouseEvent;", "mouseEntered", "mouseExited", "mouseDragged", "intellij.platform.ide.ui"})
    private final class MouseAware
    extends MouseAdapter {
        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ChartWrapper.this.setMouseLocation(e.getPoint());
            ChartWrapper.this.getComponent().repaint();
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ChartWrapper.this.setMouseLocation(e.getPoint());
            ChartWrapper.this.getComponent().repaint();
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ChartWrapper.this.setMouseLocation(null);
            ChartWrapper.this.getComponent().repaint();
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ChartWrapper.this.setMouseLocation(e.getPoint());
            ChartWrapper.this.getComponent().repaint();
        }
    }
}

