/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ide.ui.laf.LookAndFeelThemeAdapter;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.components.DefaultLinkButtonUIKt;
import com.intellij.ui.components.DynamicColor;
import com.intellij.ui.components.Layout;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\"\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\"\u0010\u0012\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u001a\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\tH\u0014R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ui/components/DefaultLinkButtonUI;", "Ljavax/swing/plaf/basic/BasicButtonUI;", "<init>", "()V", "cached", "Ljavax/swing/text/View;", "installDefaults", "", "button", "Ljavax/swing/AbstractButton;", "getBaseline", "", "c", "Ljavax/swing/JComponent;", "width", "height", "getPreferredSize", "Ljava/awt/Dimension;", "contains", "", "x", "y", "paint", "g", "Ljava/awt/Graphics;", "createButtonListener", "Ljavax/swing/plaf/basic/BasicButtonListener;", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nDefaultLinkButtonUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultLinkButtonUI.kt\ncom/intellij/ui/components/DefaultLinkButtonUI\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n1#2:314\n*E\n"})
public final class DefaultLinkButtonUI
extends BasicButtonUI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private View cached;

    @Override
    protected void installDefaults(@NotNull AbstractButton button2) {
        Intrinsics.checkNotNullParameter((Object)button2, (String)"button");
        LookAndFeel.installProperty(button2, "opaque", false);
        LookAndFeel.installProperty(button2, "contentAreaFilled", false);
        LookAndFeel.installProperty(button2, "borderPainted", false);
        LookAndFeel.installProperty(button2, "rolloverEnabled", true);
        LookAndFeel.installProperty(button2, "iconTextGap", 4);
        this.defaultTextShiftOffset = UIManager.getInt("Button.textShiftOffset");
        if (!button2.isFontSet() || button2.getFont() instanceof UIResource) {
            Font font = UIManager.getFont("Label.font");
            Intrinsics.checkNotNull((Object)font);
            button2.setFont(font);
        }
        if (!button2.isBackgroundSet() || button2.getBackground() instanceof UIResource) {
            button2.setBackground(UIManager.getColor("Label.background"));
        }
        if (!button2.isForegroundSet() || button2.getForeground() instanceof UIResource) {
            button2.setForeground((Color)((Object)new DynamicColor(button2)));
        }
        button2.setHorizontalAlignment(10);
        button2.setRequestFocusEnabled(false);
    }

    @Override
    public int getBaseline(@Nullable JComponent c, int width, int height) {
        if (width < 0 || height < 0) {
            return -1;
        }
        AbstractButton abstractButton = c instanceof AbstractButton ? (AbstractButton)c : null;
        if (abstractButton == null) {
            return -1;
        }
        AbstractButton button2 = abstractButton;
        String string = button2.getText();
        if (string == null) {
            return -1;
        }
        String text2 = string;
        if (((CharSequence)text2).length() == 0) {
            return -1;
        }
        Layout layout2 = new Layout(button2, new Rectangle(width, height), null, 4, null);
        View view2 = DefaultLinkButtonUIKt.access$htmlView(button2);
        if (view2 == null) {
            return layout2.getBaseline();
        }
        View view3 = view2;
        int baseline = BasicHTML.getHTMLBaseline(view3, layout2.getTextBounds().width, layout2.getTextBounds().height);
        return baseline < 0 ? baseline : baseline + layout2.getTextBounds().y;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(@Nullable JComponent c) {
        Dimension dimension;
        AbstractButton abstractButton = c instanceof AbstractButton ? (AbstractButton)c : null;
        if (abstractButton == null) {
            return new Dimension();
        }
        AbstractButton button2 = abstractButton;
        int max = Short.MAX_VALUE;
        Layout layout2 = new Layout(button2, new Rectangle(max, max), null, 4, null);
        Dimension it = dimension = layout2.getBounds().getSize();
        boolean bl = false;
        JBInsets.addTo((Dimension)it, (Insets)button2.getInsets());
        JBInsets.addTo((Dimension)it, (Insets)DefaultLinkButtonUIKt.access$focusInsets(button2));
        Dimension dimension2 = dimension;
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"also(...)");
        return dimension2;
    }

    @Override
    public boolean contains(@Nullable JComponent c, int x, int y) {
        AbstractButton abstractButton = c instanceof AbstractButton ? (AbstractButton)c : null;
        if (abstractButton == null) {
            return false;
        }
        AbstractButton button2 = abstractButton;
        Layout layout2 = new Layout(button2, DefaultLinkButtonUIKt.access$viewBounds(button2), null, 4, null);
        return layout2.getIconBounds().contains(x, y) || layout2.getTextBounds().contains(x, y) || layout2.getBounds().contains(x, y);
    }

    @Override
    public void paint(@NotNull Graphics g, @Nullable JComponent c) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        AbstractButton abstractButton = c instanceof AbstractButton ? (AbstractButton)c : null;
        if (abstractButton == null) {
            return;
        }
        AbstractButton button2 = abstractButton;
        g.setFont(button2.getFont());
        Rectangle rectangle = DefaultLinkButtonUIKt.access$viewBounds(button2);
        FontMetrics fontMetrics = UIUtilities.getFontMetrics((JComponent)button2, g);
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
        Layout layout2 = new Layout(button2, rectangle, fontMetrics);
        if (DefaultLinkButtonUIKt.access$isPressed(button2)) {
            this.setTextShiftOffset();
        } else {
            this.clearTextShiftOffset();
        }
        this.paintIcon(g, button2, layout2.getIconBounds());
        if (((CharSequence)layout2.getText()).length() > 0) {
            int offset = this.getTextShiftOffset();
            Rectangle rectangle2 = layout2.getTextBounds();
            rectangle2.x += offset;
            rectangle2 = layout2.getTextBounds();
            rectangle2.y += offset;
            boolean hovered = DefaultLinkButtonUIKt.access$isHovered(button2);
            View view2 = DefaultLinkButtonUIKt.access$htmlView(button2);
            if (view2 == null) {
                g.setColor(DefaultLinkButtonUIKt.access$getTextColor(button2));
                int index = DefaultLinkButtonUIKt.access$isEnabled(button2) && LookAndFeelThemeAdapter.Companion.isAltPressed() ? button2.getDisplayedMnemonicIndex() : -1;
                UIUtilities.drawStringUnderlineCharAt(button2, g, layout2.getText(), index, layout2.getTextBounds().x, layout2.getBaseline());
                if (hovered) {
                    g.fillRect(layout2.getTextBounds().x, layout2.getBaseline() + 1, layout2.getTextBounds().width, 1);
                }
            } else if (hovered) {
                if (this.cached == null) {
                    this.cached = DefaultLinkButtonUIKt.access$createUnderlinedView(button2, layout2.getText());
                }
                View view3 = this.cached;
                Intrinsics.checkNotNull((Object)view3);
                view3.paint(g, layout2.getTextBounds());
            } else {
                view2.paint(g, layout2.getTextBounds());
            }
        }
        if (g instanceof Graphics2D && DefaultLinkButtonUIKt.access$isFocused(button2)) {
            Rectangle hovered;
            ((Graphics2D)g).setRenderingHint(IdeBackgroundUtil.NO_BACKGROUND_HINT, true);
            ((Graphics2D)g).setColor(JBUI.CurrentTheme.Link.FOCUSED_BORDER_COLOR);
            Rectangle it = hovered = layout2.getBounds();
            boolean bl = false;
            JBInsets.addTo((Rectangle)it, (Insets)DefaultLinkButtonUIKt.access$focusInsets(button2));
            Rectangle bounds = hovered;
            int round = Registry.Companion.intValue("ide.link.button.focus.round.arc", 4);
            RectanglePainter.DRAW.paint((Graphics2D)g, bounds.x, bounds.y, bounds.width, bounds.height, (Object)JBUIScale.scale((int)round));
        }
    }

    @Override
    @NotNull
    protected BasicButtonListener createButtonListener(@NotNull AbstractButton button2) {
        Intrinsics.checkNotNullParameter((Object)button2, (String)"button");
        return new BasicButtonListener(button2, this){
            final /* synthetic */ DefaultLinkButtonUI this$0;
            {
                this.this$0 = $receiver;
                super($button);
            }

            public void propertyChange(PropertyChangeEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                DefaultLinkButtonUI.access$setCached$p(this.this$0, null);
                super.propertyChange(event);
            }

            public void stateChanged(ChangeEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Object object = event.getSource();
                AbstractButton abstractButton = object instanceof AbstractButton ? (AbstractButton)object : null;
                if (abstractButton == null) {
                    return;
                }
                AbstractButton source = abstractButton;
                if (source.isRolloverEnabled()) {
                    source.setCursor(DefaultLinkButtonUIKt.access$isHovered(source) ? Cursor.getPredefinedCursor(12) : null);
                }
                source.repaint();
            }
        };
    }

    @JvmStatic
    @NotNull
    public static final DefaultLinkButtonUI createUI(@Nullable JComponent c) {
        return Companion.createUI(c);
    }

    public static final /* synthetic */ void access$setCached$p(DefaultLinkButtonUI $this, View view2) {
        $this.cached = view2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ui/components/DefaultLinkButtonUI$Companion;", "", "<init>", "()V", "createUI", "Lcom/intellij/ui/components/DefaultLinkButtonUI;", "c", "Ljavax/swing/JComponent;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DefaultLinkButtonUI createUI(@Nullable JComponent c) {
            return new DefaultLinkButtonUI();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

