/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.util.text.CharSequenceBackedByChars;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BufferToCharsKt;
import org.jetbrains.io.Decoder;

public abstract class MessageDecoder
extends Decoder {
    protected int contentLength;
    protected final StringBuilder builder = new StringBuilder(64);
    private CharBuffer chunkedContent;
    private int consumedContentByteCount = 0;

    protected final int parseContentLength() {
        return MessageDecoder.parseInt(this.builder, 0, false, 10);
    }

    @Nullable
    protected final CharSequence readChars(@NotNull ByteBuf input) {
        String result2;
        int readableBytes;
        if (input == null) {
            MessageDecoder.$$$reportNull$$$0(0);
        }
        if ((readableBytes = input.readableBytes()) == 0) {
            input.release();
            return null;
        }
        int required = this.contentLength - this.consumedContentByteCount;
        if (readableBytes < required) {
            if (this.chunkedContent == null) {
                this.chunkedContent = CharBuffer.allocate(this.contentLength);
            }
            BufferToCharsKt.readIntoCharBuffer(input, readableBytes, this.chunkedContent);
            this.consumedContentByteCount += readableBytes;
            input.release();
            return null;
        }
        CharBuffer charBuffer = this.chunkedContent;
        if (charBuffer != null) {
            this.chunkedContent = null;
            this.consumedContentByteCount = 0;
            BufferToCharsKt.readIntoCharBuffer(input, required, charBuffer);
            result2 = new CharSequenceBackedByChars(charBuffer);
        } else {
            result2 = input.toString(input.readerIndex(), required, StandardCharsets.UTF_8);
        }
        input.readerIndex(input.readerIndex() + required);
        return result2;
    }

    @Override
    public void channelInactive(ChannelHandlerContext context2) throws Exception {
        try {
            this.chunkedContent = null;
        }
        finally {
            super.channelInactive(context2);
        }
    }

    public static boolean readUntil(char what, @NotNull ByteBuf buffer2, @NotNull StringBuilder builder) {
        int i2;
        if (buffer2 == null) {
            MessageDecoder.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            MessageDecoder.$$$reportNull$$$0(2);
        }
        int n = buffer2.writerIndex();
        for (i2 = buffer2.readerIndex(); i2 < n; ++i2) {
            char c = (char)buffer2.getByte(i2);
            if (c == what) {
                buffer2.readerIndex(i2 + 1);
                return true;
            }
            builder.append(c);
        }
        buffer2.readerIndex(i2);
        return false;
    }

    public static void skipWhitespace(@NotNull ByteBuf buffer2) {
        if (buffer2 == null) {
            MessageDecoder.$$$reportNull$$$0(3);
        }
        int n = buffer2.writerIndex();
        for (int i2 = buffer2.readerIndex(); i2 < n; ++i2) {
            char c = (char)buffer2.getByte(i2);
            if (c == ' ') continue;
            buffer2.readerIndex(i2);
            return;
        }
        buffer2.readerIndex(n);
    }

    public static int parseInt(@NotNull CharSequence value, int start2, boolean isNegative, int radix) {
        int i2;
        if (value == null) {
            MessageDecoder.$$$reportNull$$$0(4);
        }
        int end = value.length();
        int result2 = 0;
        for (i2 = start2; i2 < end; ++i2) {
            int digit;
            char c = value.charAt(i2);
            int n = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (digit = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (digit < 0 || digit >= radix) break;
            int newResult = result2 * radix - digit;
            if (newResult > result2) {
                throw new NumberFormatException("Overflow parsing " + String.valueOf(value.subSequence(start2, end)));
            }
            result2 = newResult;
        }
        if (result2 == 0 && (end == 0 || value.charAt(i2 - 1) != '0')) {
            throw new NumberFormatException("Invalid integer representation for " + String.valueOf(value.subSequence(start2, end)));
        }
        if (result2 == Integer.MIN_VALUE && !isNegative) {
            throw new NumberFormatException("Overflow parsing " + String.valueOf(value.subSequence(start2, end)));
        }
        return isNegative ? result2 : -result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/io/MessageDecoder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readChars";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readUntil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "skipWhitespace";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parseInt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

