/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.provider;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelMachine;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.LocalEelApi;
import com.intellij.platform.eel.provider.EelInitialization;
import com.intellij.platform.eel.provider.EelMachineProviderUtil;
import com.intellij.platform.eel.provider.EelProvider;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.eel.provider.LocalEelMachine;
import com.intellij.platform.eel.provider.LocalPosixEelApi;
import com.intellij.platform.eel.provider.LocalWindowsEelApi;
import com.intellij.util.system.OS;
import java.nio.file.Path;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0003\u001a\u00020\u0002*\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0007\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\u0004H\u0007\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u000bH\u0007\u001a\u0014\u0010\u0015\u001a\u00020\u0014*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u000bH\u0007\u001a\f\u0010\u0015\u001a\u00020\u0014*\u00020\u000bH\u0007\u001a\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0014H\u0007\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\r\u001a\u00020\u000e8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"EEL_MACHINE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/platform/eel/EelMachine;", "getEelMachine", "Lcom/intellij/openapi/project/Project;", "setEelMachine", "", "machine", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getEelDescriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "Ljava/nio/file/Path;", "localEel", "Lcom/intellij/platform/eel/LocalEelApi;", "getLocalEel", "()Lcom/intellij/platform/eel/LocalEelApi;", "localEel$delegate", "Lkotlin/Lazy;", "upgradeBlocking", "Lcom/intellij/platform/eel/EelApi;", "toEelApiBlocking", "descriptor", "systemOs", "Lcom/intellij/util/system/OS;", "intellij.platform.eel.provider"})
@JvmName(name="EelProviderUtil")
@SourceDebugExtension(value={"SMAP\nEelProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelProvider.kt\ncom/intellij/platform/eel/provider/EelProviderUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,259:1\n1#2:260\n30#3,2:261\n13#4:263\n*S KotlinDebug\n*F\n+ 1 EelProvider.kt\ncom/intellij/platform/eel/provider/EelProviderUtil\n*L\n172#1:261,2\n88#1:263\n*E\n"})
public final class EelProviderUtil {
    @NotNull
    private static final Key<EelMachine> EEL_MACHINE_KEY;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Lazy localEel$delegate;

    @NotNull
    public static final EelMachine getEelMachine(@NotNull Project $this$getEelMachine) {
        Intrinsics.checkNotNullParameter((Object)$this$getEelMachine, (String)"<this>");
        EelDescriptor descriptor = EelProviderUtil.getEelDescriptor($this$getEelMachine);
        if (descriptor instanceof LocalEelDescriptor) {
            return LocalEelMachine.INSTANCE;
        }
        EelMachine cachedEelMachine = (EelMachine)$this$getEelMachine.getUserData(EEL_MACHINE_KEY);
        if (cachedEelMachine != null) {
            return cachedEelMachine;
        }
        EelMachine resolvedEelMachine = EelMachineProviderUtil.getResolvedEelMachine(descriptor);
        if (resolvedEelMachine != null) {
            logger.error("EelMachine is not initialized for project: " + $this$getEelMachine + ". Using resolved EelMachine: " + resolvedEelMachine);
            return resolvedEelMachine;
        }
        throw new IllegalStateException(("Cannot find EelMachine for project: " + $this$getEelMachine + ".").toString());
    }

    private static final void setEelMachine(Project $this$setEelMachine, EelMachine machine) {
        $this$setEelMachine.putUserData(EEL_MACHINE_KEY, (Object)machine);
    }

    @ApiStatus.Experimental
    @NotNull
    public static final EelDescriptor getEelDescriptor(@NotNull Path $this$getEelDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$getEelDescriptor, (String)"<this>");
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            for (EelProvider eelProvider : EelProvider.Companion.getEP_NAME().getExtensionsIfPointIsRegistered((AreaInstance)application)) {
                EelDescriptor eelDescriptor = eelProvider.getEelDescriptor($this$getEelDescriptor);
                if (eelDescriptor == null) continue;
                EelDescriptor it = eelDescriptor;
                boolean bl = false;
                return it;
            }
        }
        return LocalEelDescriptor.INSTANCE;
    }

    @ApiStatus.Experimental
    @NotNull
    public static final EelDescriptor getEelDescriptor(@NotNull Project $this$getEelDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$getEelDescriptor, (String)"<this>");
        String filePath = $this$getEelDescriptor.getProjectFilePath();
        if (filePath == null) {
            return LocalEelDescriptor.INSTANCE;
        }
        Path path = Path.of(filePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        return EelProviderUtil.getEelDescriptor(path);
    }

    @ApiStatus.Experimental
    @NotNull
    public static final LocalEelApi getLocalEel() {
        Lazy lazy = localEel$delegate;
        return (LocalEelApi)lazy.getValue();
    }

    @Deprecated(message="Use toEelApiBlocking() instead", replaceWith=@ReplaceWith(expression="toEelApiBlocking()", imports={}))
    @ApiStatus.Internal
    @NotNull
    public static final EelApi upgradeBlocking(@NotNull EelDescriptor $this$upgradeBlocking) {
        Intrinsics.checkNotNullParameter((Object)$this$upgradeBlocking, (String)"<this>");
        return EelProviderUtil.toEelApiBlocking($this$upgradeBlocking);
    }

    @ApiStatus.Experimental
    @NotNull
    public static final EelApi toEelApiBlocking(@NotNull EelMachine $this$toEelApiBlocking, @NotNull EelDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$toEelApiBlocking, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return (EelApi)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super EelApi>, Object>($this$toEelApiBlocking, descriptor, null){
            int label;
            final /* synthetic */ EelMachine $this_toEelApiBlocking;
            final /* synthetic */ EelDescriptor $descriptor;
            {
                this.$this_toEelApiBlocking = $receiver;
                this.$descriptor = $descriptor;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$this_toEelApiBlocking.toEelApi(this.$descriptor, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super EelApi> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @ApiStatus.Experimental
    @NotNull
    public static final EelApi toEelApiBlocking(@NotNull EelDescriptor $this$toEelApiBlocking) {
        Intrinsics.checkNotNullParameter((Object)$this$toEelApiBlocking, (String)"<this>");
        if ($this$toEelApiBlocking == LocalEelDescriptor.INSTANCE) {
            return (EelApi)EelProviderUtil.getLocalEel();
        }
        return (EelApi)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super EelApi>, Object>($this$toEelApiBlocking, null){
            int label;
            final /* synthetic */ EelDescriptor $this_toEelApiBlocking;
            {
                this.$this_toEelApiBlocking = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = EelMachineProviderUtil.toEelApi(this.$this_toEelApiBlocking, (Continuation<? super EelApi>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super EelApi> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @ApiStatus.Internal
    @NotNull
    public static final OS systemOs(@NotNull EelApi $this$systemOs) {
        OS oS;
        Intrinsics.checkNotNullParameter((Object)$this$systemOs, (String)"<this>");
        EelPlatform eelPlatform = $this$systemOs.getPlatform();
        if (eelPlatform instanceof EelPlatform.Linux) {
            oS = OS.Linux;
        } else if (eelPlatform instanceof EelPlatform.Darwin) {
            oS = OS.macOS;
        } else if (eelPlatform instanceof EelPlatform.Windows) {
            oS = OS.Windows;
        } else if (eelPlatform instanceof EelPlatform.FreeBSD) {
            oS = OS.FreeBSD;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return oS;
    }

    private static final LocalEelApi localEel_delegate$lambda$0() {
        LocalEelApi localEelApi;
        if (SystemInfo.isWindows) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<LocalWindowsEelApi> serviceClass$iv = LocalWindowsEelApi.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            localEelApi = (LocalEelApi)object;
        } else {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<LocalPosixEelApi> serviceClass$iv = LocalPosixEelApi.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            localEelApi = (LocalEelApi)object;
        }
        return localEelApi;
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ void access$setEelMachine(Project $receiver, EelMachine machine) {
        EelProviderUtil.setEelMachine($receiver, machine);
    }

    static {
        Key key = Key.create((String)"com.intellij.platform.eel.machine");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        EEL_MACHINE_KEY = key;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EelInitialization.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        EelProviderUtil.logger = logger;
        localEel$delegate = LazyKt.lazy(EelProviderUtil::localEel_delegate$lambda$0);
    }
}

