/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.executors;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.ui.UIBundle;
import com.intellij.xdebugger.XDebuggerBundle;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DefaultDebugExecutor
extends Executor {
    @NonNls
    public static final String EXECUTOR_ID = "Debug";

    @NotNull
    public String getToolWindowId() {
        return EXECUTOR_ID;
    }

    @NotNull
    public Icon getToolWindowIcon() {
        Icon icon = AllIcons.Toolwindows.ToolWindowDebugger;
        if (icon == null) {
            DefaultDebugExecutor.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Actions.StartDebugger;
        if (icon == null) {
            DefaultDebugExecutor.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public Icon getRerunIcon() {
        Icon icon = AllIcons.Actions.RestartDebugger;
        if (icon == null) {
            DefaultDebugExecutor.$$$reportNull$$$0(2);
        }
        return icon;
    }

    public Icon getDisabledIcon() {
        return IconLoader.getDisabledIcon((Icon)this.getIcon());
    }

    @NotNull
    public String getActionName() {
        String string = UIBundle.message((String)"tool.window.name.debug", (Object[])new Object[0]);
        if (string == null) {
            DefaultDebugExecutor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getId() {
        return EXECUTOR_ID;
    }

    public String getContextActionId() {
        return "DebugClass";
    }

    @NotNull
    public String getStartActionText() {
        String string = XDebuggerBundle.message("debugger.runner.start.action.text", new Object[0]);
        if (string == null) {
            DefaultDebugExecutor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public String getStartActionText(@NotNull String configurationName) {
        if (configurationName == null) {
            DefaultDebugExecutor.$$$reportNull$$$0(5);
        }
        if (configurationName.isEmpty()) {
            String string = this.getStartActionText();
            if (string == null) {
                DefaultDebugExecutor.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = TextWithMnemonic.parse((String)XDebuggerBundle.message("debugger.runner.start.action.text.2", new Object[0])).replaceFirst("%s", DefaultDebugExecutor.shortenNameIfNeeded((String)configurationName)).toString();
        if (string == null) {
            DefaultDebugExecutor.$$$reportNull$$$0(7);
        }
        return string;
    }

    public String getDescription() {
        return XDebuggerBundle.message("string.debugger.runner.description", new Object[0]);
    }

    public String getHelpId() {
        return "debugging.DebugWindow";
    }

    public boolean isSupportedOnTarget() {
        return EXECUTOR_ID.equalsIgnoreCase(this.getId());
    }

    public static Executor getDebugExecutorInstance() {
        return ExecutorRegistry.getInstance().getExecutorById(EXECUTOR_ID);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/executors/DefaultDebugExecutor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRerunIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartActionText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/executors/DefaultDebugExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStartActionText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5 -> new IllegalArgumentException(string);
        };
    }
}

