/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion.logger;

import com.intellij.openapi.Disposable;
import com.intellij.stats.completion.LogEventSerializer;
import com.intellij.stats.completion.events.LogEvent;
import com.intellij.stats.completion.logger.FileLogger;
import com.intellij.stats.completion.logger.SessionValidator;
import com.intellij.stats.completion.tracker.CompletionEventLogger;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\u00020\u00102\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/stats/completion/logger/EventLoggerWithValidation;", "Lcom/intellij/stats/completion/tracker/CompletionEventLogger;", "Lcom/intellij/openapi/Disposable;", "fileLogger", "Lcom/intellij/stats/completion/logger/FileLogger;", "validator", "Lcom/intellij/stats/completion/logger/SessionValidator;", "<init>", "(Lcom/intellij/stats/completion/logger/FileLogger;Lcom/intellij/stats/completion/logger/SessionValidator;)V", "taskExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "session", "", "Lcom/intellij/stats/completion/events/LogEvent;", "log", "", "event", "dispose", "validateAndLogInBackground", "flush", "", "validateAndLog", "", "intellij.statsCollector"})
@SourceDebugExtension(value={"SMAP\nEventLoggerWithValidation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventLoggerWithValidation.kt\ncom/intellij/stats/completion/logger/EventLoggerWithValidation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1586#2:63\n1661#2,3:64\n*S KotlinDebug\n*F\n+ 1 EventLoggerWithValidation.kt\ncom/intellij/stats/completion/logger/EventLoggerWithValidation\n*L\n59#1:63\n59#1:64,3\n*E\n"})
public final class EventLoggerWithValidation
implements CompletionEventLogger,
Disposable {
    @NotNull
    private final FileLogger fileLogger;
    @NotNull
    private final SessionValidator validator;
    @NotNull
    private final ExecutorService taskExecutor;
    @NotNull
    private final List<LogEvent> session;

    public EventLoggerWithValidation(@NotNull FileLogger fileLogger, @NotNull SessionValidator validator) {
        Intrinsics.checkNotNullParameter((Object)fileLogger, (String)"fileLogger");
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        this.fileLogger = fileLogger;
        this.validator = validator;
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Completion Events Log Executor");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createSequentialApplicationPoolExecutor(...)");
        this.taskExecutor = executorService;
        this.session = new ArrayList();
    }

    @Override
    public void log(@NotNull LogEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.session.isEmpty() || Intrinsics.areEqual((Object)event.getSessionUid(), (Object)((LogEvent)CollectionsKt.first(this.session)).getSessionUid())) {
            v0 = this.session.add(event);
        } else {
            this.validateAndLogInBackground(false);
            v0 = this.session.add(event);
        }
    }

    public void dispose() {
        this.validateAndLogInBackground(true);
    }

    private final void validateAndLogInBackground(boolean flush) {
        List lastSession = CollectionsKt.toList((Iterable)this.session);
        this.taskExecutor.execute(() -> EventLoggerWithValidation.validateAndLogInBackground$lambda$0(this, lastSession, flush));
        this.session.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void validateAndLog(List<? extends LogEvent> session) {
        void $this$mapTo$iv$iv;
        this.validator.validate(session);
        Iterable $this$map$iv = session;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LogEvent logEvent = (LogEvent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(LogEventSerializer.INSTANCE.toString((LogEvent)it));
        }
        List lines = (List)destination$iv$iv;
        this.fileLogger.printLines(lines);
    }

    private static final void validateAndLogInBackground$lambda$0(EventLoggerWithValidation this$0, List $lastSession, boolean $flush) {
        this$0.validateAndLog($lastSession);
        if ($flush) {
            this$0.fileLogger.flush();
        }
    }
}

