/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.VcsLogFileHistoryHandler;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.graph.PermanentGraph;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000 G2\u00020\u0001:\u0004DEFGJ\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J \u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u000e\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u000bH&J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u000bH&J.\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u000e\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00150\u000bH&J\u001e\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!2\u0006\u0010\"\u001a\u00020#H&J&\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0017J.\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020(H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0004\u001a\u00020\u0005H&J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110!2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/H&J#\u00100\u001a\u0004\u0018\u0001H1\"\u0004\b\u0000\u001012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H103H&\u00a2\u0006\u0002\u00104J\u0012\u00105\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0012\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020=H\u0016J\u001a\u0010>\u001a\u0004\u0018\u00010/2\u0006\u0010?\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\"\u0010@\u001a\u0004\u0018\u00010\u00052\u0006\u0010<\u001a\u00020=2\u0006\u0010A\u001a\u00020\u00052\u0006\u0010B\u001a\u00020CH\u0016R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u00020\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u00106\u001a\u0004\u0018\u0001078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006H\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/log/VcsLogProvider;", "", "readFirstBlock", "Lcom/intellij/vcs/log/VcsLogProvider$DetailedLogData;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "requirements", "Lcom/intellij/vcs/log/VcsLogProvider$Requirements;", "readAllHashes", "Lcom/intellij/vcs/log/VcsLogProvider$LogData;", "commitConsumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/vcs/log/TimedVcsCommit;", "readMetadata", "", "hashes", "", "", "consumer", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "readFullDetails", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "supportedVcs", "Lcom/intellij/openapi/vcs/VcsKey;", "getSupportedVcs", "()Lcom/intellij/openapi/vcs/VcsKey;", "referenceManager", "Lcom/intellij/vcs/log/VcsLogRefManager;", "getReferenceManager", "()Lcom/intellij/vcs/log/VcsLogRefManager;", "subscribeToRootRefreshEvents", "Lcom/intellij/openapi/Disposable;", "roots", "", "refresher", "Lcom/intellij/vcs/log/VcsLogRefresher;", "getCommitsMatchingFilter", "filterCollection", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "maxCount", "", "graphOptions", "Lcom/intellij/vcs/log/graph/PermanentGraph$Options;", "getCurrentUser", "Lcom/intellij/vcs/log/VcsUser;", "getContainingBranches", "commitHash", "Lcom/intellij/vcs/log/Hash;", "getPropertyValue", "T", "property", "Lcom/intellij/vcs/log/VcsLogProperties$VcsLogProperty;", "(Lcom/intellij/vcs/log/VcsLogProperties$VcsLogProperty;)Ljava/lang/Object;", "getCurrentBranch", "diffHandler", "Lcom/intellij/vcs/log/VcsLogDiffHandler;", "getDiffHandler", "()Lcom/intellij/vcs/log/VcsLogDiffHandler;", "getFileHistoryHandler", "Lcom/intellij/vcs/log/VcsLogFileHistoryHandler;", "project", "Lcom/intellij/openapi/project/Project;", "resolveReference", "ref", "getVcsRoot", "detectedRoot", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "Requirements", "LogData", "DetailedLogData", "Companion", "intellij.platform.vcs.log"})
public interface VcsLogProvider {
    @NotNull
    public static final Companion Companion = com.intellij.vcs.log.VcsLogProvider$Companion.$$INSTANCE;
    @JvmField
    @NotNull
    public static final ExtensionPointName<VcsLogProvider> LOG_PROVIDER_EP = ExtensionPointName.Companion.create("com.intellij.logProvider");

    @NotNull
    public DetailedLogData readFirstBlock(@NotNull VirtualFile var1, @NotNull Requirements var2) throws VcsException;

    @NotNull
    public LogData readAllHashes(@NotNull VirtualFile var1, @NotNull Consumer<? super TimedVcsCommit> var2) throws VcsException;

    public void readMetadata(@NotNull VirtualFile var1, @NotNull List<String> var2, @NotNull Consumer<? super VcsCommitMetadata> var3) throws VcsException;

    public void readFullDetails(@NotNull VirtualFile var1, @NotNull List<String> var2, @NotNull Consumer<? super VcsFullCommitDetails> var3) throws VcsException;

    @NotNull
    public VcsKey getSupportedVcs();

    @NotNull
    public VcsLogRefManager getReferenceManager();

    @NotNull
    public Disposable subscribeToRootRefreshEvents(@NotNull Collection<? extends VirtualFile> var1, @NotNull VcsLogRefresher var2);

    @Deprecated(message="implement getCommitsMatchingFilter with graphOptions parameter instead")
    @NotNull
    default public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filterCollection, (String)"filterCollection");
        return this.getCommitsMatchingFilter(root, filterCollection, (PermanentGraph.Options)PermanentGraph.Options.Default, maxCount);
    }

    @NotNull
    default public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, @NotNull PermanentGraph.Options graphOptions, int maxCount) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filterCollection, (String)"filterCollection");
        Intrinsics.checkNotNullParameter((Object)graphOptions, (String)"graphOptions");
        throw new UnsupportedOperationException("Method getCommitsMatchingFilter is not implemented the class " + this.getClass().getName());
    }

    @Nullable
    public VcsUser getCurrentUser(@NotNull VirtualFile var1) throws VcsException;

    @NotNull
    public Collection<String> getContainingBranches(@NotNull VirtualFile var1, @NotNull Hash var2) throws VcsException;

    @Nullable
    public <T> T getPropertyValue(@NotNull VcsLogProperties.VcsLogProperty<T> var1);

    @Nullable
    public String getCurrentBranch(@NotNull VirtualFile var1);

    @Nullable
    default public VcsLogDiffHandler getDiffHandler() {
        return null;
    }

    @Nullable
    default public VcsLogFileHistoryHandler getFileHistoryHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return VcsLogFileHistoryHandler.Companion.getByVcs(project, this.getSupportedVcs());
    }

    @Nullable
    default public Hash resolveReference(@NotNull String ref, @NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return null;
    }

    @Nullable
    default public VirtualFile getVcsRoot(@NotNull Project project, @NotNull VirtualFile detectedRoot, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)detectedRoot, (String)"detectedRoot");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return detectedRoot;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/log/VcsLogProvider$Companion;", "", "<init>", "()V", "LOG_PROVIDER_EP", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/vcs/log/VcsLogProvider;", "intellij.platform.vcs.log"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/log/VcsLogProvider$DetailedLogData;", "", "commits", "", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "getCommits", "()Ljava/util/List;", "refs", "", "Lcom/intellij/vcs/log/VcsRef;", "getRefs", "()Ljava/util/Set;", "intellij.platform.vcs.log"})
    public static interface DetailedLogData {
        @NotNull
        public List<VcsCommitMetadata> getCommits();

        @NotNull
        public Set<VcsRef> getRefs();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/log/VcsLogProvider$LogData;", "", "refs", "", "Lcom/intellij/vcs/log/VcsRef;", "getRefs", "()Ljava/util/Set;", "users", "Lcom/intellij/vcs/log/VcsUser;", "getUsers", "intellij.platform.vcs.log"})
    public static interface LogData {
        @NotNull
        public Set<VcsRef> getRefs();

        @NotNull
        public Set<VcsUser> getUsers();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/log/VcsLogProvider$Requirements;", "", "commitCount", "", "getCommitCount", "()I", "intellij.platform.vcs.log"})
    public static interface Requirements {
        public int getCommitCount();
    }
}

