/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAndWriteScope;
import com.intellij.openapi.application.ReadResult;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.debugger.impl.shared.InlineBreakpointsCache;
import com.intellij.platform.debugger.impl.shared.proxy.InlineLightBreakpoint;
import com.intellij.platform.debugger.impl.shared.proxy.InlineVariantWithMatchingBreakpointProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugManagerProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XLineBreakpointHighlighterRange;
import com.intellij.platform.debugger.impl.shared.proxy.XLineBreakpointInlineVariantProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XLineBreakpointProxy;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.impl.breakpoints.InlineBreakpointInlayManager;
import com.intellij.xdebugger.impl.breakpoints.InlineBreakpointInlayRenderer;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 V2\u00020\u0001:\u0004STUVB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J%\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\"2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010#\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020\u0014H\u0002J*\u0010&\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010#\u001a\u0004\u0018\u00010\u00162\b\u0010'\u001a\u0004\u0018\u00010\u001dH\u0082@\u00a2\u0006\u0002\u0010(J4\u0010)\u001a\u00020\f2\n\u0010*\u001a\u00060+R\u00020\u00002\u0018\u0010,\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.0-H\u0082@\u00a2\u0006\u0002\u00100J\u0010\u00101\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002JE\u00102\u001a\b\u0012\u0004\u0012\u0002030.2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\f\u00105\u001a\b\u0012\u0004\u0012\u00020/0.H\u0003R\u00060+R\u00020\u0000j\n\u00104\u001a\u00060+R\u00020\u0000\u00a2\u0006\u0002\u00106J\u0018\u00107\u001a\u00020\u00162\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J1\u0010<\u001a\u00020\u00162\u0006\u0010=\u001a\u00020>2\u0006\u0010:\u001a\u00020;H\u0002R\u00060+R\u00020\u0000j\n\u0010*\u001a\u00060+R\u00020\u0000\u00a2\u0006\u0002\u0010?J\u001a\u0010@\u001a\u00020\u00162\b\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010:\u001a\u00020;H\u0002J7\u0010C\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010'\u001a\u0004\u0018\u00010\u001d2\b\u0010#\u001a\u0004\u0018\u00010\u00162\f\u0010D\u001a\b\u0012\u0004\u0012\u0002030.H\u0003\u00a2\u0006\u0002\u0010EJ5\u0010C\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010F\u001a\u00020G2\b\u0010#\u001a\u0004\u0018\u00010\u00162\f\u0010D\u001a\b\u0012\u0004\u0012\u0002030.H\u0003\u00a2\u0006\u0002\u0010HJ\u001e\u0010I\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020K0J0.2\u0006\u0010F\u001a\u00020GH\u0002J5\u0010L\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020K0J0.2\u0006\u0010F\u001a\u00020G2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010#\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010MJ.\u0010L\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020K0J0.2\u0006\u0010F\u001a\u00020G2\u0006\u0010N\u001a\u00020\u00162\u0006\u0010O\u001a\u00020\u0016H\u0002J\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00020\u001d0Q2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010R\u001a\b\u0012\u0004\u0012\u00020\u001d0Q2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/InlineBreakpointInlayManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "scope", "redrawQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "areInlineBreakpointsEnabled", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "document", "Lcom/intellij/openapi/editor/Document;", "breakpointModificationStamp", "Ljava/util/concurrent/atomic/AtomicLong;", "redrawLine", "", "line", "", "redrawLineQueued", "redrawDocument", "e", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "initializeInNewEditor", "editor", "Lcom/intellij/openapi/editor/Editor;", "allBreakpoints", "", "Lcom/intellij/platform/debugger/impl/shared/proxy/XLineBreakpointProxy;", "getBreakpointLines", "", "onlyLine", "(Lcom/intellij/openapi/editor/Document;Ljava/lang/Integer;)Ljava/util/Set;", "reinitializeAll", "redraw", "onlyEditor", "(Lcom/intellij/openapi/editor/Document;Ljava/lang/Integer;Lcom/intellij/openapi/editor/Editor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "redrawVariants", "snapshot", "Lcom/intellij/xdebugger/impl/breakpoints/InlineBreakpointInlayManager$RedrawSnapshot;", "variantsByLine", "", "", "Lcom/intellij/platform/debugger/impl/shared/proxy/InlineVariantWithMatchingBreakpointProxy;", "(Lcom/intellij/xdebugger/impl/breakpoints/InlineBreakpointInlayManager$RedrawSnapshot;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isSuitableEditor", "collectInlayData", "Lcom/intellij/xdebugger/impl/breakpoints/InlineBreakpointInlayManager$SingleInlayDatum;", "<unused var>", "variants", "(Lcom/intellij/xdebugger/impl/breakpoints/InlineBreakpointInlayManager$RedrawSnapshot;Lcom/intellij/openapi/editor/Document;ILjava/util/List;)Ljava/util/List;", "getBreakpointVariantRangeStartOffset", "variant", "Lcom/intellij/platform/debugger/impl/shared/proxy/XLineBreakpointInlineVariantProxy;", "lineRange", "Lkotlin/ranges/IntRange;", "getBreakpointRangeStartOffset", "breakpoint", "Lcom/intellij/platform/debugger/impl/shared/proxy/InlineLightBreakpoint;", "(Lcom/intellij/xdebugger/impl/breakpoints/InlineBreakpointInlayManager$RedrawSnapshot;Lcom/intellij/platform/debugger/impl/shared/proxy/InlineLightBreakpoint;Lkotlin/ranges/IntRange;)I", "getBreakpointRangeStartNormalized", "breakpointRange", "Lcom/intellij/openapi/util/TextRange;", "insertInlays", "inlays", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/editor/Editor;Ljava/lang/Integer;Ljava/util/List;)V", "inlayModel", "Lcom/intellij/openapi/editor/InlayModel;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/editor/InlayModel;Ljava/lang/Integer;Ljava/util/List;)V", "getAllExistingInlays", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/xdebugger/impl/breakpoints/InlineBreakpointInlayRenderer;", "getExistingInlays", "(Lcom/intellij/openapi/editor/InlayModel;Lcom/intellij/openapi/editor/Document;Ljava/lang/Integer;)Ljava/util/List;", "startOffset", "endOffset", "allEditorsFor", "Ljava/util/stream/Stream;", "suitableEditorsFor", "RedrawPostponeException", "RedrawSnapshot", "SingleInlayDatum", "Companion", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nInlineBreakpointInlayManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineBreakpointInlayManager.kt\ncom/intellij/xdebugger/impl/breakpoints/InlineBreakpointInlayManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,414:1\n1586#2:415\n1661#2,3:416\n1586#2:419\n1661#2,3:420\n1915#2,2:423\n1807#2,3:426\n1#3:425\n78#4:429\n99#4,5:430\n*S KotlinDebug\n*F\n+ 1 InlineBreakpointInlayManager.kt\ncom/intellij/xdebugger/impl/breakpoints/InlineBreakpointInlayManager\n*L\n155#1:415\n155#1:416,3\n321#1:419\n321#1:420,3\n376#1:423,2\n264#1:426,3\n267#1:429\n267#1:430,5\n*E\n"})
public final class InlineBreakpointInlayManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final MergingUpdateQueue redrawQueue;
    @NotNull
    private final AtomicLong breakpointModificationStamp;

    public InlineBreakpointInlayManager(@NotNull Project project, @NotNull CoroutineScope parentScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        this.project = project;
        this.scope = CoroutineScopeKt.childScope$default((CoroutineScope)parentScope, (String)"InlineBreakpoints", null, (boolean)false, (int)6, null);
        this.redrawQueue = MergingUpdateQueue.Companion.mergingUpdateQueue("inline breakpoint inlay redraw queue", 300, this.scope).setRestartTimerOnAdd(true);
        this.breakpointModificationStamp = new AtomicLong(0L);
        MessageBusConnection busConnection = this.project.getMessageBus().connect();
        if (!this.project.isDefault()) {
            EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

                public void editorCreated(EditorFactoryEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Editor editor = event.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                    this.initializeInNewEditor(editor);
                }

                public void editorReleased(EditorFactoryEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    InlineBreakpointsCache inlineBreakpointsCache = XDebugManagerProxy.Companion.getInstance().getBreakpointManagerProxy(project).getInlineBreakpointsCache();
                    Editor editor = event.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                    inlineBreakpointsCache.editorReleased(editor);
                }
            }, (Disposable)this.project);
            Object[] objectArray = new String[]{"debugger.show.breakpoints.inline", "debugger.show.breakpoints.inline.even.trivial"};
            for (String key : CollectionsKt.listOf((Object[])objectArray)) {
                Registry.Companion.get(key).addListener(new RegistryValueListener(){

                    public void afterValueChanged(RegistryValue value) {
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        this.reinitializeAll();
                    }
                }, (Disposable)this.project);
            }
            XDebugManagerProxy.Companion.getInstance().getBreakpointManagerProxy(this.project).subscribeOnBreakpointsChanges((Disposable)busConnection, () -> InlineBreakpointInlayManager._init_$lambda$0(this));
        }
    }

    private final boolean areInlineBreakpointsEnabled(VirtualFile virtualFile) {
        return XDebuggerUtil.areInlineBreakpointsEnabled((VirtualFile)virtualFile);
    }

    private final boolean areInlineBreakpointsEnabled(Document document) {
        return this.areInlineBreakpointsEnabled(FileDocumentManager.getInstance().getFile(document));
    }

    public final void redrawLine(@NotNull Document document, int line) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (!this.areInlineBreakpointsEnabled(document)) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, document, line, null){
            int label;
            final /* synthetic */ InlineBreakpointInlayManager this$0;
            final /* synthetic */ Document $document;
            final /* synthetic */ int $line;
            {
                this.this$0 = $receiver;
                this.$document = $document;
                this.$line = $line;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = InlineBreakpointInlayManager.access$redraw(this.this$0, this.$document, Boxing.boxInt((int)this.$line), null, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void redrawLineQueued(Document document, int line) {
        if (!this.areInlineBreakpointsEnabled(document)) {
            return;
        }
        this.redrawQueue.queue(Update.Companion.create((Object)new Pair((Object)document, (Object)line), () -> InlineBreakpointInlayManager.redrawLineQueued$lambda$0(this, document, line)));
    }

    public final void redrawDocument(@NotNull DocumentEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Document document = e.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document2);
        if (file2 == null) {
            return;
        }
        if (!XDebuggerUtil.areInlineBreakpointsEnabled((VirtualFile)file2)) {
            return;
        }
        int firstLine = document2.getLineNumber(e.getOffset());
        int lastLine = document2.getLineNumber(e.getOffset() + e.getNewLength());
        this.redrawLineQueued(document2, firstLine);
        if (lastLine != firstLine) {
            this.redrawLineQueued(document2, lastLine);
        }
    }

    private final void initializeInNewEditor(Editor editor) {
        if (!this.areInlineBreakpointsEnabled(editor.getVirtualFile())) {
            return;
        }
        if (!this.isSuitableEditor(editor)) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(editor, this, null){
            Object L$0;
            int label;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ InlineBreakpointInlayManager this$0;
            {
                this.$editor = $editor;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Document document = this.$editor.getDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                        Document document2 = document;
                        if (InlineBreakpointInlayManager.access$allBreakpoints(this.this$0, document2).isEmpty()) {
                            return Unit.INSTANCE;
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)document2);
                        this.label = 1;
                        Object object2 = InlineBreakpointInlayManager.access$redraw(this.this$0, document2, null, this.$editor, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Document document = (Document)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Collection<XLineBreakpointProxy> allBreakpoints(Document document) {
        return XDebugManagerProxy.Companion.getInstance().getBreakpointManagerProxy(this.project).getLineBreakpointManager().getDocumentBreakpointProxies(document);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Integer> getBreakpointLines(Document document, Integer onlyLine) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.allBreakpoints(document);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            XLineBreakpointProxy xLineBreakpointProxy = (XLineBreakpointProxy)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLine());
        }
        Set lines = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        if (onlyLine != null) {
            lines = lines.contains(onlyLine) ? SetsKt.setOf((Object)onlyLine) : SetsKt.emptySet();
        }
        return lines;
    }

    private final void reinitializeAll() {
        Editor[] editorArray = EditorFactory.getInstance().getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getAllEditors(...)");
        for (Editor editor : editorArray) {
            Document document;
            Intrinsics.checkNotNull((Object)editor);
            if (!this.isSuitableEditor(editor)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)editor.getDocument(), (String)"getDocument(...)");
            boolean enabled = this.areInlineBreakpointsEnabled(editor.getVirtualFile());
            Job job2 = enabled ? BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, document, editor, null){
                int label;
                final /* synthetic */ InlineBreakpointInlayManager this$0;
                final /* synthetic */ Document $document;
                final /* synthetic */ Editor $editor;
                {
                    this.this$0 = $receiver;
                    this.$document = $document;
                    this.$editor = $editor;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = InlineBreakpointInlayManager.access$redraw(this.this$0, this.$document, null, this.$editor, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null) : BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, editor, null){
                int label;
                final /* synthetic */ InlineBreakpointInlayManager this$0;
                final /* synthetic */ Editor $editor;
                {
                    this.this$0 = $receiver;
                    this.$editor = $editor;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = CoroutinesKt.edtWriteAction(() -> reinitializeAll.2.invokeSuspend$lambda$0(this.this$0, this.$editor), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final Unit invokeSuspend$lambda$0(InlineBreakpointInlayManager this$0, Editor $editor) {
                    InlayModel inlayModel = $editor.getInlayModel();
                    Intrinsics.checkNotNullExpressionValue((Object)inlayModel, (String)"getInlayModel(...)");
                    Iterable $this$forEach$iv = InlineBreakpointInlayManager.access$getAllExistingInlays(this$0, inlayModel);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Inlay it = (Inlay)element$iv;
                        boolean bl = false;
                        Disposer.dispose((Disposable)((Disposable)it));
                    }
                    return Unit.INSTANCE;
                }
            }), (int)3, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object redraw(Document document, Integer onlyLine, Editor onlyEditor, Continuation<? super Unit> $completion) {
        if (!($completion instanceof redraw.1)) ** GOTO lbl-1000
        var9_5 = $completion;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ InlineBreakpointInlayManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return InlineBreakpointInlayManager.access$redraw(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = document;
                $continuation.L$1 = onlyLine;
                $continuation.L$2 = onlyEditor;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, document, null){
                    int label;
                    final /* synthetic */ InlineBreakpointInlayManager this$0;
                    final /* synthetic */ Document $document;
                    {
                        this.this$0 = $receiver;
                        this.$document = $document;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                return Boxing.boxBoolean((boolean)UtilKt.isEmpty((Stream)InlineBreakpointInlayManager.access$suitableEditorsFor(this.this$0, this.$document)));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl26
            }
            case 1: {
                onlyEditor = (Editor)$continuation.L$2;
                onlyLine = (Integer)$continuation.L$1;
                document = (Document)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                if (noSuitableEditors = ((Boolean)v0).booleanValue()) {
                    return Unit.INSTANCE;
                }
                snapshot = new RedrawSnapshot(document, onlyLine, onlyEditor);
                lines = this.getBreakpointLines(document, onlyLine);
                if (snapshot.postponeOnChanged()) {
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)document);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)onlyLine);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)onlyEditor);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)snapshot);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable(lines);
                $continuation.Z$0 = noSuitableEditors;
                $continuation.label = 2;
                v1 = XDebugManagerProxy.Companion.getInstance().getBreakpointManagerProxy(this.project).getInlineBreakpointsCache().performWithVariants(document, lines, (Function2)new Function2<Map<Integer, ? extends List<? extends InlineVariantWithMatchingBreakpointProxy>>, Continuation<? super Boolean>, Object>(this, snapshot, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ InlineBreakpointInlayManager this$0;
                    final /* synthetic */ RedrawSnapshot $snapshot;
                    {
                        this.this$0 = $receiver;
                        this.$snapshot = $snapshot;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Map map2 = (Map)this.L$0;
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void it;
                                ResultKt.throwOnFailure((Object)$result);
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                                this.label = 1;
                                Object object2 = InlineBreakpointInlayManager.access$redrawVariants(this.this$0, this.$snapshot, (Map)it, (Continuation)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(Map<Integer, ? extends List<InlineVariantWithMatchingBreakpointProxy>> p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (Continuation)$continuation);
                if (v1 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl52
            }
            case 2: {
                noSuitableEditors = $continuation.Z$0;
                lines = (Set)$continuation.L$4;
                snapshot = (RedrawSnapshot)$continuation.L$3;
                onlyEditor = (Editor)$continuation.L$2;
                onlyLine = (Integer)$continuation.L$1;
                document = (Document)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl52:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object redrawVariants(RedrawSnapshot snapshot, Map<Integer, ? extends List<InlineVariantWithMatchingBreakpointProxy>> variantsByLine, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof redrawVariants.1)) ** GOTO lbl-1000
        var10_4 = $completion;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ InlineBreakpointInlayManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return InlineBreakpointInlayManager.access$redrawVariants(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                document = snapshot.getDocument();
                onlyLine = snapshot.getOnlyLine();
                onlyEditor = snapshot.getOnlyEditor();
                $this$redrawVariants_u24lambda_u240 = snapshot;
                $i$a$-with-InlineBreakpointInlayManager$redrawVariants$2 = 0;
                $this$redrawVariants_u24lambda_u240.checkPostponed();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)snapshot);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)variantsByLine);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)document);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)onlyLine);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)onlyEditor);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)$this$redrawVariants_u24lambda_u240);
                $continuation.I$0 = $i$a$-with-InlineBreakpointInlayManager$redrawVariants$2;
                $continuation.label = 1;
                v0 = CoroutinesKt.readAndEdtWriteAction((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, redrawVariants$lambda$0$0(java.lang.Integer com.intellij.openapi.editor.Document com.intellij.xdebugger.impl.breakpoints.InlineBreakpointInlayManager$RedrawSnapshot java.util.Map com.intellij.xdebugger.impl.breakpoints.InlineBreakpointInlayManager com.intellij.openapi.editor.Editor com.intellij.openapi.application.ReadAndWriteScope ), (Lcom/intellij/openapi/application/ReadAndWriteScope;)Lcom/intellij/openapi/application/ReadResult;)((Integer)onlyLine, (Document)document, (RedrawSnapshot)$this$redrawVariants_u24lambda_u240, (Map)variantsByLine, (InlineBreakpointInlayManager)this, (Editor)onlyEditor), (Continuation)$continuation);
                ** if (v0 != var11_6) goto lbl31
lbl30:
                // 1 sources

                return var11_6;
lbl31:
                // 1 sources

                ** GOTO lbl44
            }
            case 1: {
                $i$a$-with-InlineBreakpointInlayManager$redrawVariants$2 = $continuation.I$0;
                $this$redrawVariants_u24lambda_u240 = (RedrawSnapshot)$continuation.L$5;
                onlyEditor = (Editor)$continuation.L$4;
                onlyLine = (Integer)$continuation.L$3;
                document = (Document)$continuation.L$2;
                variantsByLine = (Map)$continuation.L$1;
                snapshot = (RedrawSnapshot)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl44:
                    // 2 sources

                    return v0;
                }
                catch (RedrawPostponeException <unused var>) {
                    return Boxing.boxBoolean((boolean)false);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean isSuitableEditor(Editor editor) {
        return !DiffUtil.isDiffEditor((Editor)editor);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    private final List<SingleInlayDatum> collectInlayData(RedrawSnapshot redrawSnapshot, Document document, int line, List<InlineVariantWithMatchingBreakpointProxy> variants) {
        void $this$mapTo$iv$iv;
        boolean bl;
        IntRange lineRange = new IntRange(DocumentUtil.getLineStartIndentedOffset((Document)document, (int)line), document.getLineEndOffset(line));
        boolean bl2 = bl = !lineRange.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Iterable $this$map$iv = variants;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            int n;
            InlineVariantWithMatchingBreakpointProxy inlineVariantWithMatchingBreakpointProxy = (InlineVariantWithMatchingBreakpointProxy)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            XLineBreakpointInlineVariantProxy variant = inlineVariantWithMatchingBreakpointProxy.component1();
            InlineLightBreakpoint breakpoint2 = inlineVariantWithMatchingBreakpointProxy.component2();
            if (breakpoint2 != null) {
                n = this.getBreakpointRangeStartOffset(redrawSnapshot, breakpoint2, lineRange);
            } else {
                XLineBreakpointInlineVariantProxy xLineBreakpointInlineVariantProxy = variant;
                Intrinsics.checkNotNull((Object)xLineBreakpointInlineVariantProxy);
                n = this.getBreakpointVariantRangeStartOffset(xLineBreakpointInlineVariantProxy, lineRange);
            }
            int offset = n;
            collection.add(new SingleInlayDatum(breakpoint2, variant, offset, document, line));
        }
        return (List)destination$iv$iv;
    }

    private final int getBreakpointVariantRangeStartOffset(XLineBreakpointInlineVariantProxy variant, IntRange lineRange) {
        TextRange range = variant.getHighlightRange();
        return this.getBreakpointRangeStartNormalized(range, lineRange);
    }

    private final int getBreakpointRangeStartOffset(RedrawSnapshot snapshot, InlineLightBreakpoint breakpoint2, IntRange lineRange) {
        XLineBreakpointHighlighterRange range = breakpoint2.getHighlightRange();
        if (!(range instanceof XLineBreakpointHighlighterRange.Available)) {
            snapshot.postpone();
            throw new KotlinNothingValueException();
        }
        return this.getBreakpointRangeStartNormalized(((XLineBreakpointHighlighterRange.Available)range).getRange(), lineRange);
    }

    private final int getBreakpointRangeStartNormalized(TextRange breakpointRange, IntRange lineRange) {
        TextRange textRange = breakpointRange;
        return textRange != null ? RangesKt.coerceIn((int)textRange.getStartOffset(), (ClosedRange)((ClosedRange)lineRange)) : lineRange.getFirst();
    }

    @RequiresWriteLock
    private final void insertInlays(Document document, Editor onlyEditor, Integer onlyLine, List<SingleInlayDatum> inlays) {
        if (onlyEditor != null) {
            InlayModel inlayModel = onlyEditor.getInlayModel();
            Intrinsics.checkNotNullExpressionValue((Object)inlayModel, (String)"getInlayModel(...)");
            this.insertInlays(document, inlayModel, onlyLine, inlays);
        } else {
            Iterator iterator = this.suitableEditorsFor(document).iterator();
            while (iterator.hasNext()) {
                Editor editor = (Editor)iterator.next();
                InlayModel inlayModel = editor.getInlayModel();
                Intrinsics.checkNotNullExpressionValue((Object)inlayModel, (String)"getInlayModel(...)");
                this.insertInlays(document, inlayModel, onlyLine, inlays);
            }
        }
    }

    @RequiresWriteLock
    private final void insertInlays(Document document, InlayModel inlayModel, Integer onlyLine, List<SingleInlayDatum> inlays) {
        Iterable $this$forEach$iv = this.getExistingInlays(inlayModel, document, onlyLine);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Inlay it = (Inlay)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        for (SingleInlayDatum singleInlayDatum : inlays) {
            Inlay it;
            int line;
            Document document2;
            InlineBreakpointInlayRenderer renderer;
            InlineLightBreakpoint breakpoint2 = singleInlayDatum.component1();
            XLineBreakpointInlineVariantProxy variant = singleInlayDatum.component2();
            int offset = singleInlayDatum.component3();
            Inlay inlay = inlayModel.addInlineElement(offset, (EditorCustomElementRenderer)(renderer = new InlineBreakpointInlayRenderer(breakpoint2, variant, document2 = singleInlayDatum.component4(), line = singleInlayDatum.component5())));
            if (inlay == null) continue;
            boolean bl = false;
            renderer.setInlay((Inlay<InlineBreakpointInlayRenderer>)it);
        }
    }

    private final List<Inlay<? extends InlineBreakpointInlayRenderer>> getAllExistingInlays(InlayModel inlayModel) {
        return this.getExistingInlays(inlayModel, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private final List<Inlay<? extends InlineBreakpointInlayRenderer>> getExistingInlays(InlayModel inlayModel, Document document, Integer onlyLine) {
        if (onlyLine == null) {
            return this.getAllExistingInlays(inlayModel);
        }
        return this.getExistingInlays(inlayModel, document.getLineStartOffset(onlyLine.intValue()), document.getLineEndOffset(onlyLine.intValue()));
    }

    private final List<Inlay<? extends InlineBreakpointInlayRenderer>> getExistingInlays(InlayModel inlayModel, int startOffset, int endOffset) {
        List list = inlayModel.getInlineElementsInRange(startOffset, endOffset, InlineBreakpointInlayRenderer.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInlineElementsInRange(...)");
        return list;
    }

    private final Stream<Editor> allEditorsFor(Document document) {
        Stream stream = EditorFactory.getInstance().editors(document, this.project);
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"editors(...)");
        return stream;
    }

    private final Stream<Editor> suitableEditorsFor(Document document) {
        Stream<Object> stream = this.allEditorsFor(document).filter(arg_0 -> InlineBreakpointInlayManager.suitableEditorsFor$lambda$1(arg_0 -> InlineBreakpointInlayManager.suitableEditorsFor$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"filter(...)");
        return stream;
    }

    private static final Unit _init_$lambda$0(InlineBreakpointInlayManager this$0) {
        this$0.breakpointModificationStamp.incrementAndGet();
        return Unit.INSTANCE;
    }

    private static final void redrawLineQueued$lambda$0(InlineBreakpointInlayManager this$0, Document $document, int $line) {
        this$0.redrawLine($document, $line);
    }

    private static final boolean redrawVariants$lambda$0$0$2(InlineBreakpointInlayManager this$0, Document $document, Integer $onlyLine, Editor it) {
        InlayModel inlayModel = it.getInlayModel();
        Intrinsics.checkNotNullExpressionValue((Object)inlayModel, (String)"getInlayModel(...)");
        return this$0.getExistingInlays(inlayModel, $document, $onlyLine).isEmpty();
    }

    private static final boolean redrawVariants$lambda$0$0$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean redrawVariants$lambda$0$0$4(RedrawSnapshot $this_with, InlineBreakpointInlayManager this$0, Document $document, Editor $onlyEditor, Integer $onlyLine, List $inlays) {
        $this_with.checkPostponed();
        this$0.insertInlays($document, $onlyEditor, $onlyLine, (List<SingleInlayDatum>)$inlays);
        $this_with.checkPostponed();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final ReadResult redrawVariants$lambda$0$0(Integer $onlyLine, Document $document, RedrawSnapshot $this_with, Map $variantsByLine, InlineBreakpointInlayManager this$0, Editor $onlyEditor, ReadAndWriteScope $this$readAndEdtWriteAction) {
        void $this$flatMapTo$iv$iv;
        Object element$iv2;
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)$this$readAndEdtWriteAction, (String)"$this$readAndEdtWriteAction");
            if ($onlyLine != null && !DocumentUtil.isValidLine((int)$onlyLine, (Document)$document)) {
                return $this$readAndEdtWriteAction.value((Object)false);
            }
            $this_with.checkPostponed();
            Iterable $this$any$iv = $variantsByLine.keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    int it = ((Number)element$iv2).intValue();
                    boolean bl2 = false;
                    if (!(!DocumentUtil.isValidLine((int)it, (Document)$document))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            $this_with.postpone();
            throw new KotlinNothingValueException();
        }
        Map $this$flatMap$iv = $variantsByLine;
        boolean $i$f$flatMap = false;
        element$iv2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl3 = false;
            int line = ((Number)entry.getKey()).intValue();
            List variants = (List)entry.getValue();
            Iterable list$iv$iv = this$0.collectInlayData($this_with, $document, line, variants);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List inlays = (List)destination$iv$iv;
        $this_with.checkPostponed();
        if ($onlyLine != null && inlays.isEmpty() && this$0.allEditorsFor($document).allMatch(arg_0 -> InlineBreakpointInlayManager.redrawVariants$lambda$0$0$3(arg_0 -> InlineBreakpointInlayManager.redrawVariants$lambda$0$0$2(this$0, $document, $onlyLine, arg_0), arg_0))) {
            return $this$readAndEdtWriteAction.value((Object)false);
        }
        return $this$readAndEdtWriteAction.writeAction(() -> InlineBreakpointInlayManager.redrawVariants$lambda$0$0$4($this_with, this$0, $document, $onlyEditor, $onlyLine, inlays));
    }

    private static final boolean suitableEditorsFor$lambda$0(InlineBreakpointInlayManager this$0, Editor it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.isSuitableEditor(it);
    }

    private static final boolean suitableEditorsFor$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final InlineBreakpointInlayManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Object access$redraw(InlineBreakpointInlayManager $this, Document document, Integer onlyLine, Editor onlyEditor, Continuation $completion) {
        return $this.redraw(document, onlyLine, onlyEditor, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Collection access$allBreakpoints(InlineBreakpointInlayManager $this, Document document) {
        return $this.allBreakpoints(document);
    }

    public static final /* synthetic */ List access$getAllExistingInlays(InlineBreakpointInlayManager $this, InlayModel inlayModel) {
        return $this.getAllExistingInlays(inlayModel);
    }

    public static final /* synthetic */ Stream access$suitableEditorsFor(InlineBreakpointInlayManager $this, Document document) {
        return $this.suitableEditorsFor(document);
    }

    public static final /* synthetic */ Object access$redrawVariants(InlineBreakpointInlayManager $this, RedrawSnapshot snapshot, Map variantsByLine, Continuation $completion) {
        return $this.redrawVariants(snapshot, variantsByLine, (Continuation<? super Boolean>)$completion);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/InlineBreakpointInlayManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/xdebugger/impl/breakpoints/InlineBreakpointInlayManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.debugger.impl"})
    @SourceDebugExtension(value={"SMAP\nInlineBreakpointInlayManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineBreakpointInlayManager.kt\ncom/intellij/xdebugger/impl/breakpoints/InlineBreakpointInlayManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,414:1\n30#2,2:415\n*S KotlinDebug\n*F\n+ 1 InlineBreakpointInlayManager.kt\ncom/intellij/xdebugger/impl/breakpoints/InlineBreakpointInlayManager$Companion\n*L\n411#1:415,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final InlineBreakpointInlayManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<InlineBreakpointInlayManager> serviceClass$iv = InlineBreakpointInlayManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (InlineBreakpointInlayManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/InlineBreakpointInlayManager$RedrawPostponeException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "<init>", "()V", "intellij.platform.debugger.impl"})
    private static final class RedrawPostponeException
    extends Exception {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001aH\u0002J\b\u0010\u001e\u001a\u00020\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/InlineBreakpointInlayManager$RedrawSnapshot;", "", "document", "Lcom/intellij/openapi/editor/Document;", "onlyLine", "", "onlyEditor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/xdebugger/impl/breakpoints/InlineBreakpointInlayManager;Lcom/intellij/openapi/editor/Document;Ljava/lang/Integer;Lcom/intellij/openapi/editor/Editor;)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getOnlyLine", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getOnlyEditor", "()Lcom/intellij/openapi/editor/Editor;", "documentStamp", "", "getDocumentStamp", "()J", "breakpointsStamp", "getBreakpointsStamp", "postpone", "", "checkPostponed", "", "postponeOnChanged", "", "doPostpone", "shouldBePostponed", "intellij.platform.debugger.impl"})
    private final class RedrawSnapshot {
        @NotNull
        private final Document document;
        @Nullable
        private final Integer onlyLine;
        @Nullable
        private final Editor onlyEditor;
        private final long documentStamp;
        private final long breakpointsStamp;

        public RedrawSnapshot(@Nullable Document document, @Nullable Integer onlyLine, Editor onlyEditor) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            this.document = document;
            this.onlyLine = onlyLine;
            this.onlyEditor = onlyEditor;
            this.documentStamp = this.document.getModificationStamp();
            this.breakpointsStamp = InlineBreakpointInlayManager.this.breakpointModificationStamp.get();
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        @Nullable
        public final Integer getOnlyLine() {
            return this.onlyLine;
        }

        @Nullable
        public final Editor getOnlyEditor() {
            return this.onlyEditor;
        }

        public final long getDocumentStamp() {
            return this.documentStamp;
        }

        public final long getBreakpointsStamp() {
            return this.breakpointsStamp;
        }

        @NotNull
        public final Void postpone() {
            this.doPostpone();
            throw new RedrawPostponeException();
        }

        public final void checkPostponed() {
            if (this.shouldBePostponed()) {
                this.postpone();
                throw new KotlinNothingValueException();
            }
        }

        public final boolean postponeOnChanged() {
            boolean isOutdated = this.shouldBePostponed();
            if (isOutdated) {
                this.doPostpone();
            }
            return isOutdated;
        }

        private final void doPostpone() {
            InlineBreakpointInlayManager.this.redrawQueue.queue(Update.Companion.create((Object)new Pair((Object)this.document, (Object)this.onlyLine), () -> RedrawSnapshot.doPostpone$lambda$0(InlineBreakpointInlayManager.this, this)));
        }

        private final boolean shouldBePostponed() {
            boolean documentAndPsiAreOutOfSync = !PsiDocumentManager.getInstance((Project)InlineBreakpointInlayManager.this.project).isCommitted(this.document);
            boolean documentIsOutdated = this.document.getModificationStamp() != this.documentStamp;
            boolean breakpointsAreOutdated = InlineBreakpointInlayManager.this.breakpointModificationStamp.get() != this.breakpointsStamp;
            return documentAndPsiAreOutOfSync || documentIsOutdated || breakpointsAreOutdated;
        }

        private static final void doPostpone$lambda$0(InlineBreakpointInlayManager this$0, RedrawSnapshot this$1) {
            BuildersKt.launch$default((CoroutineScope)this$0.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, this$1, null){
                int label;
                final /* synthetic */ InlineBreakpointInlayManager this$0;
                final /* synthetic */ RedrawSnapshot this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = InlineBreakpointInlayManager.access$redraw(this.this$0, this.this$1.getDocument(), this.this$1.getOnlyLine(), this.this$1.getOnlyEditor(), (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J?\u0010\u001b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001f\u001a\u00020\u0007H\u00d6\u0081\u0004J\n\u0010 \u001a\u00020!H\u00d6\u0081\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006\""}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/InlineBreakpointInlayManager$SingleInlayDatum;", "", "breakpoint", "Lcom/intellij/platform/debugger/impl/shared/proxy/InlineLightBreakpoint;", "variant", "Lcom/intellij/platform/debugger/impl/shared/proxy/XLineBreakpointInlineVariantProxy;", "offset", "", "document", "Lcom/intellij/openapi/editor/Document;", "line", "<init>", "(Lcom/intellij/platform/debugger/impl/shared/proxy/InlineLightBreakpoint;Lcom/intellij/platform/debugger/impl/shared/proxy/XLineBreakpointInlineVariantProxy;ILcom/intellij/openapi/editor/Document;I)V", "getBreakpoint", "()Lcom/intellij/platform/debugger/impl/shared/proxy/InlineLightBreakpoint;", "getVariant", "()Lcom/intellij/platform/debugger/impl/shared/proxy/XLineBreakpointInlineVariantProxy;", "getOffset", "()I", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getLine", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.debugger.impl"})
    private static final class SingleInlayDatum {
        @Nullable
        private final InlineLightBreakpoint breakpoint;
        @Nullable
        private final XLineBreakpointInlineVariantProxy variant;
        private final int offset;
        @NotNull
        private final Document document;
        private final int line;

        public SingleInlayDatum(@Nullable InlineLightBreakpoint breakpoint2, @Nullable XLineBreakpointInlineVariantProxy variant, int offset, @NotNull Document document, int line) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            this.breakpoint = breakpoint2;
            this.variant = variant;
            this.offset = offset;
            this.document = document;
            this.line = line;
        }

        @Nullable
        public final InlineLightBreakpoint getBreakpoint() {
            return this.breakpoint;
        }

        @Nullable
        public final XLineBreakpointInlineVariantProxy getVariant() {
            return this.variant;
        }

        public final int getOffset() {
            return this.offset;
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        public final int getLine() {
            return this.line;
        }

        @Nullable
        public final InlineLightBreakpoint component1() {
            return this.breakpoint;
        }

        @Nullable
        public final XLineBreakpointInlineVariantProxy component2() {
            return this.variant;
        }

        public final int component3() {
            return this.offset;
        }

        @NotNull
        public final Document component4() {
            return this.document;
        }

        public final int component5() {
            return this.line;
        }

        @NotNull
        public final SingleInlayDatum copy(@Nullable InlineLightBreakpoint breakpoint2, @Nullable XLineBreakpointInlineVariantProxy variant, int offset, @NotNull Document document, int line) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            return new SingleInlayDatum(breakpoint2, variant, offset, document, line);
        }

        public static /* synthetic */ SingleInlayDatum copy$default(SingleInlayDatum singleInlayDatum, InlineLightBreakpoint inlineLightBreakpoint, XLineBreakpointInlineVariantProxy xLineBreakpointInlineVariantProxy, int n, Document document, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                inlineLightBreakpoint = singleInlayDatum.breakpoint;
            }
            if ((n3 & 2) != 0) {
                xLineBreakpointInlineVariantProxy = singleInlayDatum.variant;
            }
            if ((n3 & 4) != 0) {
                n = singleInlayDatum.offset;
            }
            if ((n3 & 8) != 0) {
                document = singleInlayDatum.document;
            }
            if ((n3 & 0x10) != 0) {
                n2 = singleInlayDatum.line;
            }
            return singleInlayDatum.copy(inlineLightBreakpoint, xLineBreakpointInlineVariantProxy, n, document, n2);
        }

        @NotNull
        public String toString() {
            return "SingleInlayDatum(breakpoint=" + this.breakpoint + ", variant=" + this.variant + ", offset=" + this.offset + ", document=" + this.document + ", line=" + this.line + ")";
        }

        public int hashCode() {
            int result2 = this.breakpoint == null ? 0 : this.breakpoint.hashCode();
            result2 = result2 * 31 + (this.variant == null ? 0 : this.variant.hashCode());
            result2 = result2 * 31 + Integer.hashCode(this.offset);
            result2 = result2 * 31 + this.document.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.line);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SingleInlayDatum)) {
                return false;
            }
            SingleInlayDatum singleInlayDatum = (SingleInlayDatum)other;
            if (!Intrinsics.areEqual((Object)this.breakpoint, (Object)singleInlayDatum.breakpoint)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.variant, (Object)singleInlayDatum.variant)) {
                return false;
            }
            if (this.offset != singleInlayDatum.offset) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.document, (Object)singleInlayDatum.document)) {
                return false;
            }
            return this.line == singleInlayDatum.line;
        }
    }
}

