/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.XDebuggerPopupPanel;
import com.intellij.xdebugger.impl.ui.DebuggerSessionTabBase;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.actions.XSetValueAction;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class XDebuggerTreePopup<D>
extends XDebuggerPopupPanel {
    public static final String ACTION_PLACE = "XDebuggerTreePopup";
    @NonNls
    private static final String DIMENSION_SERVICE_KEY = "DebuggerActiveHint";
    @NotNull
    protected final DebuggerTreeCreator<D> myTreeCreator;
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final Editor myEditor;
    @NotNull
    protected final Point myPoint;
    @Nullable
    protected final Runnable myHideRunnable;
    @Nullable
    protected JBPopup myPopup;
    private boolean mySetValueModeEnabled;

    @ApiStatus.Experimental
    public XDebuggerTreePopup(@NotNull DebuggerTreeCreator<D> creator, @NotNull Editor editor, @NotNull Point point, @NotNull Project project, @Nullable Runnable hideRunnable) {
        if (creator == null) {
            XDebuggerTreePopup.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            XDebuggerTreePopup.$$$reportNull$$$0(1);
        }
        if (point == null) {
            XDebuggerTreePopup.$$$reportNull$$$0(2);
        }
        if (project == null) {
            XDebuggerTreePopup.$$$reportNull$$$0(3);
        }
        this.mySetValueModeEnabled = false;
        this.myTreeCreator = creator;
        this.myProject = project;
        this.myEditor = editor;
        this.myPoint = point;
        this.myHideRunnable = hideRunnable;
    }

    protected JComponent createPopupContent(Tree tree) {
        tree.setBackground(ExperimentalUI.isNewUI() ? JBUI.CurrentTheme.Popup.BACKGROUND : UIUtil.getToolTipBackground());
        return ScrollPaneFactory.createScrollPane((Component)tree, (boolean)true);
    }

    public JBPopup show(@NotNull D selectedItem) {
        if (selectedItem == null) {
            XDebuggerTreePopup.$$$reportNull$$$0(4);
        }
        return this.showTreePopup(this.myTreeCreator.createTree(selectedItem));
    }

    @NotNull
    protected DefaultActionGroup getToolbarActions() {
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        toolbarActions.add((AnAction)new EnableSetValueMode());
        toolbarActions.add((AnAction)new SetValue());
        toolbarActions.add((AnAction)new CancelSetValue());
        toolbarActions.addAll(DebuggerSessionTabBase.getCustomizedActionGroup((String)"XDebugger.Watches.Inline.Popup"));
        DefaultActionGroup defaultActionGroup = toolbarActions;
        if (defaultActionGroup == null) {
            XDebuggerTreePopup.$$$reportNull$$$0(5);
        }
        return defaultActionGroup;
    }

    private FocusListener createTreeFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (XDebuggerTreePopup.this.mySetValueModeEnabled) {
                    XDebuggerTreePopup.this.disableSetValueMode();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
    }

    private TreeModelListener createTreeModelListener(final Tree tree) {
        return new TreeModelAdapter(){

            public void treeStructureChanged(TreeModelEvent e) {
                XDebuggerTreePopup.this.resize(e.getTreePath(), (JTree)tree);
            }
        };
    }

    protected JBPopup showTreePopup(final Tree tree) {
        if (this.myPopup != null) {
            this.myPopup.cancel();
        }
        tree.getModel().addTreeModelListener(this.createTreeModelListener(tree));
        final FocusListener focusListener = this.createTreeFocusListener();
        tree.addFocusListener(focusListener);
        JComponent popupContent = this.createPopupContent(tree);
        this.setContent(popupContent, this.getToolbarActions(), ACTION_PLACE, (Component)tree);
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myContent, (JComponent)tree).setRequestFocus(true).setResizable(true).setModalContext(false).setMovable(true).setDimensionServiceKey(this.myProject, DIMENSION_SERVICE_KEY, false).setMayBeParent(true).setCancelOnOtherWindowOpen(true).setCancelKeyEnabled(false).setKeyEventHandler(event -> {
            if (!this.mySetValueModeEnabled && event.getKeyCode() == 113) {
                this.enableSetValueMode();
            } else if (AbstractPopup.isCloseRequest((KeyEvent)event)) {
                SpeedSearchBase speedSearch = (SpeedSearchBase)SpeedSearchSupply.getSupply((JComponent)tree);
                if (speedSearch != null && speedSearch.isPopupActive()) {
                    speedSearch.hidePopup();
                    return true;
                }
                if (IdeFocusManager.getInstance((Project)this.myProject).getFocusOwner() == tree) {
                    this.myPopup.cancel();
                    return true;
                }
                return false;
            }
            return false;
        }).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                tree.removeFocusListener(focusListener);
                if (XDebuggerTreePopup.this.myHideRunnable != null) {
                    XDebuggerTreePopup.this.myHideRunnable.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTreePopup$3", "onClosed"));
            }
        }).setCancelCallback(() -> {
            Window parent = SwingUtilities.getWindowAncestor((Component)tree);
            if (parent != null) {
                for (Window child : parent.getOwnedWindows()) {
                    if (!child.isShowing()) continue;
                    return false;
                }
            }
            return true;
        }).createPopup();
        XDebuggerTreePopup.registerTreeDisposable((Disposable)this.myPopup, tree);
        if (this.myEditor.isDisposed()) {
            this.myPopup.cancel();
            return null;
        }
        this.myPopup.setSize(new Dimension(0, 0));
        this.setAutoResizeUntilToolbarNotFull(() -> XDebuggerTreePopup.updateDebugPopupBounds(tree, (JComponent)this.myToolbar, this.myPopup, false), (Disposable)this.myPopup);
        this.myPopup.show(new RelativePoint((Component)this.myEditor.getContentComponent(), this.myPoint));
        XDebuggerTreePopup.setAutoResize(tree, (JComponent)this.myToolbar, this.myPopup);
        return this.myPopup;
    }

    private void resize(TreePath path, JTree tree) {
        if (this.myPopup == null || !this.myPopup.isVisible() || this.myPopup.isDisposed()) {
            return;
        }
        Window popupWindow = SwingUtilities.windowForComponent(this.myPopup.getContent());
        if (popupWindow == null) {
            return;
        }
        Dimension size = tree.getPreferredSize();
        Point location = popupWindow.getLocation();
        Rectangle windowBounds = popupWindow.getBounds();
        Rectangle bounds = tree.getPathBounds(path);
        if (bounds == null) {
            return;
        }
        Rectangle targetBounds = new Rectangle(location.x, location.y, Math.max(Math.max(size.width, bounds.width) + 20, windowBounds.width), Math.max(tree.getRowCount() * bounds.height + 55, windowBounds.height));
        ScreenUtil.cropRectangleToFitTheScreen((Rectangle)targetBounds);
        popupWindow.setBounds(targetBounds);
        popupWindow.validate();
        popupWindow.repaint();
    }

    private void enableSetValueMode() {
        this.mySetValueModeEnabled = true;
        this.myToolbar.updateActionsImmediately();
    }

    private void disableSetValueMode() {
        this.mySetValueModeEnabled = false;
        this.myToolbar.updateActionsImmediately();
    }

    @Override
    protected boolean shouldBeVisible(AnAction action) {
        boolean isSetValueModeAction = action instanceof SetValue || action instanceof CancelSetValue;
        return isSetValueModeAction && this.mySetValueModeEnabled || !isSetValueModeAction && !this.mySetValueModeEnabled;
    }

    protected static void registerTreeDisposable(Disposable disposable, Tree tree) {
        if (tree instanceof Disposable) {
            Disposer.register((Disposable)disposable, (Disposable)((Disposable)tree));
        }
    }

    public static void setAutoResize(final Tree tree, final JComponent myToolbar, final JBPopup myPopup) {
        final Ref canShrink = Ref.create((Object)true);
        ((XDebuggerTree)tree).addTreeListener(new XDebuggerTreeListener(){

            @Override
            public void childrenLoaded(@NotNull XDebuggerTreeNode node, @NotNull List<? extends XValueContainerNode<?>> children, boolean last) {
                if (node == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (children == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (last) {
                    XDebuggerTreePopup.updateDebugPopupBounds(tree, myToolbar, myPopup, (Boolean)canShrink.get());
                    canShrink.set((Object)false);
                }
            }

            @Override
            public void nodeLoaded(@NotNull RestorableStateNode node, @NotNull String name) {
                if (node == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (name == null) {
                    4.$$$reportNull$$$0(3);
                }
                XDebuggerTreePopup.updateDebugPopupBounds(tree, myToolbar, myPopup, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "children";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTreePopup$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenLoaded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "nodeLoaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        XDebuggerTreePopup.updateDebugPopupBounds(tree, myToolbar, myPopup, (Boolean)canShrink.get());
    }

    public static void updateDebugPopupBounds(Tree tree, JComponent toolbar, JBPopup popup2, boolean canShrink) {
        Window popupWindow = SwingUtilities.windowForComponent(popup2.getContent());
        if (popupWindow == null) {
            return;
        }
        Dimension size = tree.getPreferredSize();
        int hMargin = JBUI.scale((int)30);
        int vMargin = JBUI.scale((int)30);
        int width = Math.max(size.width, toolbar.getPreferredSize().width) + hMargin;
        Rectangle bounds = tree.getRowBounds(tree.getRowCount() - 1);
        int height = toolbar.getHeight() + vMargin + (bounds == null ? 0 : bounds.y + bounds.height);
        Rectangle screenRectangle = ScreenUtil.getScreenRectangle((Component)toolbar);
        int maxWidth = screenRectangle.width / 2;
        int maxHeight = screenRectangle.height / 2;
        int newWidth = Math.min(width, maxWidth);
        int newHeight = Math.min(height, maxHeight);
        if (!canShrink) {
            newWidth = Math.max(newWidth, popupWindow.getWidth());
            newHeight = Math.max(newHeight, popupWindow.getHeight());
        }
        XDebuggerTreePopup.updatePopupBounds(popupWindow, newWidth, newHeight);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedItem";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTreePopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTreePopup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private class EnableSetValueMode
    extends XSetValueAction {
        private EnableSetValueMode() {
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0)));
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EnableSetValueMode.$$$reportNull$$$0(0);
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setText(XDebuggerBundle.message((String)"xdebugger.enable.set.action.title", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EnableSetValueMode.$$$reportNull$$$0(1);
            }
            XDebuggerTreePopup.this.enableSetValueMode();
            super.actionPerformed(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTreePopup$EnableSetValueMode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SetValue
    extends AnAction {
        private SetValue() {
            super(XDebuggerBundle.message((String)"xdebugger.set.text.value.action.title", (Object[])new Object[0]));
            this.setShortcutSet(CommonShortcuts.ENTER);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SetValue.$$$reportNull$$$0(0);
            }
            Component focusedComponent = IdeFocusManager.findInstance().getFocusOwner();
            KeyEvent event = new KeyEvent(focusedComponent, 401, System.currentTimeMillis(), 0, 10, '\n');
            XDebuggerTreePopup.this.myContent.dispatchEvent((AWTEvent)event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTreePopup$SetValue", "actionPerformed"));
        }
    }

    private class CancelSetValue
    extends AnAction {
        private CancelSetValue() {
            super(XDebuggerBundle.message((String)"xdebugger.cancel.set.action.title", (Object[])new Object[0]));
            this.setShortcutSet(CommonShortcuts.ESCAPE);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CancelSetValue.$$$reportNull$$$0(0);
            }
            Component focusedComponent = IdeFocusManager.findInstance().getFocusOwner();
            KeyEvent event = new KeyEvent(focusedComponent, 401, System.currentTimeMillis(), 0, 27, '\uffff');
            XDebuggerTreePopup.this.myContent.dispatchEvent((AWTEvent)event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTreePopup$CancelSetValue", "actionPerformed"));
        }
    }
}

