/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.XSourceKind;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.inline.XDebuggerInlayUtil;
import com.intellij.xdebugger.impl.pinned.items.PinToTopUtilKt;
import com.intellij.xdebugger.impl.pinned.items.actions.XDebuggerPinToTopAction;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XRendererDecoratorPresentation;
import com.intellij.xdebugger.impl.ui.tree.nodes.HeadlessValueEvaluationCallback;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XCustomizableTextRenderer;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeEx;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodePresentationConfigurator;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValuePresentationUtil;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererImpl;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class XValueNodeImpl
extends XValueContainerNode<XValue>
implements XValueNodeEx,
XCompositeNode,
XValueNodePresentationConfigurator.ConfigurableXValueNode,
RestorableStateNode {
    private static final Logger LOG = Logger.getInstance(XValueNodeImpl.class);
    public static final Comparator<XValueNodeImpl> COMPARATOR = (o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
    private static final int MAX_NAME_LENGTH = 100;
    @NlsSafe
    private final String myName;
    @Nullable
    private String myRawValue;
    private XFullValueEvaluator myFullValueEvaluator;
    private final @NotNull AtomicReference<@Nullable XDebuggerTreeNodeHyperlink> myAdditionalHyperLink;
    private boolean myChanged;
    private XValuePresentation myValuePresentation;
    @Nullable
    private Icon myInlayIcon;

    public XValueNodeImpl(XDebuggerTree tree, @Nullable XDebuggerTreeNode parent, String name, @NotNull XValue value) {
        if (value == null) {
            XValueNodeImpl.$$$reportNull$$$0(0);
        }
        super(tree, parent, true, value);
        this.myAdditionalHyperLink = new AtomicReference();
        this.myName = name;
        value.computePresentation((XValueNode)this, XValuePlace.TREE);
        if (!this.isComputed()) {
            if (this.myName != null) {
                this.myText.append(this.myName, XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
                this.myText.append(" = ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            this.myText.append(XDebuggerUIConstants.getCollectingDataMessage(), XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
        }
    }

    XValueNodeImpl(XValueNodeImpl node, @NotNull XValue value) {
        if (value == null) {
            XValueNodeImpl.$$$reportNull$$$0(1);
        }
        super(node.getTree(), (XDebuggerTreeNode)node.getParent(), true, value);
        this.myAdditionalHyperLink = new AtomicReference();
        this.myName = node.getName();
    }

    public void setPresentation(@Nullable Icon icon, @NonNls @Nullable String type, @NonNls @NotNull String value, boolean hasChildren) {
        if (value == null) {
            XValueNodeImpl.$$$reportNull$$$0(2);
        }
        XValueNodePresentationConfigurator.setPresentation(icon, type, value, hasChildren, this);
    }

    public void setPresentation(@Nullable Icon icon, @NotNull XValuePresentation presentation, boolean hasChildren) {
        if (presentation == null) {
            XValueNodeImpl.$$$reportNull$$$0(3);
        }
        XValueNodePresentationConfigurator.setPresentation(icon, presentation, hasChildren, this);
    }

    @Override
    public void applyPresentation(@Nullable Icon icon, @NotNull XValuePresentation valuePresentation, boolean hasChildren) {
        if (valuePresentation == null) {
            XValueNodeImpl.$$$reportNull$$$0(4);
        }
        if (this.isObsolete()) {
            return;
        }
        this.setIcon(icon);
        boolean alreadyHasInline = this.myValuePresentation != null;
        this.myValuePresentation = valuePresentation;
        this.myRawValue = XValuePresentationUtil.computeValueText(valuePresentation);
        if (this.shouldUpdateInlineDebuggerData() && !alreadyHasInline) {
            this.updateInlineDebuggerData();
        }
        this.updateText();
        this.setLeaf(!hasChildren);
        this.fireNodeChanged();
        this.myTree.nodeLoaded(this, this.myName);
    }

    protected boolean shouldUpdateInlineDebuggerData() {
        return XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowValuesInline();
    }

    @ApiStatus.Internal
    protected boolean isChanged() {
        return this.myChanged;
    }

    public void setInlayIcon(@Nullable Icon icon) {
        this.myInlayIcon = icon;
    }

    @Nullable
    public Icon getInlayIcon() {
        return this.myInlayIcon;
    }

    private void updateInlineDebuggerData() {
        try {
            final XDebugSessionProxy session = XDebugView.getSessionProxy((Component)((Object)this.getTree()));
            if (session == null) {
                return;
            }
            XStackFrame currentFrame = session.getCurrentStackFrame();
            if (currentFrame == null) {
                return;
            }
            final XSourcePosition mainPosition = session.getFrameSourcePosition(currentFrame, XSourceKind.MAIN);
            final XSourcePosition altPosition = session.getFrameSourcePosition(currentFrame, XSourceKind.ALTERNATIVE);
            if (mainPosition == null && altPosition == null) {
                return;
            }
            XInlineDebuggerDataCallback callback = new XInlineDebuggerDataCallback(){

                public void computed(XSourcePosition position) {
                    VirtualFile altFile;
                    if (XValueNodeImpl.this.isObsolete() || position == null) {
                        return;
                    }
                    VirtualFile file2 = position.getFile();
                    VirtualFile mainFile = mainPosition != null ? mainPosition.getFile() : null;
                    VirtualFile virtualFile = altFile = altPosition != null ? altPosition.getFile() : null;
                    if (!Comparing.equal((Object)mainFile, (Object)file2) && !Comparing.equal((Object)altFile, (Object)file2)) {
                        return;
                    }
                    Document document = FileDocumentManager.getInstance().getDocument(file2);
                    if (document == null) {
                        return;
                    }
                    int line = position.getLine();
                    if (line >= 0) {
                        XDebuggerInlayUtil.getInstance(session.getProject()).createLineEndInlay(XValueNodeImpl.this, session, file2, line);
                    }
                }
            };
            XValue xValue = (XValue)this.getValueContainer();
            if (xValue.computeInlineDebuggerData(callback) == ThreeState.UNSURE) {
                xValue.computeSourcePosition(arg_0 -> ((XInlineDebuggerDataCallback)callback).computed(arg_0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFullValueEvaluator(@NotNull XFullValueEvaluator fullValueEvaluator) {
        if (fullValueEvaluator == null) {
            XValueNodeImpl.$$$reportNull$$$0(5);
        }
        this.invokeNodeUpdate(() -> {
            this.myFullValueEvaluator = fullValueEvaluator;
            this.fireNodeChanged();
        });
    }

    @Override
    public void addAdditionalHyperlink(@NotNull XDebuggerTreeNodeHyperlink link) {
        if (link == null) {
            XValueNodeImpl.$$$reportNull$$$0(6);
        }
        this.invokeNodeUpdate(() -> {
            if (!this.myAdditionalHyperLink.compareAndSet(null, link)) {
                LOG.warn("Additional hyperlink already set; having more than one is not supported");
            }
            this.fireNodeChanged();
        });
    }

    @Override
    public void clearAdditionalHyperlinks() {
        this.invokeNodeUpdate(() -> this.myAdditionalHyperLink.set(null));
    }

    public boolean hasLinks() {
        return this.myFullValueEvaluator != null && this.myFullValueEvaluator.isEnabled() || this.myAdditionalHyperLink.get() != null;
    }

    @Override
    public void clearFullValueEvaluator() {
        this.myFullValueEvaluator = null;
    }

    private void updateText() {
        ValueMarkup markup;
        this.myText.clear();
        XValueMarkers<?, ?> markers = this.myTree.getValueMarkers();
        if (markers != null && (markup = markers.getMarkup((XValue)this.getValueContainer())) != null) {
            XCustomizableTextRenderer renderer = XValueNodeImpl.createTextRenderer((ColoredTextContainer)this.myText, this.myValuePresentation);
            SimpleTextAttributes attributes = new SimpleTextAttributes(1, markup.getColor());
            renderer.renderRaw("[" + markup.getText() + "] ", attributes);
        }
        if (this.myValuePresentation.isShowName()) {
            this.appendName();
        }
        XValueNodeImpl.buildText(this.myValuePresentation, (ColoredTextContainer)this.myText);
    }

    private void appendName() {
        if (!StringUtil.isEmpty((String)this.myName)) {
            XCustomizableTextRenderer renderer = XValueNodeImpl.createTextRenderer((ColoredTextContainer)this.myText, this.myValuePresentation);
            SimpleTextAttributes attributes = this.isChanged() ? XDebuggerUIConstants.CHANGED_VALUE_ATTRIBUTES : XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES;
            XValuePresentationUtil.renderName(this.myName, 100, s -> renderer.renderRaw((String)s, attributes));
        }
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public XValue getXValue() {
        XValue xValue = (XValue)this.getValueContainer();
        if (xValue == null) {
            XValueNodeImpl.$$$reportNull$$$0(7);
        }
        return xValue;
    }

    @NotNull
    private static XCustomizableTextRenderer createTextRenderer(ColoredTextContainer text, XValuePresentation valuePresentation) {
        XCustomizableTextRenderer renderer = new XValueTextRendererImpl(text);
        if (valuePresentation instanceof XRendererDecoratorPresentation) {
            XRendererDecoratorPresentation decoratorPresentation = (XRendererDecoratorPresentation)valuePresentation;
            renderer = decoratorPresentation.decorate(renderer);
        }
        XValueTextRendererImpl xValueTextRendererImpl = renderer;
        if (xValueTextRendererImpl == null) {
            XValueNodeImpl.$$$reportNull$$$0(8);
        }
        return xValueTextRendererImpl;
    }

    public static void buildText(@NotNull XValuePresentation valuePresenter, @NotNull ColoredTextContainer text) {
        if (valuePresenter == null) {
            XValueNodeImpl.$$$reportNull$$$0(9);
        }
        if (text == null) {
            XValueNodeImpl.$$$reportNull$$$0(10);
        }
        XValueNodeImpl.buildText(valuePresenter, text, true);
    }

    public static void buildText(@NotNull XValuePresentation valuePresenter, @NotNull ColoredTextContainer text, boolean appendSeparator) {
        String type;
        String separator;
        if (valuePresenter == null) {
            XValueNodeImpl.$$$reportNull$$$0(11);
        }
        if (text == null) {
            XValueNodeImpl.$$$reportNull$$$0(12);
        }
        XCustomizableTextRenderer renderer = XValueNodeImpl.createTextRenderer(text, valuePresenter);
        if (appendSeparator && StringUtil.isNotEmpty((String)(separator = valuePresenter.getSeparator()))) {
            renderer.renderRaw(separator, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if ((type = valuePresenter.getType()) != null) {
            renderer.renderRaw("{" + type + "} ", XDebuggerUIConstants.TYPE_ATTRIBUTES);
        }
        valuePresenter.renderValue((XValuePresentation.XValueTextRenderer)renderer);
    }

    @Override
    public void markChanged() {
        if (this.myChanged) {
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.myChanged = true;
        if (this.myName != null && this.myValuePresentation != null) {
            this.updateText();
            this.fireNodeChanged();
        }
    }

    @NotNull
    public final Promise<XExpression> calculateEvaluationExpression() {
        Promise promise = ((XValue)this.myValueContainer).calculateEvaluationExpression();
        if (promise == null) {
            XValueNodeImpl.$$$reportNull$$$0(13);
        }
        return promise;
    }

    @Nullable
    public XFullValueEvaluator getFullValueEvaluator() {
        return this.myFullValueEvaluator;
    }

    @Override
    @Nullable
    public XDebuggerTreeNodeHyperlink getLink() {
        if (this.myFullValueEvaluator != null && this.myFullValueEvaluator.isEnabled()) {
            return new XDebuggerTreeNodeHyperlink(this.myFullValueEvaluator.getLinkText(), this.myFullValueEvaluator.getLinkAttributes()){

                public boolean alwaysOnScreen() {
                    return true;
                }

                public void onClick(MouseEvent event) {
                    if (XValueNodeImpl.this.myFullValueEvaluator.isShowValuePopup()) {
                        DebuggerUIUtil.showValuePopup(XValueNodeImpl.this.myFullValueEvaluator, event, XValueNodeImpl.this.myTree.getProject(), null);
                    } else {
                        new HeadlessValueEvaluationCallback(XValueNodeImpl.this).startFetchingValue(XValueNodeImpl.this.myFullValueEvaluator);
                    }
                    event.consume();
                }
            };
        }
        return null;
    }

    @Override
    public void appendToComponent(@NotNull ColoredTextContainer component) {
        if (component == null) {
            XValueNodeImpl.$$$reportNull$$$0(14);
        }
        super.appendToComponent(component);
        XDebuggerTreeNodeHyperlink hyperlink = this.myAdditionalHyperLink.get();
        if (hyperlink != null) {
            component.append(hyperlink.getLinkText(), hyperlink.getTextAttributes(), (Object)hyperlink);
        }
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @Nullable
    public XValuePresentation getValuePresentation() {
        return this.myValuePresentation;
    }

    @Override
    @Nullable
    public String getRawValue() {
        return this.myRawValue;
    }

    @Override
    public boolean isComputed() {
        return this.myValuePresentation != null;
    }

    public void setValueModificationStarted() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myRawValue = null;
        this.myText.clear();
        this.appendName();
        XValuePresentationUtil.appendSeparator((ColoredTextContainer)this.myText, this.myValuePresentation.getSeparator());
        this.myText.append(XDebuggerUIConstants.getModifyingValueMessage(), XDebuggerUIConstants.MODIFYING_VALUE_HIGHLIGHT_ATTRIBUTES);
        this.setLeaf(true);
        this.fireNodeStructureChanged();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    @Nullable
    public Object getIconTag() {
        if (!this.getTree().getPinToTopManager().isEnabled()) {
            return null;
        }
        if (!PinToTopUtilKt.canBePinned(this)) {
            return null;
        }
        return new XDebuggerTreeNodeHyperlink(XDebuggerBundle.message((String)"xdebugger.pin.to.top.action", (Object[])new Object[0])){

            public void onClick(MouseEvent event) {
                XDebuggerPinToTopAction.Companion.pinToTopField(event, XValueNodeImpl.this);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuePresentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullValueEvaluator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuePresenter";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getXValue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextRenderer";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateEvaluationExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setPresentation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyPresentation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFullValueEvaluator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalHyperlink";
                break;
            }
            case 7: 
            case 8: 
            case 13: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendToComponent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 13 -> new IllegalStateException(string);
        };
    }
}

