/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.editorconfig.frontend.editor;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigElementTypes;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigPsiFile;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0017\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/editorconfig/frontend/editor/EnterInEditorConfigFileHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate;", "<init>", "()V", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffsetRef", "Lcom/intellij/openapi/util/Ref;", "", "caretAdvance", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "WHITE_SPACE", "Lkotlin/text/Regex;", "isWhitespace", "", "char", "", "(Ljava/lang/Character;)Z", "isCommentStart", "intellij.editorconfig.frontend"})
public final class EnterInEditorConfigFileHandler
implements EnterHandlerDelegate {
    @NotNull
    private final Regex WHITE_SPACE = new Regex("\\s");

    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(caretOffsetRef, (String)"caretOffsetRef");
        Intrinsics.checkNotNullParameter(caretAdvance, (String)"caretAdvance");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!(file instanceof EditorConfigPsiFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Project project = ((PsiElement)file).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        documentManager.commitDocument(document2);
        Integer caretOffset = (Integer)caretOffsetRef.get();
        Intrinsics.checkNotNull((Object)caretOffset);
        PsiElement psiUnderCaret = file.findElementAt(caretOffset.intValue());
        PsiElement psiElement = psiUnderCaret;
        IElementType elementType = psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null;
        Object object = psiUnderCaret;
        Character psiElementStart = object != null && (object = object.getText()) != null ? StringsKt.firstOrNull((CharSequence)((CharSequence)object)) : null;
        String string = document2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        CharSequence charSequence = string;
        int n = caretOffset;
        Character charUnderCaret = StringsKt.getOrNull((CharSequence)charSequence, (int)n);
        if (!Intrinsics.areEqual((Object)elementType, (Object)EditorConfigElementTypes.LINE_COMMENT) || this.isCommentStart(charUnderCaret)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        charSequence = this.isWhitespace(charUnderCaret) ? TuplesKt.to((Object)("\n" + psiElementStart), (Object)3) : TuplesKt.to((Object)("\n" + psiElementStart + " "), (Object)3);
        String text = (String)charSequence.component1();
        int offset = ((Number)charSequence.component2()).intValue();
        document2.insertString(caretOffset.intValue(), (CharSequence)text);
        editor.getCaretModel().moveToOffset(caretOffset + offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
        return EnterHandlerDelegate.Result.Stop;
    }

    private final boolean isWhitespace(Character c) {
        return c != null && this.WHITE_SPACE.matches((CharSequence)String.valueOf(c.charValue()));
    }

    private final boolean isCommentStart(Character c) {
        return c != null && StringsKt.contains$default((CharSequence)"#;", (char)c.charValue(), (boolean)false, (int)2, null);
    }
}

