/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ui.BooleanCommitOption;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.ui.components.labels.LinkLabel;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001Bi\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0005\u0012\u0015\u0010\n\u001a\u00110\t\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0015\u0010\u000e\u001a\u00110\t\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0017\u0010\u0015\u001a\u00070\t\u00a2\u0006\u0002\b\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u00110\t\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u00110\t\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/vcs/checkin/ProfileChooser;", "", "project", "Lcom/intellij/openapi/project/Project;", "property", "Lkotlin/reflect/KMutableProperty0;", "", "isLocalProperty", "profileProperty", "", "emptyTitleKey", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.VcsBundle", "profileTitleKey", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlin/reflect/KMutableProperty0;Lkotlin/reflect/KMutableProperty0;Lkotlin/reflect/KMutableProperty0;Ljava/lang/String;Ljava/lang/String;)V", "build", "Lcom/intellij/openapi/vcs/ui/RefreshableOnComponent;", "checkinHandler", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "getProfileText", "Lorg/jetbrains/annotations/Nls;", "profile", "Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "createProfileChooser", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "linkContext", "Lcom/intellij/openapi/vcs/changes/ui/BooleanCommitOption$LinkContext;", "fillActions", "", "group", "manager", "Lcom/intellij/profile/codeInspection/InspectionProfileManager;", "intellij.platform.vcs.impl.lang"})
@ApiStatus.Internal
public final class ProfileChooser {
    @NotNull
    private final Project project;
    @NotNull
    private final KMutableProperty0<Boolean> property;
    @NotNull
    private final KMutableProperty0<Boolean> isLocalProperty;
    @NotNull
    private final KMutableProperty0<String> profileProperty;
    @NotNull
    private final String emptyTitleKey;
    @NotNull
    private final String profileTitleKey;

    public ProfileChooser(@NotNull Project project, @NotNull KMutableProperty0<Boolean> property, @NotNull KMutableProperty0<Boolean> isLocalProperty, @NotNull KMutableProperty0<String> profileProperty, @NotNull String emptyTitleKey, @NotNull String profileTitleKey) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Intrinsics.checkNotNullParameter(isLocalProperty, (String)"isLocalProperty");
        Intrinsics.checkNotNullParameter(profileProperty, (String)"profileProperty");
        Intrinsics.checkNotNullParameter((Object)emptyTitleKey, (String)"emptyTitleKey");
        Intrinsics.checkNotNullParameter((Object)profileTitleKey, (String)"profileTitleKey");
        this.project = project;
        this.property = property;
        this.isLocalProperty = isLocalProperty;
        this.profileProperty = profileProperty;
        this.emptyTitleKey = emptyTitleKey;
        this.profileTitleKey = profileTitleKey;
    }

    @NotNull
    public final RefreshableOnComponent build(@Nullable CheckinHandler checkinHandler) {
        InspectionProfileImpl profile = null;
        String profileName = (String)this.profileProperty.get();
        if (profileName != null) {
            InspectionProfileManager manager = (Boolean)this.isLocalProperty.get() != false ? InspectionProfileManager.getInstance() : (InspectionProfileManager)InspectionProjectProfileManager.getInstance((Project)this.project);
            profile = manager.getProfile(profileName);
        }
        String initialText = this.getProfileText(profile);
        String string = VcsBundle.message((String)"before.checkin.options.check.smells.choose.profile", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return BooleanCommitOption.Companion.createLink(this.project, checkinHandler, true, initialText, this.property, string, (arg_0, arg_1) -> ProfileChooser.build$lambda$0(this, arg_0, arg_1));
    }

    private final String getProfileText(InspectionProfileImpl profile) {
        String string;
        if (profile == null || Intrinsics.areEqual((Object)profile, (Object)InspectionProjectProfileManager.getInstance((Project)this.project).getCurrentProfile())) {
            String string2 = VcsBundle.message((String)this.emptyTitleKey, (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            Object[] objectArray = new Object[]{profile.getDisplayName()};
            String string3 = VcsBundle.message((String)this.profileTitleKey, (Object[])objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    private final DefaultActionGroup createProfileChooser(BooleanCommitOption.LinkContext linkContext) {
        DefaultActionGroup group = new DefaultActionGroup();
        Object[] objectArray = new Object[]{IdeBundle.message((String)"scheme.project", (Object[])new Object[0])};
        group.add((AnAction)Separator.create((String)IdeBundle.message((String)"separator.scheme.stored.in", (Object[])objectArray)));
        InspectionProjectProfileManager inspectionProjectProfileManager = InspectionProjectProfileManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProjectProfileManager, (String)"getInstance(...)");
        this.fillActions(group, (InspectionProfileManager)inspectionProjectProfileManager, linkContext);
        objectArray = new Object[]{IdeBundle.message((String)"scheme.ide", (Object[])new Object[0])};
        group.add((AnAction)Separator.create((String)IdeBundle.message((String)"separator.scheme.stored.in", (Object[])objectArray)));
        InspectionProfileManager inspectionProfileManager = InspectionProfileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileManager, (String)"getInstance(...)");
        this.fillActions(group, inspectionProfileManager, linkContext);
        return group;
    }

    private final void fillActions(DefaultActionGroup group, InspectionProfileManager manager, BooleanCommitOption.LinkContext linkContext) {
        for (InspectionProfileImpl profile : manager.getProfiles()) {
            group.add(new AnAction(profile, this, manager, linkContext){
                final /* synthetic */ InspectionProfileImpl $profile;
                final /* synthetic */ ProfileChooser this$0;
                final /* synthetic */ InspectionProfileManager $manager;
                final /* synthetic */ BooleanCommitOption.LinkContext $linkContext;
                {
                    this.$profile = $profile;
                    this.this$0 = $receiver;
                    this.$manager = $manager;
                    this.$linkContext = $linkContext;
                    this.getTemplatePresentation().setText($profile.getDisplayName(), false);
                    this.getTemplatePresentation().setIcon(Intrinsics.areEqual((Object)ProfileChooser.access$getProfileProperty$p($receiver).get(), (Object)$profile.getName()) ? AllIcons.Actions.Checked : null);
                }

                public void actionPerformed(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ProfileChooser.access$getProfileProperty$p(this.this$0).set((Object)this.$profile.getName());
                    ProfileChooser.access$isLocalProperty$p(this.this$0).set((Object)(!(this.$manager instanceof InspectionProjectProfileManager) ? 1 : 0));
                    BooleanCommitOption.LinkContext.update$default((BooleanCommitOption.LinkContext)this.$linkContext, (String)ProfileChooser.access$getProfileText(this.this$0, this.$profile), null, (int)2, null);
                }
            });
        }
    }

    private static final void build$lambda$0(ProfileChooser this$0, LinkLabel sourceLink, BooleanCommitOption.LinkContext linkData) {
        Component component = (Component)sourceLink;
        Intrinsics.checkNotNull((Object)linkData);
        JBPopupMenu.showBelow((Component)component, (String)"CodeInspection", (ActionGroup)((ActionGroup)this$0.createProfileChooser(linkData)));
    }

    public static final /* synthetic */ KMutableProperty0 access$getProfileProperty$p(ProfileChooser $this) {
        return $this.profileProperty;
    }

    public static final /* synthetic */ KMutableProperty0 access$isLocalProperty$p(ProfileChooser $this) {
        return $this.isLocalProperty;
    }

    public static final /* synthetic */ String access$getProfileText(ProfileChooser $this, InspectionProfileImpl profile) {
        return $this.getProfileText(profile);
    }
}

