/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.lang.LanguageExtension;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class ProblemFilter {
    private static final LanguageExtension<ProblemFilter> EP = new LanguageExtension("com.intellij.grazie.problemFilter");

    public static Stream<ProblemFilter> allIgnoringFilters(TextProblem problem) {
        Stream filters = EP.allForLanguageOrAny(problem.getText().getCommonParent().getLanguage()).stream();
        return problem.isSpellingProblem() ? filters.filter(f -> f.shouldIgnoreTypo(problem)) : filters.filter(f -> f.shouldIgnore(problem));
    }

    public static Stream<ProblemFilter> allIgnoringFilters(TextContent content) {
        return EP.allForLanguageOrAny(content.getCommonParent().getLanguage()).stream().filter(f -> f.shouldIgnore(content));
    }

    public abstract boolean shouldIgnore(@NotNull TextProblem var1);

    public boolean shouldIgnoreTypo(@NotNull TextProblem problem) {
        if (problem == null) {
            ProblemFilter.$$$reportNull$$$0(0);
        }
        return false;
    }

    public boolean shouldIgnore(@NotNull TextContent content) {
        if (content == null) {
            ProblemFilter.$$$reportNull$$$0(1);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/grazie/text/ProblemFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldIgnoreTypo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldIgnore";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

