/*
 * Decompiled with CFR 0.152.
 */
package fleet.fastutil.longs;

import fleet.fastutil.Arrays;
import fleet.fastutil.longs.LongList;
import fleet.fastutil.longs.LongListExtensionsKt;
import fleet.fastutil.longs.LongOpenHashSet;
import fleet.fastutil.longs.MutableLongList;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0004\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004H\u0086\b\u00f8\u0001\u0000\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a*\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\b\u001a\u001a\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b\u001a\u0012\u0010\u0011\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u001a\u0010\u0012\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0013\u001a\n\u0010\u0014\u001a\u00020\u0005*\u00020\u0002\u001a\u0012\u0010\u0015\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0005\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0017"}, d2={"removeIf", "", "Lfleet/fastutil/longs/MutableLongList;", "predicate", "Lkotlin/Function1;", "", "retainAll", "elements", "Lfleet/fastutil/longs/LongList;", "removeAll", "setElements", "", "index", "", "a", "offset", "length", "addAll", "addElements", "", "pop", "removeValue", "elem", "fleet.fastutil"})
@SourceDebugExtension(value={"SMAP\nMutableLongListExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableLongListExtensions.kt\nfleet/fastutil/longs/MutableLongListExtensionsKt\n*L\n1#1,96:1\n8#1,11:97\n*S KotlinDebug\n*F\n+ 1 MutableLongListExtensions.kt\nfleet/fastutil/longs/MutableLongListExtensionsKt\n*L\n24#1:97,11\n*E\n"})
public final class MutableLongListExtensionsKt {
    public static final boolean removeIf(@NotNull MutableLongList $this$removeIf, @NotNull Function1<? super Long, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$removeIf, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$removeIf = false;
        boolean removed = false;
        int curIndex = LongListExtensionsKt.getIndices($this$removeIf).getFirst();
        while (true) {
            IntRange intRange = LongListExtensionsKt.getIndices($this$removeIf);
            int n = intRange.getFirst();
            boolean bl = curIndex <= intRange.getLast() ? n <= curIndex : false;
            if (!bl) break;
            if (((Boolean)predicate.invoke((Object)$this$removeIf.get(curIndex))).booleanValue()) {
                $this$removeIf.removeAt(curIndex);
                removed = true;
                continue;
            }
            ++curIndex;
        }
        return removed;
    }

    public static final boolean retainAll(@NotNull MutableLongList $this$retainAll, @NotNull LongList elements) {
        Intrinsics.checkNotNullParameter((Object)$this$retainAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        LongOpenHashSet elementsSet = new LongOpenHashSet(elements, 0.0f, 2, null);
        MutableLongList $this$removeIf$iv = $this$retainAll;
        boolean $i$f$removeIf = false;
        boolean removed$iv = false;
        int curIndex$iv = LongListExtensionsKt.getIndices($this$removeIf$iv).getFirst();
        while (true) {
            IntRange intRange = LongListExtensionsKt.getIndices($this$removeIf$iv);
            int n = intRange.getFirst();
            boolean bl = curIndex$iv <= intRange.getLast() ? n <= curIndex$iv : false;
            if (!bl) break;
            long elem = $this$removeIf$iv.get(curIndex$iv);
            boolean bl2 = false;
            if (!elementsSet.contains(elem)) {
                $this$removeIf$iv.removeAt(curIndex$iv);
                removed$iv = true;
                continue;
            }
            ++curIndex$iv;
        }
        return removed$iv;
    }

    public static final boolean removeAll(@NotNull MutableLongList $this$removeAll, @NotNull LongList elements) {
        Intrinsics.checkNotNullParameter((Object)$this$removeAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        boolean modified = false;
        IntRange intRange = LongListExtensionsKt.getIndices(elements);
        int index = intRange.getFirst();
        int n = intRange.getLast();
        if (index <= n) {
            while (true) {
                if (MutableLongListExtensionsKt.removeValue($this$removeAll, elements.get(index))) {
                    modified = true;
                }
                if (index == n) break;
                ++index;
            }
        }
        return modified;
    }

    public static final void setElements(@NotNull MutableLongList $this$setElements, int index, @NotNull LongList a, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$setElements, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > $this$setElements.getSize()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + $this$setElements.getSize() + ")");
        }
        Arrays.INSTANCE.ensureOffsetLength(a, offset, length);
        if (index + length > $this$setElements.getSize()) {
            throw new IndexOutOfBoundsException("End index (" + (index + length) + ") is greater than list size (" + $this$setElements.getSize() + ")");
        }
        int iter = index;
        int i = 0;
        while (i < length) {
            $this$setElements.set(iter, a.get(offset + i++));
            ++iter;
        }
    }

    public static final void setElements(@NotNull MutableLongList $this$setElements, @NotNull LongList a) {
        Intrinsics.checkNotNullParameter((Object)$this$setElements, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        MutableLongListExtensionsKt.setElements($this$setElements, 0, a);
    }

    public static final void setElements(@NotNull MutableLongList $this$setElements, int index, @NotNull LongList a) {
        Intrinsics.checkNotNullParameter((Object)$this$setElements, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        MutableLongListExtensionsKt.setElements($this$setElements, index, a, 0, a.getSize());
    }

    public static final boolean addAll(@NotNull MutableLongList $this$addAll, @NotNull LongList elements) {
        Intrinsics.checkNotNullParameter((Object)$this$addAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        return $this$addAll.addAll($this$addAll.getSize(), elements);
    }

    public static final void addElements(@NotNull MutableLongList $this$addElements, int index, @NotNull long[] a) {
        Intrinsics.checkNotNullParameter((Object)$this$addElements, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        $this$addElements.addElements(index, a, 0, a.length);
    }

    public static final long pop(@NotNull MutableLongList $this$pop) {
        Intrinsics.checkNotNullParameter((Object)$this$pop, (String)"<this>");
        if (LongListExtensionsKt.isEmpty($this$pop)) {
            throw new IndexOutOfBoundsException();
        }
        return $this$pop.removeAt($this$pop.getSize() - 1);
    }

    public static final boolean removeValue(@NotNull MutableLongList $this$removeValue, long elem) {
        Intrinsics.checkNotNullParameter((Object)$this$removeValue, (String)"<this>");
        int index = LongListExtensionsKt.indexOf($this$removeValue, elem);
        if (index == -1) {
            return false;
        }
        $this$removeValue.removeAt(index);
        return true;
    }
}

