/*
 * Decompiled with CFR 0.152.
 */
package training.util;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.TimeoutUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.io.JsonBuilderKt;
import org.jetbrains.io.JsonObjectBuilder;
import training.dsl.TaskTestContext;
import training.learn.CourseManager;
import training.learn.course.KLesson;
import training.learn.course.Lesson;
import training.learn.lesson.LessonListener;
import training.statistic.LessonStartingWay;
import training.util.LearningLessonsAutoExecutorKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ltraining/util/LearningLessonsAutoExecutor;", "", "project", "Lcom/intellij/openapi/project/Project;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "runSingleLesson", "", "lesson", "Ltraining/learn/course/Lesson;", "runAllLessons", "", "", "", "executeLesson", "Companion", "intellij.featuresTrainer"})
public final class LearningLessonsAutoExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ProgressIndicator progress;

    public LearningLessonsAutoExecutor(@NotNull Project project, @NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        this.project = project;
        this.progress = progress;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void runSingleLesson(Lesson lesson) {
        ActionsKt.invokeAndWaitIfNeeded$default(null, () -> LearningLessonsAutoExecutor.runSingleLesson$lambda$0(this, lesson), (int)1, null);
        try {
            this.executeLesson(lesson);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        if (!lesson.getPassed$intellij_featuresTrainer()) {
            LearningLessonsAutoExecutorKt.access$getLOG$p().error("Can't pass lesson " + lesson.getName());
        }
    }

    private final Map<String, Long> runAllLessons() {
        Map durations = new LinkedHashMap();
        TaskTestContext.Companion.setInTestMode(true);
        List<Lesson> lessons = CourseManager.Companion.getInstance().getLessonsForModules();
        for (Lesson lesson : lessons) {
            if (!(lesson instanceof KLesson) || lesson.getTestScriptProperties().getSkipTesting() || durations.containsKey(lesson.getId())) continue;
            this.progress.checkCanceled();
            Thread.sleep(1000L);
            long duration = TimeoutUtil.measureExecutionTime(() -> LearningLessonsAutoExecutor.runAllLessons$lambda$0(this, lesson));
            durations.put(lesson.getId(), duration);
        }
        TaskTestContext.Companion.setInTestMode(false);
        return durations;
    }

    private final void executeLesson(Lesson lesson) {
        AsyncPromise lessonPromise = new AsyncPromise();
        lesson.addLessonListener(new LessonListener((AsyncPromise<Boolean>)lessonPromise){
            final /* synthetic */ AsyncPromise<Boolean> $lessonPromise;
            {
                this.$lessonPromise = $lessonPromise;
            }

            public void lessonPassed(Lesson lesson) {
                Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
                this.$lessonPromise.setResult((Object)true);
            }
        });
        this.progress.checkCanceled();
        Boolean passedStatus = (Boolean)lessonPromise.blockingGet(lesson.getTestScriptProperties().getDuration(), TimeUnit.SECONDS);
        if (passedStatus == null || !passedStatus.booleanValue()) {
            LearningLessonsAutoExecutorKt.access$getLOG$p().error("Can't pass lesson " + lesson.getName());
        } else {
            System.err.println("Passed " + lesson.getName());
        }
    }

    private static final Unit runSingleLesson$lambda$0(LearningLessonsAutoExecutor this$0, Lesson $lesson) {
        CourseManager.openLesson$default(CourseManager.Companion.getInstance(), this$0.project, $lesson, LessonStartingWay.LEARN_TAB, false, false, 24, null);
        return Unit.INSTANCE;
    }

    private static final void runAllLessons$lambda$0(LearningLessonsAutoExecutor this$0, Lesson $lesson) {
        this$0.runSingleLesson($lesson);
    }

    public static final /* synthetic */ Map access$runAllLessons(LearningLessonsAutoExecutor $this) {
        return $this.runAllLessons();
    }

    public static final /* synthetic */ void access$runSingleLesson(LearningLessonsAutoExecutor $this, Lesson lesson) {
        $this.runSingleLesson(lesson);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Ltraining/util/LearningLessonsAutoExecutor$Companion;", "", "<init>", "()V", "runAllLessons", "", "project", "Lcom/intellij/openapi/project/Project;", "runSingleLesson", "lesson", "Ltraining/learn/course/Lesson;", "getJsonStatus", "", "durations", "", "", "intellij.featuresTrainer"})
    @SourceDebugExtension(value={"SMAP\nLearningLessonsAutoExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LearningLessonsAutoExecutor.kt\ntraining/util/LearningLessonsAutoExecutor$Companion\n+ 2 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n+ 3 JsonBuilder.kt\norg/jetbrains/io/JsonBuilderKt\n+ 4 JsonBuilder.kt\norg/jetbrains/io/JsonObjectBuilder\n*L\n1#1,123:1\n42#2,10:124\n42#2,10:134\n8#3,3:144\n11#3,2:161\n13#3:171\n157#4,14:147\n172#4,8:163\n19#4,3:172\n157#4,14:175\n22#4,2:189\n172#4,8:191\n24#4:199\n*S KotlinDebug\n*F\n+ 1 LearningLessonsAutoExecutor.kt\ntraining/util/LearningLessonsAutoExecutor$Companion\n*L\n80#1:124,10\n93#1:134,10\n108#1:144,3\n108#1:161,2\n108#1:171\n108#1:147,14\n108#1:163,8\n112#1:172,3\n112#1:175,14\n112#1:189,2\n112#1:191,8\n112#1:199\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void runAllLessons(@NotNull Project project) {
            void title$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String string = "Running All Lessons";
            Project project$iv = project;
            boolean cancellable$iv = true;
            boolean $i$f$runBackgroundableTask = false;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, (String)title$iv, cancellable$iv, project){
                final /* synthetic */ Project $project$inlined;
                {
                    this.$project$inlined = project;
                    super($project, $title, $cancellable);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    try {
                        LearningLessonsAutoExecutor learningLessonsAutoExecutor = new LearningLessonsAutoExecutor(this.$project$inlined, it);
                        Map durations = LearningLessonsAutoExecutor.access$runAllLessons(learningLessonsAutoExecutor);
                        System.setProperty("ift.gui.result", training.util.LearningLessonsAutoExecutor$Companion.access$getJsonStatus(LearningLessonsAutoExecutor.Companion, durations));
                    }
                    finally {
                        TaskTestContext.Companion.setInTestMode(false);
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        public final void runSingleLesson(@NotNull Project project, @NotNull Lesson lesson) {
            void title$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
            String string = "Running lesson " + lesson.getName();
            Project project$iv = project;
            boolean cancellable$iv = true;
            boolean $i$f$runBackgroundableTask = false;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, (String)title$iv, cancellable$iv, project, lesson){
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ Lesson $lesson$inlined;
                {
                    this.$project$inlined = project;
                    this.$lesson$inlined = lesson;
                    super($project, $title, $cancellable);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    TaskTestContext.Companion.setInTestMode(true);
                    try {
                        LearningLessonsAutoExecutor learningLessonsAutoExecutor = new LearningLessonsAutoExecutor(this.$project$inlined, it);
                        LearningLessonsAutoExecutor.access$runSingleLesson(learningLessonsAutoExecutor, this.$lesson$inlined);
                    }
                    finally {
                        TaskTestContext.Companion.setInTestMode(false);
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final String getJsonStatus(Map<String, Long> durations) {
            void closeChar$iv$iv;
            int n;
            int i$iv$iv;
            void openChar$iv$iv;
            void this_$iv$iv;
            StringBuilder result;
            StringBuilder $this$json$iv = result = new StringBuilder();
            boolean $i$f$json = false;
            JsonObjectBuilder builder$iv = new JsonObjectBuilder($this$json$iv, 0, null, 6, null);
            JsonBuilderKt.appendCommaIfNeeded((StringBuilder)$this$json$iv);
            JsonObjectBuilder jsonObjectBuilder = builder$iv;
            int n2 = 123;
            int n3 = 125;
            boolean isColonRequired$iv$iv = false;
            boolean $i$f$appendComplexValue = false;
            this_$iv$iv.getBuilder().append((char)openChar$iv$iv);
            if (this_$iv$iv.getIndent() != null) {
                this_$iv$iv.getBuilder().append('\n');
                i$iv$iv = 1;
                n = this_$iv$iv.getIndentLevel() + 1;
                if (i$iv$iv <= n) {
                    while (true) {
                        this_$iv$iv.getBuilder().append(this_$iv$iv.getIndent());
                        if (i$iv$iv == n) break;
                        ++i$iv$iv;
                    }
                }
            }
            boolean bl = false;
            JsonObjectBuilder $this$getJsonStatus_u24lambda_u240 = builder$iv;
            boolean bl2 = false;
            $this$getJsonStatus_u24lambda_u240.array((CharSequence)"lessons", arg_0 -> Companion.getJsonStatus$lambda$0$0(result, durations, arg_0));
            if (this_$iv$iv.getIndent() != null) {
                this_$iv$iv.getBuilder().append('\n');
                i$iv$iv = 1;
                n = this_$iv$iv.getIndentLevel();
                if (i$iv$iv <= n) {
                    while (true) {
                        this_$iv$iv.getBuilder().append(this_$iv$iv.getIndent());
                        if (i$iv$iv == n) break;
                        ++i$iv$iv;
                    }
                }
            }
            this_$iv$iv.getBuilder().append((char)closeChar$iv$iv);
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit getJsonStatus$lambda$0$0(StringBuilder $result, Map $durations, JsonObjectBuilder $this$array) {
            Intrinsics.checkNotNullParameter((Object)$this$array, (String)"$this$array");
            for (Lesson lesson : CourseManager.Companion.getInstance().getLessonsForModules()) {
                void closeChar$iv$iv;
                int n;
                int i$iv$iv;
                void openChar$iv$iv;
                void this_$iv$iv;
                void this_$iv;
                if (!(lesson instanceof KLesson) || lesson.getTestScriptProperties().getSkipTesting()) continue;
                JsonObjectBuilder jsonObjectBuilder = $this$array;
                StringBuilder $this$json$iv = $result;
                boolean $i$f$json = false;
                JsonObjectBuilder builder$iv = new JsonObjectBuilder($this$json$iv, this_$iv.getIndentLevel() + 1, null, 4, null);
                JsonBuilderKt.appendCommaIfNeeded((StringBuilder)$this$json$iv);
                JsonObjectBuilder jsonObjectBuilder2 = builder$iv;
                int n2 = 123;
                int n3 = 125;
                boolean isColonRequired$iv$iv = false;
                boolean $i$f$appendComplexValue = false;
                this_$iv$iv.getBuilder().append((char)openChar$iv$iv);
                if (this_$iv$iv.getIndent() != null) {
                    this_$iv$iv.getBuilder().append('\n');
                    i$iv$iv = 1;
                    n = this_$iv$iv.getIndentLevel() + 1;
                    if (i$iv$iv <= n) {
                        while (true) {
                            this_$iv$iv.getBuilder().append(this_$iv$iv.getIndent());
                            if (i$iv$iv == n) break;
                            ++i$iv$iv;
                        }
                    }
                }
                boolean bl = false;
                JsonObjectBuilder $this$getJsonStatus_u24lambda_u240_u240_u240 = builder$iv;
                boolean bl2 = false;
                $this$getJsonStatus_u24lambda_u240_u240_u240.to("id", lesson.getId());
                $this$getJsonStatus_u24lambda_u240_u240_u240.to("passed", lesson.getPassed$intellij_featuresTrainer());
                $this$getJsonStatus_u24lambda_u240_u240_u240.toRaw("duration", String.valueOf($durations.get(lesson.getId())));
                if (this_$iv$iv.getIndent() != null) {
                    this_$iv$iv.getBuilder().append('\n');
                    i$iv$iv = 1;
                    n = this_$iv$iv.getIndentLevel();
                    if (i$iv$iv <= n) {
                        while (true) {
                            this_$iv$iv.getBuilder().append(this_$iv$iv.getIndent());
                            if (i$iv$iv == n) break;
                            ++i$iv$iv;
                        }
                    }
                }
                this_$iv$iv.getBuilder().append((char)closeChar$iv$iv);
            }
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ String access$getJsonStatus(Companion $this, Map durations) {
            return $this.getJsonStatus(durations);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

