/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.util.Key;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0014B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0001H\u0014J\b\u0010\u000e\u001a\u00020\u000bH\u0014J\b\u0010\u000f\u001a\u00020\u000bH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/execution/process/CompositeProcessHandler;", "Lcom/intellij/execution/process/ProcessHandler;", "handlers", "", "<init>", "(Ljava/util/List;)V", "getHandlers", "()Ljava/util/List;", "terminatedCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "startNotify", "", "startNotifyHandler", "handler", "destroyProcessImpl", "detachProcessImpl", "detachIsDefault", "", "getProcessInput", "Ljava/io/OutputStream;", "EachListener", "intellij.platform.util"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCompositeProcessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompositeProcessHandler.kt\ncom/intellij/execution/process/CompositeProcessHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1915#2,2:51\n1915#2,2:53\n1915#2,2:55\n1915#2,2:57\n*S KotlinDebug\n*F\n+ 1 CompositeProcessHandler.kt\ncom/intellij/execution/process/CompositeProcessHandler\n*L\n27#1:51,2\n32#1:53,2\n40#1:55,2\n44#1:57,2\n*E\n"})
public class CompositeProcessHandler
extends ProcessHandler {
    @NotNull
    private final List<ProcessHandler> handlers;
    @NotNull
    private final AtomicInteger terminatedCount;

    public CompositeProcessHandler(@NotNull List<? extends ProcessHandler> handlers) {
        boolean bl;
        Intrinsics.checkNotNullParameter(handlers, "handlers");
        this.handlers = handlers;
        this.terminatedCount = new AtomicInteger();
        boolean bl2 = bl = !((Collection)this.handlers).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Iterable $this$forEach$iv = this.handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProcessHandler it = (ProcessHandler)element$iv;
            boolean bl3 = false;
            it.addProcessListener(new EachListener());
        }
    }

    @NotNull
    public final List<ProcessHandler> getHandlers() {
        return this.handlers;
    }

    @Override
    public void startNotify() {
        super.startNotify();
        Iterable $this$forEach$iv = this.handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProcessHandler it = (ProcessHandler)element$iv;
            boolean bl = false;
            this.startNotifyHandler(it);
        }
    }

    protected void startNotifyHandler(@NotNull ProcessHandler handler) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        handler.startNotify();
    }

    @Override
    protected void destroyProcessImpl() {
        Iterable $this$forEach$iv = this.handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProcessHandler it = (ProcessHandler)element$iv;
            boolean bl = false;
            it.destroyProcess();
        }
    }

    @Override
    protected void detachProcessImpl() {
        Iterable $this$forEach$iv = this.handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProcessHandler it = (ProcessHandler)element$iv;
            boolean bl = false;
            it.detachProcess();
        }
    }

    @Override
    public boolean detachIsDefault() {
        return false;
    }

    @Override
    @Nullable
    public OutputStream getProcessInput() {
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/execution/process/CompositeProcessHandler$EachListener;", "Lcom/intellij/execution/process/ProcessAdapter;", "<init>", "(Lcom/intellij/execution/process/CompositeProcessHandler;)V", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "processTerminated", "intellij.platform.util"})
    private final class EachListener
    extends ProcessAdapter {
        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
            Intrinsics.checkNotNullParameter(event, "event");
            Intrinsics.checkNotNullParameter(outputType, "outputType");
            CompositeProcessHandler.this.notifyTextAvailable(event.getText(), outputType);
        }

        @Override
        public void processTerminated(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter(event, "event");
            int terminated = CompositeProcessHandler.this.terminatedCount.incrementAndGet();
            if (terminated == CompositeProcessHandler.this.getHandlers().size()) {
                CompositeProcessHandler.this.notifyProcessTerminated(0);
            }
        }
    }
}

