/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.containers.IntObjectLRUMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IntSLRUCache<T> {
    private static final boolean ourPrintDebugStatistics = false;
    private final IntObjectLRUMap<T> myProtectedQueue;
    private final IntObjectLRUMap<T> myProbationalQueue;
    private int probationalHits;
    private int protectedHits;
    private int misses;

    public IntSLRUCache(int protectedQueueSize, int probationalQueueSize) {
        this.myProtectedQueue = new IntObjectLRUMap(protectedQueueSize);
        this.myProbationalQueue = new IntObjectLRUMap(probationalQueueSize);
    }

    @NotNull
    public IntObjectLRUMap.MapEntry<T> cacheEntry(int key, T value) {
        IntObjectLRUMap.MapEntry<T> cached = this.myProtectedQueue.getEntry(key);
        if (cached == null) {
            cached = this.myProbationalQueue.getEntry(key);
        }
        if (cached != null) {
            IntObjectLRUMap.MapEntry<T> mapEntry = cached;
            if (mapEntry == null) {
                IntSLRUCache.$$$reportNull$$$0(0);
            }
            return mapEntry;
        }
        IntObjectLRUMap.MapEntry<T> entry = new IntObjectLRUMap.MapEntry<T>(key, value);
        this.myProbationalQueue.putEntry(entry);
        IntObjectLRUMap.MapEntry<T> mapEntry = entry;
        if (mapEntry == null) {
            IntSLRUCache.$$$reportNull$$$0(1);
        }
        return mapEntry;
    }

    @Nullable
    public IntObjectLRUMap.MapEntry<T> getCachedEntry(int id) {
        return this.getCachedEntry(id, true);
    }

    @Nullable
    public IntObjectLRUMap.MapEntry<T> getCachedEntry(int id, boolean allowMutation) {
        IntObjectLRUMap.MapEntry<T> entry = this.myProtectedQueue.getEntry(id);
        if (entry != null) {
            ++this.protectedHits;
            return entry;
        }
        entry = this.myProbationalQueue.getEntry(id);
        if (entry != null) {
            this.printStatistics(++this.probationalHits);
            if (allowMutation) {
                this.myProbationalQueue.removeEntry(entry.key);
                IntObjectLRUMap.MapEntry<T> demoted = this.myProtectedQueue.putEntry(entry);
                if (demoted != null) {
                    this.myProbationalQueue.putEntry(demoted);
                }
            }
            return entry;
        }
        this.printStatistics(++this.misses);
        return null;
    }

    private void printStatistics(int hits) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IntSLRUCache", "cacheEntry"));
    }
}

