/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import java.text.DateFormat;
import java.text.ParseException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.RevisionKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0001\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0014\u0010\u0016\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u0018\u001a\u00020\u0003H\u0096\u0080\u0004J\n\u0010\u0019\u001a\u00020\u0005H\u0096\u0080\u0004J\b\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/idea/svn/api/Revision;", "", "order", "", "keyword", "", "number", "", "date", "Ljava/util/Date;", "<init>", "(ILjava/lang/String;JLjava/util/Date;)V", "getKeyword", "()Ljava/lang/String;", "getNumber", "()J", "getDate", "()Ljava/util/Date;", "isValid", "", "()Z", "isLocal", "equals", "other", "hashCode", "toString", "throwIllegalState", "", "Companion", "intellij.vcs.svn"})
@SourceDebugExtension(value={"SMAP\nRevision.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Revision.kt\norg/jetbrains/idea/svn/api/Revision\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class Revision {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int order;
    @Nullable
    private final String keyword;
    private final long number;
    @Nullable
    private final Date date;
    @NotNull
    private static final Map<String, Revision> ourKeywordRevisions = new HashMap();
    @JvmField
    @NotNull
    public static final Revision BASE = new Revision(2, "BASE", 0L, null, 12, null);
    @JvmField
    @NotNull
    public static final Revision COMMITTED = new Revision(3, "COMMITTED", 0L, null, 12, null);
    @JvmField
    @NotNull
    public static final Revision HEAD = new Revision(0, "HEAD", 0L, null, 12, null);
    @JvmField
    @NotNull
    public static final Revision PREV = new Revision(4, "PREV", 0L, null, 12, null);
    @JvmField
    @NotNull
    public static final Revision WORKING = new Revision(1, "WORKING", 0L, null, 12, null);
    @JvmField
    @NotNull
    public static final Revision UNDEFINED = new Revision(30, "UNDEFINED", 0L, null, 12, null);
    @JvmField
    @NotNull
    public static final Comparator<Revision> GENERAL_ORDER = new Comparator(){

        public final int compare(T a, T b) {
            Revision it = (Revision)b;
            boolean bl = false;
            Comparable comparable = Integer.valueOf(Revision.access$getOrder$p(it));
            it = (Revision)a;
            Comparable comparable2 = comparable;
            bl = false;
            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(Revision.access$getOrder$p(it)));
        }
    };

    private Revision(int order, String keyword, long number, Date date) {
        block1: {
            this.order = order;
            this.keyword = keyword;
            this.number = number;
            this.date = date;
            if (this.keyword == null && this.number < 0L && this.date == null) {
                this.throwIllegalState();
                throw new KotlinNothingValueException();
            }
            String string = this.keyword;
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            ourKeywordRevisions.put(this.keyword, this);
        }
    }

    /* synthetic */ Revision(int n, String string, long l, Date date, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            l = -1L;
        }
        if ((n2 & 8) != 0) {
            date = null;
        }
        this(n, string, l, date);
    }

    @Nullable
    public final String getKeyword() {
        return this.keyword;
    }

    public final long getNumber() {
        return this.number;
    }

    @Nullable
    public final Date getDate() {
        return this.date;
    }

    public final boolean isValid() {
        return this != UNDEFINED;
    }

    public final boolean isLocal() {
        return this == BASE || this == WORKING;
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (this == other) {
            return true;
        }
        if (!(other instanceof Revision)) {
            return false;
        }
        if (this.keyword != null) {
            bl = Intrinsics.areEqual((Object)this.keyword, (Object)((Revision)other).keyword);
        } else if (this.number >= 0L) {
            bl = this.number == ((Revision)other).number;
        } else if (this.date != null) {
            bl = Intrinsics.areEqual((Object)this.date, (Object)((Revision)other).date);
        } else {
            this.throwIllegalState();
            throw new KotlinNothingValueException();
        }
        return bl;
    }

    public int hashCode() {
        int n;
        if (this.keyword != null) {
            n = this.keyword.hashCode();
        } else if (this.number >= 0L) {
            n = Long.hashCode(this.number);
        } else if (this.date != null) {
            n = this.date.hashCode();
        } else {
            this.throwIllegalState();
            throw new KotlinNothingValueException();
        }
        return n;
    }

    @NotNull
    public String toString() {
        String string;
        if (this.keyword != null) {
            string = this.keyword;
        } else if (this.number >= 0L) {
            string = String.valueOf(this.number);
        } else if (this.date != null) {
            String string2 = DateFormat.getDateTimeInstance().format(this.date);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        } else {
            this.throwIllegalState();
            throw new KotlinNothingValueException();
        }
        return string;
    }

    private final Void throwIllegalState() {
        throw new IllegalStateException("no keyword, number or date in revision");
    }

    @JvmStatic
    @NotNull
    public static final Revision of(long number) {
        return Companion.of(number);
    }

    @JvmStatic
    @NotNull
    public static final Revision of(@NotNull Date date) {
        return Companion.of(date);
    }

    @JvmStatic
    @NotNull
    public static final Revision parse(@Nullable String value) {
        return Companion.parse(value);
    }

    public static final /* synthetic */ int access$getOrder$p(Revision $this) {
        return $this.order;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0012\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0017\u0010\u001a\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/idea/svn/api/Revision$Companion;", "", "<init>", "()V", "ourKeywordRevisions", "", "", "Lorg/jetbrains/idea/svn/api/Revision;", "BASE", "COMMITTED", "HEAD", "PREV", "WORKING", "UNDEFINED", "GENERAL_ORDER", "Ljava/util/Comparator;", "of", "number", "", "date", "Ljava/util/Date;", "parse", "value", "fromKeyword", "fromNumber", "fromDate", "parseDate", "Lorg/jetbrains/annotations/Nullable;", "parseIso8601", "intellij.vcs.svn"})
    @SourceDebugExtension(value={"SMAP\nRevision.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Revision.kt\norg/jetbrains/idea/svn/api/Revision$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Revision of(long number) {
            return number < 0L ? UNDEFINED : new Revision(10, null, number, null, 10, null);
        }

        @JvmStatic
        @NotNull
        public final Revision of(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            return new Revision(20, null, 0L, date, 6, null);
        }

        @JvmStatic
        @NotNull
        public final Revision parse(@Nullable String value) {
            Revision revision;
            Revision revision2;
            if (value == null) {
                return UNDEFINED;
            }
            Revision revision3 = this.fromKeyword(value);
            if (revision3 == null && (revision3 = this.fromNumber(value)) == null) {
                revision3 = this.fromDate(value);
            }
            if ((revision2 = revision3) == null) {
                RevisionKt.access$getLOG$p().info("Could not parse revision " + value);
            }
            if ((revision = revision2) == null) {
                revision = UNDEFINED;
            }
            return revision;
        }

        private final Revision fromKeyword(String value) {
            return (Revision)ourKeywordRevisions.get(value);
        }

        private final Revision fromNumber(String value) {
            Revision revision;
            Long l = StringsKt.toLongOrNull((String)value);
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                revision = Companion.of(it);
            } else {
                revision = null;
            }
            return revision;
        }

        private final Revision fromDate(String value) {
            Revision revision;
            Date date = this.parseDate(StringsKt.removeSurrounding((String)value, (CharSequence)"{", (CharSequence)"}"));
            if (date != null) {
                Date it = date;
                boolean bl = false;
                revision = Companion.of(it);
            } else {
                revision = null;
            }
            return revision;
        }

        private final Date parseDate(String value) {
            Date date = SvnUtil.parseDate(value, false);
            if (date == null) {
                date = this.parseIso8601(value);
            }
            return date;
        }

        private final Date parseIso8601(String value) {
            try {
                return Date.from(Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(value)));
            }
            catch (ParseException e) {
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

