/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.BadgeShapeProvider;
import java.awt.geom.RoundRectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001BC\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ui/BadgeRectProvider;", "Lcom/intellij/ui/BadgeShapeProvider;", "arc", "", "top", "left", "right", "bottom", "border", "<init>", "(DDDDDD)V", "getArc", "()D", "getTop", "getLeft", "getRight", "getBottom", "createShape", "Ljava/awt/geom/RoundRectangle2D;", "width", "", "height", "hole", "", "intellij.platform.core.ui"})
@ApiStatus.Internal
@ApiStatus.Experimental
public final class BadgeRectProvider
extends BadgeShapeProvider {
    private final double arc;
    private final double top;
    private final double left;
    private final double right;
    private final double bottom;

    public BadgeRectProvider(double arc, double top, double left, double right, double bottom, double border) {
        super(border, null);
        this.arc = arc;
        this.top = top;
        this.left = left;
        this.right = right;
        this.bottom = bottom;
    }

    public /* synthetic */ BadgeRectProvider(double d, double d2, double d3, double d4, double d5, double d6, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        if ((n & 4) != 0) {
            d3 = 0.4;
        }
        if ((n & 8) != 0) {
            d4 = 0.0;
        }
        if ((n & 0x10) != 0) {
            d5 = 0.7;
        }
        if ((n & 0x20) != 0) {
            d6 = BadgeShapeProvider.Companion.getDouble("IconBadge.borderWidth", 1.5) / (double)20;
        }
        this(d, d2, d3, d4, d5, d6);
    }

    public final double getArc() {
        return this.arc;
    }

    public final double getTop() {
        return this.top;
    }

    public final double getLeft() {
        return this.left;
    }

    public final double getRight() {
        return this.right;
    }

    public final double getBottom() {
        return this.bottom;
    }

    @Override
    @Nullable
    public RoundRectangle2D createShape(int width, int height, boolean hole) {
        int size = RangesKt.coerceAtMost((int)width, (int)height);
        if (size <= 0) {
            return null;
        }
        double top = (double)height * this.top;
        double right = (double)width * this.right;
        double left = (double)width * this.left;
        if (right <= left) {
            return null;
        }
        double bottom = (double)height * this.bottom;
        if (bottom <= top) {
            return null;
        }
        double border = hole ? (double)size * this.getBorder() : 0.0;
        double x = left - border;
        double y = top - border;
        double w = right + border - x;
        double h = bottom + border - y;
        double arc = RangesKt.coerceAtMost((double)w, (double)h) * RangesKt.coerceIn((double)this.arc, (double)0.0, (double)1.0);
        return new RoundRectangle2D.Double(x, y, w, h, arc, arc);
    }

    public BadgeRectProvider() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 63, null);
    }
}

