/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.rangeSet;

import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeType;
import org.jetbrains.annotations.NotNull;

public enum LongRangeBinOp {
    PLUS("+"),
    MINUS("-"),
    AND("&"),
    OR("|"),
    XOR("^"),
    MUL("*"),
    MOD("%"),
    DIV("/"),
    SHL("<<"),
    SHR(">>"),
    USHR(">>>");

    private final String mySymbol;

    private LongRangeBinOp(String symbol) {
        this.mySymbol = symbol;
    }

    @NotNull
    public LongRangeSet eval(@NotNull LongRangeSet left, @NotNull LongRangeSet right, LongRangeType lrType) {
        if (left == null) {
            LongRangeBinOp.$$$reportNull$$$0(0);
        }
        if (right == null) {
            LongRangeBinOp.$$$reportNull$$$0(1);
        }
        LongRangeSet longRangeSet = switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> left.plus(right, lrType);
            case 1 -> left.minus(right, lrType);
            case 2 -> left.bitwiseAnd(right);
            case 3 -> left.bitwiseOr(right, lrType);
            case 4 -> left.bitwiseXor(right, lrType);
            case 5 -> left.mul(right, lrType);
            case 6 -> left.mod(right);
            case 7 -> left.div(right, lrType);
            case 8 -> left.shiftLeft(right, lrType);
            case 9 -> left.shiftRight(right, lrType);
            case 10 -> left.unsignedShiftRight(right, lrType);
        };
        if (longRangeSet == null) {
            LongRangeBinOp.$$$reportNull$$$0(2);
        }
        return longRangeSet;
    }

    @NotNull
    public LongRangeSet evalWide(@NotNull LongRangeSet left, @NotNull LongRangeSet right, LongRangeType lrType) {
        if (left == null) {
            LongRangeBinOp.$$$reportNull$$$0(3);
        }
        if (right == null) {
            LongRangeBinOp.$$$reportNull$$$0(4);
        }
        LongRangeSet longRangeSet = switch (this.ordinal()) {
            case 0 -> left.plusWiden(right, lrType);
            case 1 -> {
                if (Long.valueOf(0L).equals(left.getConstantValue())) {
                    yield left.minus(right, lrType);
                }
                yield left.plusWiden(right.negate(lrType), lrType);
            }
            case 5 -> left.mulWiden(right, lrType);
            default -> this.eval(left, right, lrType);
        };
        if (longRangeSet == null) {
            LongRangeBinOp.$$$reportNull$$$0(5);
        }
        return longRangeSet;
    }

    public String toString() {
        return this.mySymbol;
    }

    public boolean isShift() {
        return this == SHL || this == SHR || this == USHR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeBinOp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeBinOp";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "eval";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "evalWide";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "eval";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "evalWide";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

