/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public interface Printer {
    public void print(@NotNull String var1, @NotNull ConsoleViewContentType var2);

    public void onNewAvailable(@NotNull Printable var1);

    public void printHyperlink(@NotNull String var1, HyperlinkInfo var2);

    public void mark();

    default public void printWithAnsiColoring(@NotNull String text2, @NotNull Key processOutputType) {
        if (text2 == null) {
            Printer.$$$reportNull$$$0(0);
        }
        if (processOutputType == null) {
            Printer.$$$reportNull$$$0(1);
        }
        if (processOutputType != ProcessOutputTypes.STDERR && processOutputType != ProcessOutputTypes.STDOUT && processOutputType != ProcessOutputTypes.SYSTEM) {
            this.print(text2, ConsoleViewContentType.getConsoleViewType((Key)processOutputType));
            return;
        }
        new AnsiEscapeDecoder().escapeText(text2, processOutputType, (text1, attributes) -> this.print(text1, ConsoleViewContentType.getConsoleViewType((Key)attributes)));
    }

    default public void printExpectedActualHeader(@NotNull String expected, @NotNull String actual) {
        if (expected == null) {
            Printer.$$$reportNull$$$0(2);
        }
        if (actual == null) {
            Printer.$$$reportNull$$$0(3);
        }
        Printer.printExpectedActualHeader(this, expected, actual);
    }

    public static void printExpectedActualHeader(@NotNull Printer printer, @NotNull String expected, @NotNull String actual) {
        if (printer == null) {
            Printer.$$$reportNull$$$0(4);
        }
        if (expected == null) {
            Printer.$$$reportNull$$$0(5);
        }
        if (actual == null) {
            Printer.$$$reportNull$$$0(6);
        }
        printer.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
        printer.print(ExecutionBundle.message("diff.content.expected.for.file.title", new Object[0]), ConsoleViewContentType.SYSTEM_OUTPUT);
        printer.print(expected + "\n", ConsoleViewContentType.ERROR_OUTPUT);
        printer.print(ExecutionBundle.message("junit.actual.text.label", new Object[0]), ConsoleViewContentType.SYSTEM_OUTPUT);
        printer.print(actual, ConsoleViewContentType.ERROR_OUTPUT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOutputType";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/Printer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "printWithAnsiColoring";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "printExpectedActualHeader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

