/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.logical.impl;

import com.intellij.ide.structureView.StructureViewClickEvent;
import com.intellij.ide.structureView.StructureViewEventsCollector;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.logical.impl.ElementsBuilder;
import com.intellij.ide.structureView.logical.impl.LogicalStructureViewTreeElement;
import com.intellij.ide.structureView.logical.model.LogicalModelPresentationProvider;
import com.intellij.ide.structureView.logical.model.LogicalPsiDescription;
import com.intellij.ide.structureView.logical.model.LogicalStructureAssembledModel;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B/\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eB'\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\u0004\b\r\u0010\u000fJ\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u001fH\u0014J\u0012\u0010 \u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0015\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lcom/intellij/ide/structureView/logical/impl/LogicalStructureViewModel;", "Lcom/intellij/ide/structureView/StructureViewModelBase;", "Lcom/intellij/ide/structureView/StructureViewModel$ElementInfoProvider;", "Lcom/intellij/ide/structureView/StructureViewModel$ExpandInfoProvider;", "Lcom/intellij/ide/structureView/StructureViewModel$ClickHandler;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "assembledModel", "Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;", "elementBuilder", "Lcom/intellij/ide/structureView/logical/impl/ElementsBuilder;", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;Lcom/intellij/ide/structureView/logical/impl/ElementsBuilder;)V", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;)V", "getAssembledModel", "()Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;", "isAlwaysShowsPlus", "", "element", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "isAlwaysLeaf", "isAutoExpand", "isSmartExpand", "handleClick", "Ljava/util/concurrent/CompletableFuture;", "event", "Lcom/intellij/ide/structureView/StructureViewClickEvent;", "findAcceptableElement", "", "Lcom/intellij/psi/PsiElement;", "getModel", "intellij.platform.structureView.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLogicalStructureViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogicalStructureViewModel.kt\ncom/intellij/ide/structureView/logical/impl/LogicalStructureViewModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,391:1\n1#2:392\n*E\n"})
public final class LogicalStructureViewModel
extends StructureViewModelBase
implements StructureViewModel.ElementInfoProvider,
StructureViewModel.ExpandInfoProvider,
StructureViewModel.ClickHandler {
    @NotNull
    private final LogicalStructureAssembledModel<?> assembledModel;

    private LogicalStructureViewModel(PsiFile psiFile, Editor editor, LogicalStructureAssembledModel<?> assembledModel, ElementsBuilder elementBuilder) {
        super(psiFile, editor, elementBuilder.createViewTreeElement(assembledModel));
        this.assembledModel = assembledModel;
    }

    @NotNull
    public final LogicalStructureAssembledModel<?> getAssembledModel() {
        return this.assembledModel;
    }

    public LogicalStructureViewModel(@NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull LogicalStructureAssembledModel<?> assembledModel) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter(assembledModel, (String)"assembledModel");
        this(psiFile, editor, assembledModel, new ElementsBuilder());
    }

    @Override
    public boolean isAlwaysShowsPlus(@Nullable StructureViewTreeElement element) {
        return element instanceof ElementsBuilder.LogicalGroupStructureElement;
    }

    @Override
    public boolean isAlwaysLeaf(@Nullable StructureViewTreeElement element) {
        return element instanceof ElementsBuilder.PropertyStructureElement || element instanceof ElementsBuilder.EmptyChildrenElement;
    }

    @Override
    public boolean isAutoExpand(@NotNull StructureViewTreeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object = this.getModel(element);
        if (object == null) {
            return false;
        }
        Object model2 = object;
        LogicalModelPresentationProvider<Object> logicalModelPresentationProvider = LogicalModelPresentationProvider.Companion.getForObject(model2);
        return logicalModelPresentationProvider != null ? logicalModelPresentationProvider.isAutoExpand(model2) : false;
    }

    @Override
    public boolean isSmartExpand() {
        return false;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> handleClick(@NotNull StructureViewClickEvent event) {
        LogicalModelPresentationProvider<Object> presentation;
        Object model2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = model2 = this.getModel(event.getElement());
        if (object != null) {
            Object it = object;
            boolean bl = false;
            v1 = LogicalModelPresentationProvider.Companion.getForObject(it);
        } else {
            v1 = presentation = null;
        }
        if (model2 == null || presentation == null) {
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        Object object2 = WriteIntentReadAction.compute(() -> LogicalStructureViewModel.handleClick$lambda$1(presentation, model2, event));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"compute(...)");
        return (CompletableFuture)object2;
    }

    @Override
    @Nullable
    protected Object findAcceptableElement(@Nullable PsiElement element) {
        PsiElement psiElement = element;
        if (psiElement == null) {
            return null;
        }
        PsiElement elementTmp = psiElement;
        Set<LogicalPsiDescription> psiDescriptions = this.assembledModel.getLogicalPsiDescriptions();
        while (!(elementTmp instanceof PsiFile)) {
            for (LogicalPsiDescription description : psiDescriptions) {
                PsiElement suitableElement = description.getSuitableElement(elementTmp);
                if (suitableElement == null) continue;
                return suitableElement;
            }
            if (elementTmp.getParent() != null) continue;
            return null;
        }
        return null;
    }

    private final Object getModel(StructureViewTreeElement element) {
        StructureViewTreeElement structureViewTreeElement = element;
        return structureViewTreeElement instanceof ElementsBuilder.LogicalGroupStructureElement ? ((ElementsBuilder.LogicalGroupStructureElement)element).getGrouper() : (structureViewTreeElement instanceof LogicalStructureViewTreeElement ? ((LogicalStructureViewTreeElement)element).getLogicalAssembledModel().getModel() : null);
    }

    private static final Boolean handleClick$lambda$1$0(Object $model, Boolean handled) {
        if (handled.booleanValue()) {
            StructureViewEventsCollector.INSTANCE.logCustomClickHandled($model.getClass());
        }
        return handled;
    }

    private static final Boolean handleClick$lambda$1$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CompletableFuture handleClick$lambda$1(LogicalModelPresentationProvider $presentation, Object $model, StructureViewClickEvent $event) {
        return $presentation.handleClick($model, $event.getFragmentIndex()).thenApply(arg_0 -> LogicalStructureViewModel.handleClick$lambda$1$1(arg_0 -> LogicalStructureViewModel.handleClick$lambda$1$0($model, arg_0), arg_0));
    }
}

