/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/actionSystem/MergeableActions;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "originalGroup", "<init>", "(Lcom/intellij/openapi/actionSystem/ActionGroup;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.platform.editor.ui"})
@ApiStatus.Internal
public final class MergeableActions
extends ActionGroup {
    @NotNull
    private final ActionGroup originalGroup;

    public MergeableActions(@NotNull ActionGroup originalGroup) {
        Intrinsics.checkNotNullParameter((Object)originalGroup, (String)"originalGroup");
        this.originalGroup = originalGroup;
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        AnAction[] anActionArray = this.originalGroup.getChildren(e);
        Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildren(...)");
        AnAction[] children = anActionArray;
        int visibleChildrenCount = 0;
        for (AnAction anAction : children) {
            Intrinsics.checkNotNull((Object)anAction);
            AnAction child = anAction;
            child.update(e);
            if (e.getPresentation().isVisible() && ++visibleChildrenCount > 1) break;
        }
        e.getPresentation().setPopupGroup(visibleChildrenCount > 1);
        e.getPresentation().setEnabledAndVisible(visibleChildrenCount > 0);
        e.getPresentation().setIcon(AllIcons.Actions.More);
    }

    @Override
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = this.originalGroup.getChildren(e);
        Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildren(...)");
        return anActionArray;
    }
}

