/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.google.common.net.HostAndPort;
import com.intellij.execution.process.PtyBasedProcess;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.RemoteProcess;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0003,-.B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0016J\b\u0010\u001b\u001a\u00020\u000eH\u0016J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u000eH\u0016J\b\u0010\"\u001a\u00020\u000eH\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020 0$H\u0016J\b\u0010%\u001a\u00020\u0001H\u0002J\n\u0010&\u001a\u0004\u0018\u00010\u0001H\u0002J)\u0010'\u001a\u0004\u0018\u0001H(\"\u0004\b\u0000\u0010(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H(0*H\u0002\u00a2\u0006\u0002\u0010+R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/remote/DeferredRemoteProcess;", "Lcom/intellij/remote/RemoteProcess;", "Lcom/intellij/execution/process/PtyBasedProcess;", "promise", "Lorg/jetbrains/concurrency/Promise;", "<init>", "(Lorg/jetbrains/concurrency/Promise;)V", "getOutputStream", "Ljava/io/OutputStream;", "getInputStream", "Ljava/io/InputStream;", "getErrorStream", "waitFor", "", "", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "exitValue", "destroy", "", "killProcessTree", "isDisconnected", "getLocalTunnel", "Lcom/google/common/net/HostAndPort;", "remotePort", "hasPty", "setWindowSize", "columns", "rows", "destroyForcibly", "Ljava/lang/Process;", "supportsNormalTermination", "isAlive", "onExit", "Ljava/util/concurrent/CompletableFuture;", "get", "tryGet", "runNowOrSchedule", "T", "handler", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "DeferredOutputStream", "DeferredInputStream", "Companion", "intellij.platform.ide.remote"})
@SourceDebugExtension(value={"SMAP\nDeferredRemoteProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeferredRemoteProcess.kt\ncom/intellij/remote/DeferredRemoteProcess\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,181:1\n45#2,3:182\n1#3:185\n13#4:186\n*S KotlinDebug\n*F\n+ 1 DeferredRemoteProcess.kt\ncom/intellij/remote/DeferredRemoteProcess\n*L\n35#1:182,3\n179#1:186\n*E\n"})
public final class DeferredRemoteProcess
extends RemoteProcess
implements PtyBasedProcess {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Promise<RemoteProcess> promise;
    @NotNull
    private static final Logger LOG;

    public DeferredRemoteProcess(@NotNull Promise<RemoteProcess> promise) {
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        this.promise = promise;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() {
        return new DeferredOutputStream();
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        return new DeferredInputStream((Function1<? super RemoteProcess, ? extends InputStream>)((Function1)DeferredRemoteProcess::getInputStream$lambda$0));
    }

    @Override
    @NotNull
    public InputStream getErrorStream() {
        return new DeferredInputStream((Function1<? super RemoteProcess, ? extends InputStream>)((Function1)DeferredRemoteProcess::getErrorStream$lambda$0));
    }

    @Override
    public int waitFor() {
        return this.get().waitFor();
    }

    @Override
    public boolean waitFor(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Object process = null;
        boolean $i$f$measureNanoTime = false;
        long start$iv = System.nanoTime();
        boolean bl = false;
        process = this.promise.blockingGet((int)timeout, unit);
        long nanosSpent = System.nanoTime() - start$iv;
        long restTimeoutNanos = Math.max(0L, TimeUnit.NANOSECONDS.convert(timeout, unit) - nanosSpent);
        RemoteProcess remoteProcess = (RemoteProcess)process;
        return remoteProcess != null ? remoteProcess.waitFor(restTimeoutNanos, TimeUnit.NANOSECONDS) : false;
    }

    @Override
    public int exitValue() {
        RemoteProcess remoteProcess = this.tryGet();
        if (remoteProcess == null) {
            throw new IllegalStateException("Process is not terminated");
        }
        return remoteProcess.exitValue();
    }

    @Override
    public void destroy() {
        this.runNowOrSchedule(DeferredRemoteProcess::destroy$lambda$0);
    }

    @Override
    public boolean killProcessTree() {
        Boolean bl = (Boolean)this.runNowOrSchedule(DeferredRemoteProcess::killProcessTree$lambda$0);
        return bl != null ? bl : false;
    }

    @Override
    public boolean isDisconnected() {
        RemoteProcess remoteProcess = this.tryGet();
        return remoteProcess != null ? remoteProcess.isDisconnected() : false;
    }

    @Override
    @Nullable
    public HostAndPort getLocalTunnel(int remotePort) {
        return this.get().getLocalTunnel(remotePort);
    }

    public boolean hasPty() {
        RemoteProcess it = this.get();
        boolean bl = false;
        return it instanceof PtyBasedProcess && ((PtyBasedProcess)it).hasPty();
    }

    public void setWindowSize(int columns, int rows) {
        this.runNowOrSchedule(arg_0 -> DeferredRemoteProcess.setWindowSize$lambda$0(columns, rows, arg_0));
    }

    @Override
    @NotNull
    public Process destroyForcibly() {
        Process process = (Process)this.runNowOrSchedule(DeferredRemoteProcess::destroyForcibly$lambda$0);
        if (process == null) {
            process = this;
        }
        return process;
    }

    @Override
    public boolean supportsNormalTermination() {
        return true;
    }

    @Override
    public boolean isAlive() {
        RemoteProcess remoteProcess = this.tryGet();
        return remoteProcess != null ? remoteProcess.isAlive() : true;
    }

    @Override
    @NotNull
    public CompletableFuture<Process> onExit() {
        CompletableFuture<Process> completableFuture;
        CompletableFuture<Process> it = completableFuture = new CompletableFuture<Process>();
        boolean bl = false;
        this.promise.then(arg_0 -> DeferredRemoteProcess.onExit$lambda$0$0((Function1)new Function1<Process, Boolean>(it){

            public final Boolean invoke(Process p0) {
                return ((CompletableFuture)this.receiver).complete(p0);
            }
        }, arg_0));
        return completableFuture;
    }

    private final RemoteProcess get() {
        Object object = this.promise.blockingGet(Integer.MAX_VALUE);
        Intrinsics.checkNotNull((Object)object);
        return (RemoteProcess)object;
    }

    private final RemoteProcess tryGet() {
        Promise<RemoteProcess> promise;
        Promise<RemoteProcess> it = promise = this.promise;
        boolean bl = false;
        Object object = !Promises.isPending(it) ? promise : null;
        return object != null ? (RemoteProcess)object.blockingGet(0) : null;
    }

    private final <T> T runNowOrSchedule(Function1<? super RemoteProcess, ? extends T> handler) {
        Object object;
        RemoteProcess process = this.tryGet();
        if (process != null) {
            object = handler.invoke((Object)process);
        } else {
            Throwable cause = new Throwable("Initially called from this context.");
            this.promise.then(arg_0 -> DeferredRemoteProcess.runNowOrSchedule$lambda$1(arg_0 -> DeferredRemoteProcess.runNowOrSchedule$lambda$0(handler, cause, this, arg_0), arg_0));
            object = null;
        }
        return (T)object;
    }

    private static final InputStream getInputStream$lambda$0(RemoteProcess it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        InputStream inputStream = it.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        return inputStream;
    }

    private static final InputStream getErrorStream$lambda$0(RemoteProcess it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        InputStream inputStream = it.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
        return inputStream;
    }

    private static final Unit destroy$lambda$0(RemoteProcess it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.destroy();
        return Unit.INSTANCE;
    }

    private static final boolean killProcessTree$lambda$0(RemoteProcess it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.killProcessTree();
    }

    private static final Unit setWindowSize$lambda$0(int $columns, int $rows, RemoteProcess it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof PtyBasedProcess) {
            ((PtyBasedProcess)it).setWindowSize($columns, $rows);
        }
        return Unit.INSTANCE;
    }

    private static final Process destroyForcibly$lambda$0(RemoteProcess it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.destroyForcibly();
    }

    private static final Boolean onExit$lambda$0$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Object runNowOrSchedule$lambda$0(Function1 $handler, Throwable $cause, DeferredRemoteProcess this$0, RemoteProcess it) {
        Object object;
        try {
            RemoteProcess remoteProcess = it;
            object = remoteProcess != null ? $handler.invoke((Object)remoteProcess) : null;
        }
        catch (Throwable err) {
            ExceptionsKt.addSuppressed((Throwable)err, (Throwable)$cause);
            LOG.info(this$0 + ": Got an error that nothing could catch: " + err.getMessage(), err);
            object = Unit.INSTANCE;
        }
        return object;
    }

    private static final Object runNowOrSchedule$lambda$1(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DeferredRemoteProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/remote/DeferredRemoteProcess$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.remote"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nH\u0016J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/remote/DeferredRemoteProcess$DeferredInputStream;", "Ljava/io/InputStream;", "streamGetter", "Lkotlin/Function1;", "Lcom/intellij/remote/RemoteProcess;", "<init>", "(Lcom/intellij/remote/DeferredRemoteProcess;Lkotlin/jvm/functions/Function1;)V", "close", "", "read", "", "b", "", "off", "len", "readAllBytes", "readNBytes", "skip", "", "n", "available", "markSupported", "", "intellij.platform.ide.remote"})
    private final class DeferredInputStream
    extends InputStream {
        @NotNull
        private final Function1<RemoteProcess, InputStream> streamGetter;

        public DeferredInputStream(Function1<? super RemoteProcess, ? extends InputStream> streamGetter) {
            Intrinsics.checkNotNullParameter(streamGetter, (String)"streamGetter");
            this.streamGetter = streamGetter;
        }

        @Override
        public void close() {
            DeferredRemoteProcess.this.runNowOrSchedule(arg_0 -> DeferredInputStream.close$lambda$0(this, arg_0));
        }

        @Override
        public int read() {
            return ((InputStream)this.streamGetter.invoke((Object)DeferredRemoteProcess.this.get())).read();
        }

        @Override
        public int read(@NotNull byte[] b) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return ((InputStream)this.streamGetter.invoke((Object)DeferredRemoteProcess.this.get())).read(b);
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return ((InputStream)this.streamGetter.invoke((Object)DeferredRemoteProcess.this.get())).read(b, off, len);
        }

        @Override
        @NotNull
        public byte[] readAllBytes() {
            byte[] byArray = ((InputStream)this.streamGetter.invoke((Object)DeferredRemoteProcess.this.get())).readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            return byArray;
        }

        @Override
        @NotNull
        public byte[] readNBytes(int len) {
            byte[] byArray = ((InputStream)this.streamGetter.invoke((Object)DeferredRemoteProcess.this.get())).readNBytes(len);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
            return byArray;
        }

        @Override
        public int readNBytes(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return ((InputStream)this.streamGetter.invoke((Object)DeferredRemoteProcess.this.get())).readNBytes(b, off, len);
        }

        @Override
        public long skip(long n) {
            return ((InputStream)this.streamGetter.invoke((Object)DeferredRemoteProcess.this.get())).skip(n);
        }

        @Override
        public int available() {
            RemoteProcess remoteProcess;
            Object object = DeferredRemoteProcess.this.tryGet();
            return object != null && (object = (InputStream)this.streamGetter.invoke((Object)(remoteProcess = object))) != null ? ((InputStream)object).available() : 0;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        private static final Unit close$lambda$0(DeferredInputStream this$0, RemoteProcess it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ((InputStream)this$0.streamGetter.invoke((Object)it)).close();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\nH\u0016J \u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/remote/DeferredRemoteProcess$DeferredOutputStream;", "Ljava/io/OutputStream;", "<init>", "(Lcom/intellij/remote/DeferredRemoteProcess;)V", "close", "", "flush", "write", "b", "", "", "off", "len", "intellij.platform.ide.remote"})
    private final class DeferredOutputStream
    extends OutputStream {
        @Override
        public void close() {
            DeferredRemoteProcess.this.runNowOrSchedule(DeferredOutputStream::close$lambda$0);
        }

        @Override
        public void flush() {
            block0: {
                Object object = DeferredRemoteProcess.this.tryGet();
                if (object == null || (object = ((Process)object).getOutputStream()) == null) break block0;
                ((OutputStream)object).flush();
            }
        }

        @Override
        public void write(int b) {
            DeferredRemoteProcess.this.get().getOutputStream().write(b);
        }

        @Override
        public void write(@NotNull byte[] b) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            DeferredRemoteProcess.this.get().getOutputStream().write(b);
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            DeferredRemoteProcess.this.get().getOutputStream().write(b, off, len);
        }

        private static final Unit close$lambda$0(RemoteProcess it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.getOutputStream().close();
            return Unit.INSTANCE;
        }
    }
}

