/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.build.dependencies;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.build.dependencies.CacheDirCleanupKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J.\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/intellij/build/dependencies/CacheDirCleanup;", "", "cacheDir", "Ljava/nio/file/Path;", "maxAccessTimeAge", "Lkotlin/time/Duration;", "<init>", "(Ljava/nio/file/Path;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "lastCleanupMarkerFile", "runCleanupIfRequired", "", "isTimeForCleanup", "cleanupCacheDir", "", "cleanupCacheFile", "file", "cacheFiles", "", "currentTime", "", "maxTimeMs", "Companion", "intellij.platform.buildScripts.downloader"})
@SourceDebugExtension(value={"SMAP\nCacheDirCleanup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheDirCleanup.kt\norg/jetbrains/intellij/build/dependencies/CacheDirCleanup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n873#2,2:131\n*S KotlinDebug\n*F\n+ 1 CacheDirCleanup.kt\norg/jetbrains/intellij/build/dependencies/CacheDirCleanup\n*L\n57#1:131,2\n*E\n"})
public final class CacheDirCleanup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path cacheDir;
    private final long maxAccessTimeAge;
    @NotNull
    private final Path lastCleanupMarkerFile;
    @NotNull
    public static final String LAST_CLEANUP_MARKER_FILE_NAME = ".last.cleanup.marker";

    private CacheDirCleanup(Path cacheDir, long maxAccessTimeAge) {
        Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
        this.cacheDir = cacheDir;
        this.maxAccessTimeAge = maxAccessTimeAge;
        Path path = this.cacheDir.resolve(LAST_CLEANUP_MARKER_FILE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.lastCleanupMarkerFile = path;
    }

    public /* synthetic */ CacheDirCleanup(Path path, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = DurationKt.toDuration((int)22, (DurationUnit)DurationUnit.DAYS);
        }
        this(path, l, null);
    }

    public final boolean runCleanupIfRequired() throws IOException {
        if (!this.isTimeForCleanup()) {
            return false;
        }
        this.cleanupCacheDir();
        Files.writeString(this.lastCleanupMarkerFile, (CharSequence)LocalDateTime.now().toString(), new OpenOption[0]);
        return true;
    }

    private final boolean isTimeForCleanup() {
        return Files.notExists(this.lastCleanupMarkerFile, new LinkOption[0]) || Files.getLastModifiedTime(this.lastCleanupMarkerFile, new LinkOption[0]).toMillis() < System.currentTimeMillis() - Duration.getInWholeMilliseconds-impl((long)CacheDirCleanupKt.access$getCLEANUP_EVERY_DURATION$p());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void cleanupCacheDir() throws IOException {
        Object object;
        Closeable closeable;
        try {
            Iterable stream;
            closeable = Files.newDirectoryStream(this.cacheDir);
            Throwable throwable = null;
            try {
                void $this$filterTo$iv;
                stream = (DirectoryStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)stream);
                object = stream;
                Collection destination$iv = new HashSet();
                boolean $i$f$filterTo = false;
                for (Object element$iv : $this$filterTo$iv) {
                    Path it = (Path)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)this.lastCleanupMarkerFile))) continue;
                    destination$iv.add(element$iv);
                }
                stream = (HashSet)destination$iv;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = stream;
        }
        catch (NoSuchFileException e) {
            CacheDirCleanupKt.access$getLOG$p().fine("Cache directory '" + this.cacheDir + "' doesn't exist, skipping cleanup");
            return;
        }
        catch (NotDirectoryException e) {
            throw new IllegalStateException("Cache directory '" + this.cacheDir + "' is not a directory");
        }
        Closeable cacheFiles = closeable;
        long maxTimeMs = Duration.getInWholeMilliseconds-impl((long)this.maxAccessTimeAge);
        long currentTime = System.currentTimeMillis();
        Iterator iterator = ((HashSet)((Object)cacheFiles)).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        object = iterator;
        while (object.hasNext()) {
            Path file = (Path)object.next();
            Intrinsics.checkNotNull((Object)file);
            this.cleanupCacheFile(file, (Set)((Object)cacheFiles), currentTime, maxTimeMs);
        }
    }

    private final void cleanupCacheFile(Path file, Set<? extends Path> cacheFiles, long currentTime, long maxTimeMs) {
        FileTime fileTime;
        String fileName = ((Object)file.getFileName()).toString();
        if (StringsKt.endsWith$default((String)fileName, (String)".marked.for.cleanup", (boolean)false, (int)2, null)) {
            String string = fileName.substring(0, fileName.length() - 19);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Path realFile = this.cacheDir.resolve(string);
            if (!cacheFiles.contains(realFile)) {
                CacheDirCleanupKt.access$getLOG$p().info("CACHE-CLEANUP: Removing orphan marker: " + file);
                Files.deleteIfExists(file);
            }
            return;
        }
        Path markFile = this.cacheDir.resolve(fileName + ".marked.for.cleanup");
        try {
            fileTime = Files.getLastModifiedTime(file, new LinkOption[0]);
        }
        catch (NoSuchFileException ignore) {
            return;
        }
        FileTime lastAccessTime = fileTime;
        if (lastAccessTime.toMillis() > currentTime - maxTimeMs) {
            if (cacheFiles.contains(markFile)) {
                Files.deleteIfExists(markFile);
            }
            return;
        }
        if (Files.exists(markFile, new LinkOption[0])) {
            CacheDirCleanupKt.access$getLOG$p().info("CACHE-CLEANUP: Deleting file/directory '" + file + "': it's too old and marked for cleanup");
            Path toRemove = this.cacheDir.resolve(StringsKt.takeLast((String)(fileName + ".toRm." + UUID.randomUUID()), (int)236));
            try {
                Files.move(file, toRemove, new CopyOption[0]);
                Intrinsics.checkNotNull((Object)toRemove);
                PathsKt.deleteRecursively((Path)toRemove);
            }
            catch (Throwable e) {
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                CacheDirCleanupKt.access$getLOG$p().warning(StringsKt.trimIndent((String)("\n    Unable to delete file '" + file + "': " + e.getMessage() + "\n    " + writer + "\n    ")));
            }
            Files.deleteIfExists(markFile);
        } else {
            CacheDirCleanupKt.access$getLOG$p().info("CACHE-CLEANUP: Marking File '" + file + "' for deletion, it'll be removed on the next cleanup run");
            Files.newByteChannel(markFile, (Set<? extends OpenOption>)EnumSet.of((Enum)StandardOpenOption.CREATE, (Enum)StandardOpenOption.WRITE), new FileAttribute[0]).close();
        }
    }

    public /* synthetic */ CacheDirCleanup(Path cacheDir, long maxAccessTimeAge, DefaultConstructorMarker $constructor_marker) {
        this(cacheDir, maxAccessTimeAge);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/intellij/build/dependencies/CacheDirCleanup$Companion;", "", "<init>", "()V", "LAST_CLEANUP_MARKER_FILE_NAME", "", "intellij.platform.buildScripts.downloader"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

