/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.xfer.scp;

import java.util.LinkedHashMap;

public class ScpCommandLine {
    private static final String SCP_COMMAND = "scp";
    private EscapeMode mode;
    private LinkedHashMap<Arg, String> arguments = new LinkedHashMap();
    private String path;

    ScpCommandLine() {
    }

    static ScpCommandLine with(Arg name) {
        return ScpCommandLine.with(name, null, true);
    }

    static ScpCommandLine with(Arg name, String value) {
        return ScpCommandLine.with(name, value, true);
    }

    static ScpCommandLine with(Arg name, boolean accept) {
        return ScpCommandLine.with(name, null, accept);
    }

    static ScpCommandLine with(Arg name, String value, boolean accept) {
        ScpCommandLine commandLine = new ScpCommandLine();
        commandLine.addArgument(name, value, accept);
        return commandLine;
    }

    private void addArgument(Arg name, String value, boolean accept) {
        if (accept) {
            this.arguments.put(name, value);
        }
    }

    ScpCommandLine and(Arg name) {
        this.addArgument(name, null, true);
        return this;
    }

    ScpCommandLine and(Arg name, String value) {
        this.addArgument(name, value, true);
        return this;
    }

    ScpCommandLine and(Arg name, boolean accept) {
        this.addArgument(name, null, accept);
        return this;
    }

    ScpCommandLine and(Arg name, String value, boolean accept) {
        this.addArgument(name, value, accept);
        return this;
    }

    ScpCommandLine withPath(String path, EscapeMode mode) {
        this.path = path;
        this.mode = mode;
        return this;
    }

    String toCommandLine() {
        StringBuilder cmd = new StringBuilder(SCP_COMMAND);
        for (Arg arg : this.arguments.keySet()) {
            cmd.append(" ").append((Object)arg);
            String s = this.arguments.get((Object)arg);
            if (s == null || s.trim().isEmpty()) continue;
            cmd.append(s);
        }
        cmd.append(" ");
        if (this.path == null || this.path.trim().isEmpty()) {
            cmd.append(".");
        } else {
            cmd.append(this.mode.escapedPath(this.path));
        }
        return cmd.toString();
    }

    public static enum EscapeMode {
        NoEscape,
        Space{

            @Override
            String escapedPath(String path) {
                return path.replace(" ", "\\ ");
            }
        }
        ,
        DoubleQuote{

            @Override
            String escapedPath(String path) {
                return "\"" + path.replace("\"", "\\\"") + "\"";
            }
        }
        ,
        SingleQuote{

            @Override
            String escapedPath(String path) {
                return "'" + path.replace("'", "\\'") + "'";
            }
        };


        String escapedPath(String path) {
            return path;
        }
    }

    static enum Arg {
        SOURCE('f'),
        SINK('t'),
        RECURSIVE('r'),
        VERBOSE('v'),
        PRESERVE_TIMES('p'),
        QUIET('q'),
        LIMIT('l');

        private final char a;

        private Arg(char a) {
            this.a = a;
        }

        public String toString() {
            return "-" + this.a;
        }
    }
}

