/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.frontend.view.impl.TerminalSearchControllerListener;
import com.intellij.terminal.frontend.view.impl.TerminalSearchSession;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\u0011\u001a\u00020\fH\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002J\b\u0010\u0016\u001a\u00020\fH\u0007J\b\u0010\u0017\u001a\u00020\fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalSearchController;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/intellij/terminal/frontend/view/impl/TerminalSearchControllerListener;", "searchSession", "Lcom/intellij/terminal/frontend/view/impl/TerminalSearchSession;", "addListener", "", "listener", "startOrActivateSearchSession", "editor", "Lcom/intellij/openapi/editor/Editor;", "finishSearchSession", "hasActiveSession", "", "startSession", "onSearchClosed", "searchForward", "searchBackward", "Companion", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalSearchController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalSearchController.kt\ncom/intellij/terminal/frontend/view/impl/TerminalSearchController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1915#2,2:82\n1915#2,2:84\n*S KotlinDebug\n*F\n+ 1 TerminalSearchController.kt\ncom/intellij/terminal/frontend/view/impl/TerminalSearchController\n*L\n50#1:82,2\n56#1:84,2\n*E\n"})
public final class TerminalSearchController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CopyOnWriteArrayList<TerminalSearchControllerListener> listeners;
    @Nullable
    private TerminalSearchSession searchSession;
    @NotNull
    private static final DataKey<TerminalSearchController> KEY = DataKey.Companion.create("TerminalSearchController");

    public TerminalSearchController(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.listeners = new CopyOnWriteArrayList();
    }

    public final void addListener(@NotNull TerminalSearchControllerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @RequiresEdt
    public final void startOrActivateSearchSession(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ThreadingAssertions.assertEventDispatchThread();
        TerminalSearchSession existingSession = this.searchSession;
        if (existingSession == null) {
            this.startSession(editor);
        } else {
            existingSession.activate();
        }
    }

    @RequiresEdt
    public final void finishSearchSession() {
        block0: {
            ThreadingAssertions.assertEventDispatchThread();
            TerminalSearchSession terminalSearchSession = this.searchSession;
            if (terminalSearchSession == null) break block0;
            terminalSearchSession.close();
        }
    }

    public final boolean hasActiveSession() {
        return this.searchSession != null;
    }

    private final void startSession(Editor editor) {
        TerminalSearchSession session2;
        FindModel findModel = new FindModel();
        FindModel findModel2 = FindManager.getInstance((Project)this.project).getFindInFileModel();
        Intrinsics.checkNotNullExpressionValue((Object)findModel2, (String)"getFindInFileModel(...)");
        findModel.copyFrom(findModel2);
        findModel.setWholeWordsOnly(false);
        FindUtil.configureFindModel((boolean)false, (Editor)editor, (FindModel)findModel, (boolean)false);
        findModel.setGlobal(false);
        this.searchSession = session2 = new TerminalSearchSession(this.project, editor, findModel, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                TerminalSearchController.access$onSearchClosed((TerminalSearchController)this.receiver);
            }
        }));
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TerminalSearchControllerListener it = (TerminalSearchControllerListener)element$iv;
            boolean bl = false;
            it.searchSessionStarted(session2);
        }
        session2.getComponent().requestFocusInTheSearchFieldAndSelectContent(this.project);
    }

    private final void onSearchClosed() {
        TerminalSearchSession terminalSearchSession = this.searchSession;
        if (terminalSearchSession == null) {
            return;
        }
        TerminalSearchSession session2 = terminalSearchSession;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TerminalSearchControllerListener it = (TerminalSearchControllerListener)element$iv;
            boolean bl = false;
            it.searchSessionFinished(session2);
        }
        this.searchSession = null;
    }

    @RequiresEdt
    public final void searchForward() {
        block0: {
            ThreadingAssertions.assertEventDispatchThread();
            TerminalSearchSession terminalSearchSession = this.searchSession;
            if (terminalSearchSession == null) break block0;
            terminalSearchSession.searchForward();
        }
    }

    @RequiresEdt
    public final void searchBackward() {
        block0: {
            ThreadingAssertions.assertEventDispatchThread();
            TerminalSearchSession terminalSearchSession = this.searchSession;
            if (terminalSearchSession == null) break block0;
            terminalSearchSession.searchBackward();
        }
    }

    public static final /* synthetic */ void access$onSearchClosed(TerminalSearchController $this) {
        $this.onSearchClosed();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalSearchController$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/terminal/frontend/view/impl/TerminalSearchController;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<TerminalSearchController> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

