/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.ExperimentalUI;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.TerminalEngine;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.block.TerminalWidgetImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u0007H\u0017\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/terminal/LocalBlockTerminalRunner;", "Lorg/jetbrains/plugins/terminal/LocalTerminalDirectRunner;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isGenOneTerminalEnabled", "", "createShellTerminalWidget", "Lcom/intellij/terminal/ui/TerminalWidget;", "parent", "Lcom/intellij/openapi/Disposable;", "startupOptions", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions;", "shouldShowPromotion", "Companion", "intellij.terminal"})
@ApiStatus.Internal
@ApiStatus.Experimental
public class LocalBlockTerminalRunner
extends LocalTerminalDirectRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String BLOCK_TERMINAL_REGISTRY = "terminal.new.ui";
    @NotNull
    public static final String REWORKED_BLOCK_TERMINAL_REGISTRY = "terminal.new.ui.reworked";
    @NotNull
    public static final String BLOCK_TERMINAL_FISH_REGISTRY = "terminal.new.ui.fish";
    @NotNull
    public static final String BLOCK_TERMINAL_AUTOCOMPLETION = "terminal.new.ui.autocompletion";
    @NotNull
    private static final String BLOCK_TERMINAL_SHOW_PROMOTION = "terminal.new.ui.show.promotion";

    public LocalBlockTerminalRunner(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    protected boolean isGenOneTerminalEnabled() {
        return true;
    }

    @Override
    @NotNull
    protected TerminalWidget createShellTerminalWidget(@NotNull Disposable parent, @NotNull ShellStartupOptions startupOptions) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)startupOptions, (String)"startupOptions");
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        JBTerminalSystemSettingsProvider jBTerminalSystemSettingsProvider = this.getSettingsProvider();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)jBTerminalSystemSettingsProvider), (String)"getSettingsProvider(...)");
        return new TerminalWidgetImpl(project, jBTerminalSystemSettingsProvider, parent);
    }

    @Deprecated(message="Unused")
    public boolean shouldShowPromotion() {
        return ExperimentalUI.Companion.isNewUI() && Registry.Companion.is(BLOCK_TERMINAL_SHOW_PROMOTION, false) && TerminalOptionsProvider.Companion.getInstance().getTerminalEngine() == TerminalEngine.CLASSIC;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/terminal/LocalBlockTerminalRunner$Companion;", "", "<init>", "()V", "BLOCK_TERMINAL_REGISTRY", "", "REWORKED_BLOCK_TERMINAL_REGISTRY", "BLOCK_TERMINAL_FISH_REGISTRY", "BLOCK_TERMINAL_AUTOCOMPLETION", "BLOCK_TERMINAL_SHOW_PROMOTION", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

