/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.history;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.history.TerminalCommandHistoryProvider;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModel;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.ShellCommandListener;
import org.jetbrains.plugins.terminal.exp.completion.TerminalShellSupport;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/terminal/block/history/CommandHistoryManager;", "", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "promptModel", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;)V", "mutableHistory", "", "", "getHistory", "", "initCommandHistory", "", "history", "intellij.terminal"})
public final class CommandHistoryManager {
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final TerminalPromptModel promptModel;
    @NotNull
    private final Set<String> mutableHistory;

    public CommandHistoryManager(@NotNull BlockTerminalSession session2, @NotNull TerminalPromptModel promptModel) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)promptModel, (String)"promptModel");
        this.session = session2;
        this.promptModel = promptModel;
        Set set = Collections.synchronizedSet(new LinkedHashSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
        this.mutableHistory = set;
        BlockTerminalSession.addCommandListener$default(this.session, new ShellCommandListener(){

            @Override
            public void commandHistoryReceived(String history) {
                Intrinsics.checkNotNullParameter((Object)history, (String)"history");
                this.initCommandHistory(history);
            }

            @Override
            public void commandStarted(String command2) {
                Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
                String trimmedCommand = ((Object)StringsKt.trim((CharSequence)command2)).toString();
                if (((CharSequence)trimmedCommand).length() > 0) {
                    mutableHistory.remove(trimmedCommand);
                    mutableHistory.add(trimmedCommand);
                }
            }
        }, null, 2, null);
    }

    @NotNull
    public final List<String> getHistory() {
        List<String> historyFromProvider;
        List<String> list;
        List<String> list2;
        block2: {
            for (TerminalCommandHistoryProvider provider : (Iterable)TerminalCommandHistoryProvider.Companion.getEP_NAME$intellij_terminal().getExtensionList()) {
                boolean bl = false;
                List<String> list3 = provider.getCommandHistory(this.promptModel);
                if (list3 == null) continue;
                list2 = list3;
                break block2;
            }
            list2 = null;
        }
        if ((list = (historyFromProvider = list2)) == null) {
            list = CollectionsKt.toList((Iterable)this.mutableHistory);
        }
        return list;
    }

    private final void initCommandHistory(String history) {
        if (!((Collection)this.mutableHistory).isEmpty()) {
            return;
        }
        TerminalShellSupport terminalShellSupport = TerminalShellSupport.Companion.findByShellType(this.session.getShellIntegration().getShellType());
        if (terminalShellSupport == null) {
            return;
        }
        TerminalShellSupport shellSupport = terminalShellSupport;
        List<String> unsortedHistory = shellSupport.parseCommandHistory(history);
        LinkedHashSet<String> historySet = new LinkedHashSet<String>();
        for (int ind = unsortedHistory.size() - 1; -1 < ind; --ind) {
            historySet.add(unsortedHistory.get(ind));
        }
        SequencedCollection reversedHistory = historySet.reversed();
        Intrinsics.checkNotNull((Object)reversedHistory);
        this.mutableHistory.addAll(reversedHistory);
    }
}

