/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public final class MixedColorProducer {
    @NotNull
    private final Color first;
    @NotNull
    private final Color second;
    private Color cached;
    private double mixer;
    private int argb0;
    private int argb1;

    public MixedColorProducer(@NotNull Color color0, @NotNull Color color1) {
        if (color0 == null) {
            MixedColorProducer.$$$reportNull$$$0(0);
        }
        if (color1 == null) {
            MixedColorProducer.$$$reportNull$$$0(1);
        }
        this.first = color0;
        this.second = color1;
    }

    private void updateMixer(double value) {
        if (this.mixer != value) {
            this.mixer = value;
            this.cached = null;
        }
    }

    private void updateFirstARGB() {
        int value = this.first.getRGB();
        if (this.argb0 != value) {
            this.argb0 = value;
            this.cached = null;
        }
    }

    private void updateSecondARGB() {
        int value = this.second.getRGB();
        if (this.argb1 != value) {
            this.argb1 = value;
            this.cached = null;
        }
    }

    private int mix(int pos) {
        int value0 = 0xFF & this.argb0 >> pos;
        int value1 = 0xFF & this.argb1 >> pos;
        if (value0 == value1) {
            return value0;
        }
        return value0 + (int)Math.round(this.mixer * (double)(value1 - value0));
    }

    @NotNull
    public Color produce(double mixer) {
        if (Double.isNaN(mixer) || mixer < 0.0 || 1.0 < mixer) {
            throw new IllegalArgumentException("mixer[0..1] is " + mixer);
        }
        if (mixer <= 0.0) {
            Color color = this.first;
            if (color == null) {
                MixedColorProducer.$$$reportNull$$$0(2);
            }
            return color;
        }
        if (mixer >= 1.0) {
            Color color = this.second;
            if (color == null) {
                MixedColorProducer.$$$reportNull$$$0(3);
            }
            return color;
        }
        this.updateMixer(mixer);
        this.updateFirstARGB();
        this.updateSecondARGB();
        Color result = this.cached;
        if (result == null) {
            this.cached = result = new Color(this.mix(16), this.mix(8), this.mix(0), this.mix(24));
        }
        Color color = result;
        if (color == null) {
            MixedColorProducer.$$$reportNull$$$0(4);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color0";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color1";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/MixedColorProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/MixedColorProducer";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "produce";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

