/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.toolwindow.packages;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.repository.PyPackageRepository;
import com.jetbrains.python.packaging.toolwindow.model.DisplayablePackage;
import com.jetbrains.python.packaging.toolwindow.packages.PyPackagingTreeGroup;
import com.jetbrains.python.packaging.toolwindow.packages.tree.PyPackagesTreeListener;
import com.jetbrains.python.packaging.toolwindow.packages.tree.PyPackagesTreeTable;
import com.jetbrains.python.packaging.toolwindow.ui.PyPackagesUiComponents;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001:\u0001.B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001d\u001a\u00020\u0014H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0006\u0010 \u001a\u00020\u001fJ\u0006\u0010!\u001a\u00020\u001fJ\u0006\u0010\"\u001a\u00020\u001fJ\u0006\u0010#\u001a\u00020\u001fJ\b\u0010$\u001a\u00020\u001fH\u0002J\u0015\u0010%\u001a\u00020\u001f2\b\u0010&\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010'J\u0012\u0010(\u001a\u00020\u001f2\n\b\u0001\u0010)\u001a\u0004\u0018\u00010\rJ\u000e\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u0007J\u000e\u0010,\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u0007J\u0006\u0010-\u001a\u00020\u001fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006/"}, d2={"Lcom/jetbrains/python/packaging/toolwindow/packages/PyPackagingTreeGroup;", "", "repository", "Lcom/jetbrains/python/packaging/repository/PyPackageRepository;", "tree", "Lcom/jetbrains/python/packaging/toolwindow/packages/tree/PyPackagesTreeTable;", "container", "Ljavax/swing/JPanel;", "<init>", "(Lcom/jetbrains/python/packaging/repository/PyPackageRepository;Lcom/jetbrains/python/packaging/toolwindow/packages/tree/PyPackagesTreeTable;Ljavax/swing/JPanel;)V", "getTree", "()Lcom/jetbrains/python/packaging/toolwindow/packages/tree/PyPackagesTreeTable;", "repositoryName", "", "getRepositoryName", "()Ljava/lang/String;", "itemsCount", "", "Ljava/lang/Integer;", "headerProperties", "Lcom/jetbrains/python/packaging/toolwindow/packages/PyPackagingTreeGroup$HeaderProperties;", "value", "", "Lcom/jetbrains/python/packaging/toolwindow/model/DisplayablePackage;", "items", "getItems$intellij_python_community_impl", "()Ljava/util/List;", "setItems$intellij_python_community_impl", "(Ljava/util/List;)V", "createHeaderProperties", "setupTreeListener", "", "updatePreferredSize", "collapse", "collapseAll", "expand", "updateExpandStateIcon", "updateHeaderText", "newItemCount", "(Ljava/lang/Integer;)V", "setSdkToHeader", "sdkName", "addTo", "panel", "removeFrom", "repaint", "HeaderProperties", "intellij.python.community.impl"})
public final class PyPackagingTreeGroup {
    @NotNull
    private final PyPackagesTreeTable tree;
    @NotNull
    private final JPanel container;
    @NlsSafe
    @NotNull
    private final String repositoryName;
    @Nullable
    private Integer itemsCount;
    @NotNull
    private final HeaderProperties headerProperties;

    public PyPackagingTreeGroup(@NotNull PyPackageRepository repository, @NotNull PyPackagesTreeTable tree, @NotNull JPanel container) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.tree = tree;
        this.container = container;
        this.repositoryName = repository.getName();
        this.headerProperties = this.createHeaderProperties();
        this.setupTreeListener();
    }

    @NotNull
    public final PyPackagesTreeTable getTree() {
        return this.tree;
    }

    @NotNull
    public final String getRepositoryName() {
        return this.repositoryName;
    }

    @NotNull
    public final List<DisplayablePackage> getItems$intellij_python_community_impl() {
        return this.tree.getItems();
    }

    public final void setItems$intellij_python_community_impl(@NotNull List<? extends DisplayablePackage> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.tree.setItems(value);
    }

    private final HeaderProperties createHeaderProperties() {
        JBLabel jBLabel;
        JBLabel $this$createHeaderProperties_u24lambda_u240 = jBLabel = new JBLabel(this.repositoryName);
        boolean bl = false;
        $this$createHeaderProperties_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
        $this$createHeaderProperties_u24lambda_u240.setIcon(AllIcons.General.ArrowDown);
        $this$createHeaderProperties_u24lambda_u240.setHorizontalAlignment(2);
        $this$createHeaderProperties_u24lambda_u240.setVerticalAlignment(0);
        JBLabel label = jBLabel;
        JPanel panel2 = PyPackagesUiComponents.INSTANCE.headerPanel((JLabel)label, (JComponent)((Object)this.tree));
        return new HeaderProperties(label, panel2);
    }

    private final void setupTreeListener() {
        this.tree.setTreeListener(new PyPackagesTreeListener(this){
            final /* synthetic */ PyPackagingTreeGroup this$0;
            {
                this.this$0 = $receiver;
            }

            public void onTreeStructureChanged() {
                SwingUtilities.invokeLater(() -> setupTreeListener.1.onTreeStructureChanged$lambda$0(this.this$0));
            }

            private static final void onTreeStructureChanged$lambda$0(PyPackagingTreeGroup this$0) {
                this$0.updatePreferredSize();
                this$0.repaint();
            }
        });
    }

    public final void updatePreferredSize() {
        int totalHeight = this.tree.getTree().getRowCount() * this.tree.getTree().getRowHeight();
        int width = this.container.getWidth();
        this.tree.setPreferredSize(new Dimension(width, totalHeight));
        this.tree.setMinimumSize(new Dimension(width, totalHeight));
        this.tree.setMaximumSize(new Dimension(width, totalHeight));
    }

    public final void collapse() {
        this.tree.setVisible(false);
        this.updateExpandStateIcon();
        this.repaint();
    }

    public final void collapseAll() {
        int n = this.tree.getTree().getRowCount();
        for (int i = 0; i < n; ++i) {
            this.tree.getTree().collapseRow(i);
        }
        this.collapse();
    }

    public final void expand() {
        this.tree.setVisible(true);
        this.updateExpandStateIcon();
        this.repaint();
    }

    private final void updateExpandStateIcon() {
        this.headerProperties.getLabel().setIcon(this.tree.isVisible() ? AllIcons.General.ArrowDown : AllIcons.General.ArrowRight);
    }

    public final void updateHeaderText(@Nullable Integer newItemCount) {
        String string;
        this.itemsCount = newItemCount;
        JBLabel jBLabel = this.headerProperties.getLabel();
        if (this.itemsCount == null) {
            string = this.repositoryName;
        } else {
            Object[] objectArray = new Object[]{this.repositoryName, this.itemsCount};
            string = PyBundle.message("python.toolwindow.packages.custom.repo.searched", objectArray);
        }
        jBLabel.setText(string);
    }

    public final void setSdkToHeader(@Nls @Nullable String sdkName2) {
        this.itemsCount = null;
        Object[] objectArray = new Object[]{this.repositoryName, sdkName2};
        this.headerProperties.getLabel().setText(PyBundle.message("python.toolwindow.packages.sdk.label.html", objectArray));
    }

    public final void addTo(@NotNull JPanel panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        panel2.add(this.headerProperties.getPanel());
        panel2.add((Component)((Object)this.tree));
    }

    public final void removeFrom(@NotNull JPanel panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        panel2.remove(this.headerProperties.getPanel());
        panel2.remove((Component)((Object)this.tree));
    }

    public final void repaint() {
        this.container.revalidate();
        this.container.repaint();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/python/packaging/toolwindow/packages/PyPackagingTreeGroup$HeaderProperties;", "", "label", "Lcom/intellij/ui/components/JBLabel;", "panel", "Ljavax/swing/JPanel;", "<init>", "(Lcom/intellij/ui/components/JBLabel;Ljavax/swing/JPanel;)V", "getLabel", "()Lcom/intellij/ui/components/JBLabel;", "getPanel", "()Ljavax/swing/JPanel;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.python.community.impl"})
    private static final class HeaderProperties {
        @NotNull
        private final JBLabel label;
        @NotNull
        private final JPanel panel;

        public HeaderProperties(@NotNull JBLabel label, @NotNull JPanel panel2) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            this.label = label;
            this.panel = panel2;
        }

        @NotNull
        public final JBLabel getLabel() {
            return this.label;
        }

        @NotNull
        public final JPanel getPanel() {
            return this.panel;
        }

        @NotNull
        public final JBLabel component1() {
            return this.label;
        }

        @NotNull
        public final JPanel component2() {
            return this.panel;
        }

        @NotNull
        public final HeaderProperties copy(@NotNull JBLabel label, @NotNull JPanel panel2) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            return new HeaderProperties(label, panel2);
        }

        public static /* synthetic */ HeaderProperties copy$default(HeaderProperties headerProperties, JBLabel jBLabel, JPanel jPanel, int n, Object object) {
            if ((n & 1) != 0) {
                jBLabel = headerProperties.label;
            }
            if ((n & 2) != 0) {
                jPanel = headerProperties.panel;
            }
            return headerProperties.copy(jBLabel, jPanel);
        }

        @NotNull
        public String toString() {
            return "HeaderProperties(label=" + this.label + ", panel=" + this.panel + ")";
        }

        public int hashCode() {
            int result2 = this.label.hashCode();
            result2 = result2 * 31 + this.panel.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HeaderProperties)) {
                return false;
            }
            HeaderProperties headerProperties = (HeaderProperties)other;
            if (!Intrinsics.areEqual((Object)this.label, (Object)headerProperties.label)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.panel, (Object)headerProperties.panel);
        }
    }
}

