/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.requirements;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.jetbrains.python.requirements.PackageUtilsKt;
import com.jetbrains.python.requirements.RequirementsCompletionUtilKt;
import com.jetbrains.python.requirements.RequirementsFile;
import com.jetbrains.python.requirements.psi.RequirementsTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/requirements/RequirementsPackageNameCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "<init>", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.python.community.impl"})
public final class RequirementsPackageNameCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (!(parameters.getOriginalFile() instanceof RequirementsFile)) {
            return;
        }
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement nameElement = psiElement;
        LeafPsiElement leafPsiElement = nameElement instanceof LeafPsiElement ? (LeafPsiElement)nameElement : null;
        if (!Intrinsics.areEqual((Object)(leafPsiElement != null ? leafPsiElement.getElementType() : null), (Object)RequirementsTypes.IDENTIFIER)) {
            return;
        }
        PsiFile psiFile = parameters.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        Sdk sdk2 = PackageUtilsKt.getPythonSdk(psiFile);
        if (sdk2 == null) {
            return;
        }
        Sdk sdk3 = sdk2;
        Project project = ((LeafPsiElement)nameElement).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RequirementsCompletionUtilKt.completePackageNames(project, sdk3, result2);
    }
}

