/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.python.extensions.ModuleExtKt;
import com.jetbrains.python.packaging.PyPIPackageCache;
import com.jetbrains.python.packaging.PyPackageName;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.common.PythonPackage;
import com.jetbrains.python.packaging.dependencies.PythonDependenciesManager;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.packaging.requirement.PyRequirementVersionSpec;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import com.jetbrains.python.statistics.InterpreterTarget;
import com.jetbrains.python.statistics.InterpreterType;
import com.jetbrains.python.statistics.PyPackageUsagesCollectorKt;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0003R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/python/statistics/PyPackageVersionUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "requiresReadAccess", "", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "PYTHON_PACKAGE_INSTALLED", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "PYTHON_PACKAGE_INSTALLED_IN_SDK", "getPackages", "getInstalledPackages", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyPackageUsagesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPackageUsagesCollector.kt\ncom/jetbrains/python/statistics/PyPackageVersionUsagesCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n777#2:99\n873#2,2:100\n1915#2,2:102\n777#2:104\n873#2,2:105\n1915#2,2:107\n*S KotlinDebug\n*F\n+ 1 PyPackageUsagesCollector.kt\ncom/jetbrains/python/statistics/PyPackageVersionUsagesCollector\n*L\n53#1:99\n53#1:100,2\n54#1:102,2\n80#1:104\n80#1:105,2\n81#1:107,2\n*E\n"})
public final class PyPackageVersionUsagesCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("python.packages", 9, null, 4, null);
    @NotNull
    private final VarargEventId PYTHON_PACKAGE_INSTALLED;
    @NotNull
    private final VarargEventId PYTHON_PACKAGE_INSTALLED_IN_SDK;

    public PyPackageVersionUsagesCollector() {
        EventField[] eventFieldArray = new EventField[]{PyPackageUsagesCollectorKt.getPACKAGE_FIELD(), PyPackageUsagesCollectorKt.getPACKAGE_VERSION_FIELD()};
        this.PYTHON_PACKAGE_INSTALLED = PyStatisticToolsKt.registerPythonSpecificEvent(this.GROUP, "python_package_installed", eventFieldArray);
        eventFieldArray = new EventField[]{PyStatisticToolsKt.getEXECUTION_TYPE(), PyStatisticToolsKt.getINTERPRETER_TYPE(), PyPackageUsagesCollectorKt.getPACKAGE_FIELD(), PyPackageUsagesCollectorKt.getPACKAGE_VERSION_FIELD()};
        this.PYTHON_PACKAGE_INSTALLED_IN_SDK = this.GROUP.registerVarargEvent("python_packages_installed_in_sdk", eventFieldArray);
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SetsKt.plus(this.getPackages(project), (Iterable)this.getInstalledPackages(project));
    }

    protected boolean requiresReadAccess() {
        return true;
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<MetricEvent> getPackages(Project project) {
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
        PyPIPackageCache pyPIPackageCache = PyPIPackageCache.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)pyPIPackageCache, (String)"getInstance(...)");
        PyPIPackageCache pypiPackages = pyPIPackageCache;
        for (Module module2 : PyStatisticToolsKt.getModules(project)) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Sdk sdk2;
            if (ModuleExtKt.getSdk((Module)module2) == null || !PythonSdkUtil.isPythonSdk((Sdk)sdk2)) continue;
            List<EventPair<?>> usageData = PyStatisticToolsKt.getPythonSpecificInfo(sdk2);
            PythonDependenciesManager pythonDependenciesManager = PythonPackageManager.Companion.forSdk(project, sdk2).getDependencyManager();
            List list = pythonDependenciesManager != null ? pythonDependenciesManager.getDependencies() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List requirements = list;
            Iterable iterable = requirements;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PyRequirement it = (PyRequirement)element$iv$iv;
                boolean bl = false;
                if (!pypiPackages.containsPackage(it.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyRequirement req = (PyRequirement)element$iv;
                boolean bl = false;
                ProgressManager.checkCanceled();
                List list2 = req.getVersionSpecs();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getVersionSpecs(...)");
                Object object = (PyRequirementVersionSpec)CollectionsKt.firstOrNull((List)list2);
                if (object == null || (object = object.getVersion()) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
                    object = "unknown";
                }
                Object version2 = object;
                ArrayList<EventPair> data = new ArrayList<EventPair>((Collection)usageData);
                StringEventField stringEventField = PyPackageUsagesCollectorKt.getPACKAGE_FIELD();
                String string = req.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                data.add(stringEventField.with((Object)PyPackageName.Companion.normalizePackageName(string)));
                data.add(PyPackageUsagesCollectorKt.getPACKAGE_VERSION_FIELD().with(version2));
                result2.add(this.PYTHON_PACKAGE_INSTALLED.metric((List)data));
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread(generateAssertion=false)
    private final Set<MetricEvent> getInstalledPackages(Project project) {
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
        PyPIPackageCache pyPIPackageCache = PyPIPackageCache.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)pyPIPackageCache, (String)"getInstance(...)");
        PyPIPackageCache pypiPackages = pyPIPackageCache;
        for (Module module2 : PyStatisticToolsKt.getModules(project)) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Sdk sdk2;
            if (ModuleExtKt.getSdk((Module)module2) == null || !PythonSdkUtil.isPythonSdk((Sdk)sdk2) || !(sdk2.getSdkAdditionalData() instanceof PythonSdkAdditionalData)) continue;
            InterpreterTarget executionType = PyStatisticToolsKt.getExecutionType(sdk2);
            InterpreterType interpreterType = PyStatisticToolsKt.getInterpreterType(sdk2);
            List installedPackages2 = (List)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends PythonPackage>>, Object>(project, sdk2, null){
                int label;
                final /* synthetic */ Project $project;
                final /* synthetic */ Sdk $sdk;
                {
                    this.$project = $project;
                    this.$sdk = $sdk;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = PythonPackageManager.Companion.forSdk(this.$project, this.$sdk).listInstalledPackages((Continuation<? super List<? extends PythonPackage>>)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends PythonPackage>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            Iterable iterable = installedPackages2;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PythonPackage it = (PythonPackage)element$iv$iv;
                boolean bl = false;
                if (!pypiPackages.containsPackage(it.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List list;
                PythonPackage pythonPackage = (PythonPackage)element$iv;
                boolean bl = false;
                String version2 = pythonPackage.getVersion();
                List $this$getInstalledPackages_u24lambda_u241_u240 = list = CollectionsKt.createListBuilder();
                boolean bl2 = false;
                $this$getInstalledPackages_u24lambda_u241_u240.add(PyPackageUsagesCollectorKt.getPACKAGE_FIELD().with((Object)PyPackageName.Companion.normalizePackageName(pythonPackage.getName())));
                $this$getInstalledPackages_u24lambda_u241_u240.add(PyPackageUsagesCollectorKt.getPACKAGE_VERSION_FIELD().with((Object)version2));
                $this$getInstalledPackages_u24lambda_u241_u240.add(PyStatisticToolsKt.getEXECUTION_TYPE().with((Object)executionType.getValue()));
                $this$getInstalledPackages_u24lambda_u241_u240.add(PyStatisticToolsKt.getINTERPRETER_TYPE().with((Object)interpreterType.getValue()));
                List data = CollectionsKt.build((List)list);
                result2.add(this.PYTHON_PACKAGE_INSTALLED_IN_SDK.metric(data));
            }
        }
        return result2;
    }
}

