/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.LayeredIcon;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.icons.PythonPsiApiIcons;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStructureViewElement
implements StructureViewTreeElement {
    private final PyElement myElement;
    private final Visibility myVisibility;
    private Icon myIcon;
    private final boolean myInherited;
    private final boolean myField;

    protected PyStructureViewElement(PyElement element2, Visibility visibility, boolean inherited, boolean field) {
        this.myElement = element2;
        this.myVisibility = visibility;
        this.myInherited = inherited;
        this.myField = field;
    }

    public PyStructureViewElement(PyElement element2) {
        this(element2, Visibility.NORMAL, false, false);
    }

    protected StructureViewTreeElement createChild(PyElement element2, Visibility visibility, boolean inherited, boolean field) {
        return new PyStructureViewElement(element2, visibility, inherited, field);
    }

    @Nullable
    public PyElement getValue() {
        return this.myElement.isValid() ? this.myElement : null;
    }

    public boolean isInherited() {
        return this.myInherited;
    }

    public boolean isField() {
        return this.myField;
    }

    public void navigate(boolean requestFocus) {
        PyElement element2 = this.getValue();
        if (element2 != null) {
            this.myElement.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return this.myElement.isValid() && this.myElement.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myElement.isValid() && this.myElement.canNavigateToSource();
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    public boolean equals(Object o) {
        if (o instanceof StructureViewTreeElement) {
            Object value = ((StructureViewTreeElement)o).getValue();
            String name2 = this.myElement.getName();
            if (value instanceof PyElement && name2 != null) {
                return name2.equals(((PyElement)value).getName());
            }
        }
        return false;
    }

    public int hashCode() {
        String name2 = this.myElement.getName();
        return name2 != null ? name2.hashCode() : 0;
    }

    public StructureViewTreeElement @NotNull [] getChildren() {
        PyElement element2 = this.getValue();
        if (element2 == null) {
            if (EMPTY_ARRAY == null) {
                PyStructureViewElement.$$$reportNull$$$0(0);
            }
            return EMPTY_ARRAY;
        }
        ArrayList<StructureViewTreeElement> children = new ArrayList<StructureViewTreeElement>();
        for (PyElement e : this.getElementChildren(element2)) {
            children.add(this.createChild(e, PyStructureViewElement.getElementVisibility(e), false, this.elementIsField(e)));
        }
        PyPsiUtils.assertValid((PsiElement)element2);
        if (element2 instanceof PyClass) {
            TypeEvalContext context = TypeEvalContext.codeAnalysis((Project)element2.getProject(), (PsiFile)element2.getContainingFile());
            for (PyClass c : ((PyClass)element2).getAncestorClasses(context)) {
                for (PyElement e : this.getElementChildren((PyElement)c)) {
                    StructureViewTreeElement inherited = this.createChild(e, PyStructureViewElement.getElementVisibility(e), true, this.elementIsField(e));
                    if (children.contains(inherited)) continue;
                    children.add(inherited);
                }
            }
        }
        StructureViewTreeElement[] structureViewTreeElementArray = children.toArray(StructureViewTreeElement.EMPTY_ARRAY);
        if (structureViewTreeElementArray == null) {
            PyStructureViewElement.$$$reportNull$$$0(1);
        }
        return structureViewTreeElementArray;
    }

    protected boolean elementIsField(PyElement element2) {
        return element2 instanceof PyTargetExpression && PsiTreeUtil.getParentOfType((PsiElement)element2, PyClass.class) != null;
    }

    private static Visibility getElementVisibility(PyElement element2) {
        if (!(element2 instanceof PyTargetExpression) && PsiTreeUtil.getParentOfType((PsiElement)element2, PyFunction.class) != null) {
            return Visibility.INVISIBLE;
        }
        return PyStructureViewElement.getVisibilityByName(element2.getName());
    }

    private Collection<PyElement> getElementChildren(final PyElement element2) {
        final LinkedHashSet<PyElement> children = new LinkedHashSet<PyElement>();
        PyPsiUtils.assertValid((PsiElement)element2);
        element2.acceptChildren((PsiElementVisitor)new PyElementVisitor(){

            public void visitElement(@NotNull PsiElement e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PyStructureViewElement.this.isWorthyItem(e, (PsiElement)element2)) {
                    children.add((PyElement)e);
                } else {
                    e.acceptChildren((PsiElementVisitor)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/structureView/PyStructureViewElement$1", "visitElement"));
            }
        });
        if (element2 instanceof PyClass) {
            List<PyElement> attrs = this.getClassAttributes((PyClass)element2);
            ArrayList<PyElement> filtered = new ArrayList<PyElement>();
            HashSet<String> names = new HashSet<String>();
            for (PyElement attr : attrs) {
                String name2 = attr.getName();
                PyPsiUtils.assertValid((PsiElement)attr);
                if (!names.contains(name2)) {
                    filtered.add(attr);
                }
                names.add(name2);
            }
            Comparator comparator = (e1, e2) -> {
                String n1 = e1.getName();
                String n2 = e2.getName();
                return n1 != null && n2 != null ? n1.compareTo(n2) : 0;
            };
            filtered.sort(comparator);
            children.addAll(filtered);
        }
        return children;
    }

    protected List<PyElement> getClassAttributes(PyClass cls) {
        ArrayList<PyElement> results = new ArrayList<PyElement>();
        results.addAll(cls.getInstanceAttributes());
        results.addAll(cls.getClassAttributes());
        return results;
    }

    private static Visibility getVisibilityByName(@Nullable String name2) {
        if (name2 != null) {
            if (name2.startsWith("__")) {
                if (PyNames.UNDERSCORED_ATTRIBUTES.contains(name2)) {
                    return Visibility.PREDEFINED;
                }
                return Visibility.PRIVATE;
            }
            if (name2.startsWith("_")) {
                return Visibility.PROTECTED;
            }
        }
        return Visibility.NORMAL;
    }

    protected boolean isWorthyItem(@Nullable PsiElement element2, @Nullable PsiElement parent) {
        PsiElement e;
        if (element2 instanceof PyClass || element2 instanceof PyFunction) {
            return true;
        }
        return !(parent instanceof PyClass) && element2 instanceof PyTargetExpression && !((PyTargetExpression)element2).isQualified() && (e = element2.getParent()) instanceof PyAssignmentStatement && (e = e.getParent()) instanceof PyFile;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        final PyElement element2 = this.getValue();
        final ItemPresentation presentation = element2 != null ? element2.getPresentation() : null;
        return new ColoredItemPresentation(){

            @Nullable
            public String getPresentableText() {
                if (element2 instanceof PyFile) {
                    return element2.getName();
                }
                return presentation != null ? presentation.getPresentableText() : "<unnamed>";
            }

            @Nullable
            public TextAttributesKey getTextAttributesKey() {
                if (PyStructureViewElement.this.isInherited()) {
                    return CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES;
                }
                return null;
            }

            @Nullable
            public Icon getIcon(boolean open) {
                if (element2 == null) {
                    return null;
                }
                Icon normal_icon = element2.getIcon(0);
                if (PyStructureViewElement.this.myIcon != null) {
                    normal_icon = PyStructureViewElement.this.myIcon;
                }
                if (PyStructureViewElement.this.myVisibility == Visibility.NORMAL) {
                    return normal_icon;
                }
                LayeredIcon icon = new LayeredIcon(2);
                icon.setIcon(normal_icon, 0);
                Icon overlay = null;
                if (PyStructureViewElement.this.myVisibility == Visibility.PRIVATE || PyStructureViewElement.this.myVisibility == Visibility.PROTECTED) {
                    overlay = PythonPsiApiIcons.Nodes.Lock;
                } else if (PyStructureViewElement.this.myVisibility == Visibility.PREDEFINED) {
                    overlay = PythonPsiApiIcons.Nodes.CyanDot;
                } else if (PyStructureViewElement.this.myVisibility == Visibility.INVISIBLE) {
                    overlay = PythonPsiApiIcons.Nodes.RedInvTriangle;
                }
                if (overlay != null) {
                    icon.setIcon(overlay, 1);
                }
                return icon;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/structureView/PyStructureViewElement", "getChildren"));
    }

    protected static enum Visibility {
        NORMAL,
        INVISIBLE,
        PRIVATE,
        PROTECTED,
        PREDEFINED;

    }
}

