/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.tox;

import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipEmptySerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.python.serialization.AnnotationSerializationFilter;
import com.jetbrains.python.serialization.CompoundFilter;
import com.jetbrains.python.testing.AbstractPythonTestRunConfiguration;
import com.jetbrains.python.testing.tox.PyToxCommandLineState;
import com.jetbrains.python.testing.tox.PyToxConfigurationFactory;
import com.jetbrains.python.testing.tox.PyToxConfigurationSettings;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class PyToxConfiguration
extends AbstractPythonTestRunConfiguration<PyToxConfiguration> {
    @NotNull
    private final Project myProject;
    @Tag(value="arguments")
    private String @Nullable [] myArguments;
    @Tag(value="runOnlyEnvs")
    private String @Nullable [] myRunOnlyEnvs;

    PyToxConfiguration(@NotNull PyToxConfigurationFactory factory, @NotNull Project project) {
        if (factory == null) {
            PyToxConfiguration.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PyToxConfiguration.$$$reportNull$$$0(1);
        }
        super(project, factory, "tox");
        this.myProject = project;
        this.mySkipModuleSerialization = true;
    }

    @Override
    public boolean isIdTestBased() {
        return true;
    }

    @ApiStatus.Internal
    public String @NotNull [] getRunOnlyEnvs() {
        String[] stringArray = this.myRunOnlyEnvs == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : (String[])this.myRunOnlyEnvs.clone();
        if (stringArray == null) {
            PyToxConfiguration.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    public void setRunOnlyEnvs(String ... tests) {
        if (tests == null) {
            PyToxConfiguration.$$$reportNull$$$0(3);
        }
        this.myRunOnlyEnvs = (String[])tests.clone();
    }

    String @NotNull [] getArguments() {
        String[] stringArray = this.myArguments == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : (String[])this.myArguments.clone();
        if (stringArray == null) {
            PyToxConfiguration.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    @VisibleForTesting
    public void setArguments(String ... arguments) {
        if (arguments == null) {
            PyToxConfiguration.$$$reportNull$$$0(5);
        }
        this.myArguments = (String[])arguments.clone();
    }

    @Override
    public void readExternal(@NotNull Element element2) throws InvalidDataException {
        if (element2 == null) {
            PyToxConfiguration.$$$reportNull$$$0(6);
        }
        super.readExternal(element2);
        XmlSerializer.deserializeInto((Object)this, (Element)element2);
    }

    @Override
    public void writeExternal(@NotNull Element element2) throws WriteExternalException {
        if (element2 == null) {
            PyToxConfiguration.$$$reportNull$$$0(7);
        }
        super.writeExternal(element2);
        XmlSerializer.serializeInto((Object)this, (Element)element2, (SerializationFilter)new CompoundFilter(new SerializationFilter[]{new SkipEmptySerializationFilter(), new AnnotationSerializationFilter()}));
    }

    @Override
    protected SettingsEditor<PyToxConfiguration> createConfigurationEditor() {
        return new PyToxConfigurationSettings(this.myProject);
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        if (executor == null) {
            PyToxConfiguration.$$$reportNull$$$0(8);
        }
        if (environment == null) {
            PyToxConfiguration.$$$reportNull$$$0(9);
        }
        return new PyToxCommandLineState(this, environment);
    }

    @Override
    @Nullable
    public String getTestSpec(@NotNull Location<?> location, @NotNull AbstractTestProxy failedTest) {
        if (location == null) {
            PyToxConfiguration.$$$reportNull$$$0(10);
        }
        if (failedTest == null) {
            PyToxConfiguration.$$$reportNull$$$0(11);
        }
        for (AbstractTestProxy test = failedTest; test != null; test = test.getParent()) {
            String protocol;
            String url = test.getLocationUrl();
            if (url == null || !"tox_env".equals(protocol = VirtualFileManager.extractProtocol((String)url))) continue;
            return VirtualFileManager.extractPath((String)url);
        }
        return null;
    }

    @Override
    public void addTestSpecsAsParameters(@NotNull ParamsGroup paramsGroup, @NotNull List<String> testSpecs) {
        if (paramsGroup == null) {
            PyToxConfiguration.$$$reportNull$$$0(12);
        }
        if (testSpecs == null) {
            PyToxConfiguration.$$$reportNull$$$0(13);
        }
        if (!testSpecs.isEmpty()) {
            paramsGroup.addParameter(String.format("-e %s", StringUtil.join(testSpecs, (String)",")));
        }
        if (this.myArguments != null) {
            paramsGroup.addParameters(this.myArguments);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/testing/tox/PyToxConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tests";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedTest";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramsGroup";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testSpecs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/testing/tox/PyToxConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunOnlyEnvs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setRunOnlyEnvs";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setArguments";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTestSpec";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addTestSpecsAsParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

