/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.ReportingKind;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PhraseCommaChange(Node start, Node end, @Nullable NodeCorrector changeBefore, @Nullable NodeCorrector changeAfter) {
    @NotNull
    public NodeMatch highlightAndCorrect(@NotNull NodeMatch match) {
        return this.highlight(match).withCorrector(this.correct());
    }

    public NodeMatch highlight(NodeMatch match) {
        Tree tree = this.start.tree();
        TextRange hover = PhraseCommaChange.withoutPunctuation(this.start, this.end);
        if (this.changeBefore != null) {
            TextRange reported1 = PhraseCommaChange.mainReportedRange(tree, this.changeBefore);
            match = match.withReportedRange(reported1, tree);
            hover = new TextRange(reported1.start(), hover.end());
        }
        if (this.changeAfter != null) {
            TextRange reported2 = PhraseCommaChange.mainReportedRange(tree, this.changeAfter);
            match = match.withReportedRange(reported2, tree);
            hover = new TextRange(hover.start(), Math.max(hover.end(), reported2.end()));
        }
        return match.withReportedRange(hover, tree, ReportingKind.Hover).withTouchedNodes(this.start, this.end);
    }

    public static TextRange mainReportedRange(Tree tree, @NotNull NodeCorrector corrector) {
        List<Node> nodes = tree.findNodesAt(corrector.calcChangeRange().start());
        return CommonPatterns.withPrevWord(nodes.get(nodes.size() - 1));
    }

    private static TextRange withoutPunctuation(@NotNull Node start, @NotNull Node end) {
        return new TextRange(Objects.requireNonNull(PhraseCommaChange.findNonPunctuation(start.forward())).startOffset(), Objects.requireNonNull(PhraseCommaChange.findNonPunctuation(end.back())).endOffset());
    }

    @NotNull
    public NodeCorrector correct() {
        return this.changeBefore != null ? this.changeBefore.join(this.changeAfter) : Objects.requireNonNull(this.changeAfter);
    }

    public String selectMessage(String changeBefore, String changeAfter, String changeBoth) {
        return this.changeBefore == null ? changeAfter : (this.changeAfter == null ? changeBefore : changeBoth);
    }

    @Nullable
    public static Node findNonPunctuation(Stream<Node> nodes) {
        return nodes.filter(n -> !NodePattern.PUNCT.matches((Node)n)).findFirst().orElse(null);
    }

    @Nullable
    public static PhraseCommaChange removeSurroundingCommas(@NotNull Node start, @NotNull Node end, NodePattern unmandatedComma) {
        Node comma1 = PhraseCommaChange.findCommaBefore(start);
        Node comma2 = PhraseCommaChange.findCommaAfter(end);
        if (!unmandatedComma.matches(comma1)) {
            comma1 = null;
        }
        if (!unmandatedComma.matches(comma2)) {
            comma2 = null;
        }
        if (comma1 == null && comma2 == null) {
            return null;
        }
        return new PhraseCommaChange(start, end, comma1 == null ? null : NodeCorrector.removeNode(comma1), comma2 == null ? null : NodeCorrector.removeNode(comma2));
    }

    private static Node findCommaBefore(Node node) {
        return PhraseCommaChange.findCommaAround(NodePattern.PUNCT.matches(node) ? node : node.prevNode());
    }

    private static Node findCommaAfter(Node node) {
        return PhraseCommaChange.findCommaAround(NodePattern.PUNCT.matches(node) ? node : node.nextNode());
    }

    private static Node findCommaAround(@Nullable Node node) {
        return node == null ? null : ((StreamEx)node.back().takeWhile(NodePattern.PUNCT::matches)).findFirst(CommonPatterns.comma::matches).orElse(((StreamEx)node.forward().takeWhile(NodePattern.PUNCT::matches)).findFirst(CommonPatterns.comma::matches).orElse(null));
    }
}

