/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.settings;

import ai.grazie.rules.RuleClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;

public record TextStyle(String id, Map<String, String> paramValues, Set<String> enabledRules, Set<String> disabledRules) {
    private static final String[] hyphenToDash = new String[]{"En.Typography.HYPHEN_IN_RANGES", "En.Typography.LEADING_HYPHEN_TO_DASH", "De.Typography.LEADING_HYPHEN_TO_DASH", "En.Typography.HYPHEN_TO_DASH", "De.Typography.HYPHEN_TO_DASH", "Ru.Typography.HYPHEN_TO_DASH", "Uk.Typography.HYPHEN_TO_DASH"};
    private static final TextStyle Empty = new TextStyle("", Map.of(), Set.of(), Set.of());
    public static final TextStyle Unspecified = Empty.withId("Unspecified").withParams(Map.of("En.useSerialComma", "consistently"));
    private static final TextStyle Informal = Unspecified.withId("Informal").withParams(Map.of("En.contractionUse", "always")).disableRules("De.Punctuation.QUOTE_PUNCTUATION", "En.Typography.VARIANT_QUOTE_PUNCTUATION", "De.Style.SEHR_RULE", "En.Style.VERY_ABUSE", "De.Style.IMPERSONAL_PRONOUNS", "En.Style.TAUTOLOGY", "En.Style.OF_CHAIN", "En.Style.LOOKS_LIKE", "En.Style.SUBJECT_PRONOUNS", "En.Style.FAULTY_PARALLELISM", "En.Style.SPELLING_OUT_NUMBERS_SENT_START", "En.Style.SPELLING_OUT_NUMBERS", "En.Style.SPELL_OUT_AND_SYMBOLS", "En.Spelling.MISSING_DIACRITICS", "En.Typography.SMART_APOSTROPHE", "En.Typography.NUMBERS_WITH_UNITS", "De.Typography.NUMBERS_WITH_UNITS", "Uk.Style.PLEONASM").disableRules(hyphenToDash);
    private static final TextStyle Public = Empty.withId("Public").withParams(Map.of("En.contractionUse", "consistently", "En.useSerialComma", "always")).enableRules("De.Style.MAN_CLAUSES", "De.Style.CONTRACTIONS", "De.Style.DISCRIMINATORY_LANGUAGE", "De.Style.GENDERN_STYLE", "En.Style.NOUN_VERB_GENDER_BIAS", "En.Style.PRONOUN_GENDER_BIAS", "En.Style.NONVIOLENT_LANGUAGE", "En.Style.DISCRIMINATORY_LANGUAGE", "En.Style.ABLEISM", "De.Style.COLLOQUIAL_SPEECH", "En.Style.COLLOQUIAL_SPEECH", "En.Style.ENFORCE_CONTRACTION_USE", "En.Style.SERIAL_COMMA", "En.Spelling.MISSING_DIACRITICS", "En.Style.OR_SUBJECT_AGREEMENT", "De.Style.EXPRESSIVE_PUNCTUATION", "En.Style.EXPRESSIVE_PUNCTUATION", "Ru.Style.EXPRESSIVE_PUNCTUATION", "Uk.Style.EXPRESSIVE_PUNCTUATION", "De.Style.GROUP_DESCRIPTIONS", "De.Style.PASSIVE_VOICE", "En.Typography.HYPHEN_IN_RANGES", "En.Typography.LEADING_HYPHEN_TO_DASH", "De.Typography.LEADING_HYPHEN_TO_DASH");
    private static final TextStyle Formal = Public.withId("Formal").withParams(Map.of("En.contractionUse", "never")).enableRules("De.Style.VERB_FORMATION_COLLOQUIALISMS", "En.Style.PRONOUN_SECOND_PERSON", "En.Style.INFORMAL_SHORT_FORMS", "En.Style.HONORIFIC", "De.Style.EXCLAMATION_MARK", "En.Style.EXCLAMATION_MARK", "Ru.Style.EXCLAMATION_MARK", "Uk.Style.EXCLAMATION_MARK", "De.Style.SMILEY_OR_EMOJI_USE", "En.Style.SMILEY_OR_EMOJI_USE", "Ru.Style.SMILEY_OR_EMOJI_USE", "Uk.Style.SMILEY_OR_EMOJI_USE").disableRules("De.Style.GROUP_DESCRIPTIONS", "De.Style.PASSIVE_VOICE");
    private static final TextStyle Academic = Formal.withId("Academic").disableRules("En.Style.SPELLING_OUT_LARGE_NUMBERS");
    private static final List<TextStyle> commonStyles = List.of(Informal, Unspecified, Public, Formal, Academic);
    public static final TextStyle CodeDocumentation = Empty.withId("CodeDocumentation").disableRules("De.Punctuation.QUOTE_PUNCTUATION", "En.Typography.VARIANT_QUOTE_PUNCTUATION", "De.Style.SEHR_RULE", "En.Style.VERY_ABUSE", "De.Style.IMPERSONAL_PRONOUNS", "En.Style.OF_CHAIN", "En.Style.SPELLING_OUT_NUMBERS_SENT_START", "En.Style.SPELLING_OUT_NUMBERS", "En.Typography.SMART_APOSTROPHE", "En.Typography.NUMBERS_WITH_UNITS", "De.Typography.NUMBERS_WITH_UNITS", "En.Typography.ASCII_APPROXIMATIONS", "De.Typography.ASCII_APPROXIMATIONS", "Ru.Typography.ASCII_APPROXIMATIONS", "Uk.Typography.ASCII_APPROXIMATIONS").disableRules(hyphenToDash);
    public static final TextStyle CodeComment = CodeDocumentation.withId("CodeComment").disableRules("De.Style.DISCRIMINATORY_LANGUAGE", "De.Style.GENDERN_STYLE", "De.Style.GROUP_DESCRIPTIONS", "En.Style.SERIAL_COMMA", "En.Style.TAUTOLOGY", "En.Style.LOOKS_LIKE", "En.Style.SUBJECT_PRONOUNS", "En.Style.FAULTY_PARALLELISM", "En.Style.SPELL_OUT_AND_SYMBOLS", "En.Style.CONDESCENDING", "En.Style.NOUN_VERB_GENDER_BIAS", "En.Style.PRONOUN_GENDER_BIAS", "En.Style.NONVIOLENT_LANGUAGE", "En.Style.DISCRIMINATORY_LANGUAGE", "En.Style.ABLEISM", "En.Spelling.MISSING_DIACRITICS", "Uk.Style.PLEONASM");
    public static final TextStyle Commit = CodeComment.withId("Commit").disableRules("En.Grammar.MISSING_ARTICLE");
    public static final TextStyle AIPrompt = Commit.withId("AIPrompt").enableRules("En.Style.SPELL_OUT_AND_SYMBOLS");
    private static final List<TextStyle> ideOnlyStyles = List.of(Commit, CodeComment, CodeDocumentation, AIPrompt);

    public TextStyle {
        List<String> duplicate = enabledRules.stream().filter(disabledRules::contains).toList();
        if (!duplicate.isEmpty()) {
            throw new AssertionError((Object)("Rules both enabled and disabled: " + String.valueOf(duplicate)));
        }
    }

    private TextStyle withId(String id) {
        return new TextStyle(id, this.paramValues, this.enabledRules, this.disabledRules);
    }

    private TextStyle withParams(Map<String, String> params) {
        HashMap<String, String> merged = new HashMap<String, String>(this.paramValues);
        merged.putAll(params);
        return new TextStyle(this.id, Collections.unmodifiableMap(merged), this.enabledRules, this.disabledRules);
    }

    private TextStyle enableRules(String ... enabledRules) {
        Set<String> enabled = TextStyle.addRules(enabledRules, this.enabledRules);
        return new TextStyle(this.id, this.paramValues, enabled, ((StreamEx)StreamEx.of(this.disabledRules).filter(s -> !enabled.contains(s))).toSet());
    }

    private TextStyle disableRules(String ... disabledRules) {
        Set<String> disabled = TextStyle.addRules(disabledRules, this.disabledRules);
        return new TextStyle(this.id, this.paramValues, ((StreamEx)StreamEx.of(this.enabledRules).filter(s -> !disabled.contains(s))).toSet(), disabled);
    }

    private static Set<String> addRules(String[] toAdd, Set<String> set) {
        return StreamEx.of((Object[])toAdd).map(s -> "Grazie.RuleEngine." + s).append(set).toSet();
    }

    public static List<TextStyle> styles(RuleClient client) {
        ArrayList<TextStyle> result = new ArrayList<TextStyle>(commonStyles);
        if (client.showIdeStyles()) {
            result.addAll(ideOnlyStyles);
        }
        return result;
    }

    public boolean isRuleEnabled(String globalId, Supplier<Boolean> enabledByDefault) {
        return this.enabledRules.contains(globalId) || !this.disabledRules.contains(globalId) && enabledByDefault.get() != false;
    }
}

