/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001/B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\"\u0010\u0004\u001a\u00020\u0005*\u00020\r2\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J6\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J#\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u001bJ8\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015H\u0002J0\u0010$\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u0015H\u0002J:\u0010(\u001a\u00020\u001d*\u00020)2\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010#\u001a\u00020\u0015J*\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020)2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010#\u001a\u00020\u0015J\u0012\u0010,\u001a\u00020\u0015*\u00020)2\u0006\u0010-\u001a\u00020.\u00a8\u00060"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/TableFormattingUtils;", "", "<init>", "()V", "buildCellState", "Lorg/intellij/plugins/markdown/editor/tables/TableFormattingUtils$CellContentState;", "range", "Lcom/intellij/openapi/util/TextRange;", "document", "Lcom/intellij/openapi/editor/Document;", "carets", "", "Lcom/intellij/openapi/editor/Caret;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableCell;", "calculateContentsMaxWidth", "", "cells", "", "cellsContentsWithCarets", "separatorCellRange", "trimToMaxContent", "", "calculateNewCaretsPositions", "", "content", "", "cellRange", "(Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;)[Ljava/lang/Integer;", "processCell", "", "cell", "state", "maxCellWidth", "alignment", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow$CellAlignment;", "preventExpand", "processSeparator", "separatorRow", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow;", "columnIndex", "reformatColumnOnChange", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "reformatAllColumns", "table", "isSoftWrapping", "editor", "Lcom/intellij/openapi/editor/Editor;", "CellContentState", "intellij.markdown"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTableFormattingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableFormattingUtils.kt\norg/intellij/plugins/markdown/editor/tables/TableFormattingUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n777#2:173\n873#2,2:174\n1068#2:176\n1786#2,3:183\n1786#2,3:186\n777#2:190\n873#2,2:191\n1586#2:193\n1661#2,3:194\n1586#2:199\n1661#2,3:200\n1807#2,3:203\n37#3,2:177\n37#3,2:197\n11705#4:179\n12052#4,3:180\n1#5:189\n*S KotlinDebug\n*F\n+ 1 TableFormattingUtils.kt\norg/intellij/plugins/markdown/editor/tables/TableFormattingUtils\n*L\n29#1:173\n29#1:174,2\n29#1:176\n35#1:183,3\n60#1:186,3\n71#1:190\n71#1:191,2\n72#1:193\n72#1:194,3\n136#1:199\n136#1:200,3\n142#1:203,3\n29#1:177,2\n73#1:197,2\n34#1:179\n34#1:180,3\n*E\n"})
public final class TableFormattingUtils {
    @NotNull
    public static final TableFormattingUtils INSTANCE = new TableFormattingUtils();

    private TableFormattingUtils() {
    }

    /*
     * WARNING - void declaration
     */
    private final CellContentState buildCellState(TextRange range, Document document, Iterable<? extends Caret> carets) {
        StringBuilder stringBuilder;
        boolean bl;
        List caretsOffsets;
        String content2;
        Caret[] caretsInside;
        block8: {
            Iterator $this$mapTo$iv$iv;
            void $this$toTypedArray$iv;
            Collection $this$sortedBy$iv;
            int n;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = carets;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv22 = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Caret it = (Caret)element$iv$iv;
                n = 0;
                if (!range.containsOffset(it.getOffset())) continue;
                destination$iv$iv22.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv22;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Caret it = (Caret)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getOffset());
                    it = (Caret)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOffset()));
                }
            });
            boolean $i$f$toTypedArray22 = false;
            void thisCollection$iv22 = $this$toTypedArray$iv;
            caretsInside = thisCollection$iv22.toArray(new Caret[0]);
            CharSequence charSequence = document.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            CharSequence $i$f$toTypedArray22 = charSequence;
            int thisCollection$iv22 = range.getStartOffset();
            int destination$iv$iv22 = range.getEndOffset();
            content2 = ((Object)$i$f$toTypedArray22.subSequence(thisCollection$iv22, destination$iv$iv22)).toString();
            if (caretsInside.length == 0) {
                return new CellContentState(content2, null, 2, null);
            }
            Caret[] $this$map$iv = caretsInside;
            boolean $i$f$map = false;
            Caret[] $i$f$filterTo22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            n = ((void)$this$mapTo$iv$iv).length;
            for (int it = 0; it < n; ++it) {
                void it2;
                void item$iv$iv;
                void var15_26 = item$iv$iv = $this$mapTo$iv$iv[it];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it2.getOffset() - range.getStartOffset());
            }
            caretsOffsets = (List)destination$iv$iv;
            Iterable $this$all$iv = caretsOffsets;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl3 = false;
                    if (it <= content2.length()) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl4 = false;
            String string = "Content indices: " + StringsKt.getIndices((CharSequence)content2) + "; Carets offsets: " + caretsOffsets;
            throw new IllegalStateException(string.toString());
        }
        StringBuilder $this$buildCellState_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl5 = false;
        int previousOffset = 0;
        Iterator iterator = caretsOffsets.iterator();
        while (iterator.hasNext()) {
            int caretOffset = ((Number)iterator.next()).intValue();
            String string = content2.substring(previousOffset, caretOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            $this$buildCellState_u24lambda_u245.append(string);
            $this$buildCellState_u24lambda_u245.append('\n');
            previousOffset = caretOffset;
        }
        String string = content2.substring(previousOffset, content2.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        $this$buildCellState_u24lambda_u245.append(string);
        String contentWithReplacements = stringBuilder.toString();
        return new CellContentState(contentWithReplacements, caretsInside);
    }

    private final CellContentState buildCellState(MarkdownTableCell $this$buildCellState, Document document, Iterable<? extends Caret> carets) {
        TextRange textRange = $this$buildCellState.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return this.buildCellState(textRange, document, carets);
    }

    /*
     * Unable to fully structure code
     */
    private final int calculateContentsMaxWidth(Collection<? extends MarkdownTableCell> cells, Iterable<CellContentState> cellsContentsWithCarets, TextRange separatorCellRange, boolean trimToMaxContent) {
        block14: {
            if (!trimToMaxContent) ** GOTO lbl-1000
            $this$all$iv = cells;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v0 = true;
            } else {
                for (E element$iv : $this$all$iv) {
                    it = (MarkdownTableCell)element$iv;
                    $i$a$-all-TableFormattingUtils$calculateContentsMaxWidth$trimToMaxContent$1 = false;
                    v1 = it.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getText(...)");
                    if (StringsKt.isBlank((CharSequence)v1)) continue;
                    v0 = false;
                    break block14;
                }
                v0 = true;
            }
        }
        if (!v0) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        trimToMaxContent = v2;
        if (trimToMaxContent) {
            var8_8 = SequencesKt.map((Sequence)CollectionsKt.asSequence(cellsContentsWithCarets), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, calculateContentsMaxWidth$lambda$1(org.intellij.plugins.markdown.editor.tables.TableFormattingUtils$CellContentState ), (Lorg/intellij/plugins/markdown/editor/tables/TableFormattingUtils$CellContentState;)Ljava/lang/String;)()).iterator();
            if (!var8_8.hasNext()) {
                v3 = null;
            } else {
                it = (String)var8_8.next();
                $i$a$-maxOfOrNull-TableFormattingUtils$calculateContentsMaxWidth$contentCellsWidth$2 = false;
                it = it.length() + 2;
                while (var8_8.hasNext()) {
                    it = (String)var8_8.next();
                    $i$a$-maxOfOrNull-TableFormattingUtils$calculateContentsMaxWidth$contentCellsWidth$2 = false;
                    if (it.compareTo(it = (Comparable)Integer.valueOf(it.length() + 2)) >= 0) continue;
                    it = it;
                }
                v3 = it;
            }
            v4 = (Integer)v3;
        } else {
            var8_8 = ((Iterable)cells).iterator();
            if (!var8_8.hasNext()) {
                v5 = null;
            } else {
                it = (MarkdownTableCell)var8_8.next();
                $i$a$-maxOfOrNull-TableFormattingUtils$calculateContentsMaxWidth$contentCellsWidth$3 = false;
                var9_9 = Integer.valueOf(it.getTextRange().getLength());
                while (var8_8.hasNext()) {
                    it = (MarkdownTableCell)var8_8.next();
                    $i$a$-maxOfOrNull-TableFormattingUtils$calculateContentsMaxWidth$contentCellsWidth$3 = false;
                    var10_14 = Integer.valueOf(it.getTextRange().getLength());
                    if (var9_9.compareTo(var10_14) >= 0) continue;
                    var9_9 = var10_14;
                }
                v5 = var9_9;
            }
            v4 = (Integer)v5;
        }
        if ((contentCellsWidth = v4) == null) {
            var7_7 = "Required value was null.";
            throw new IllegalStateException(var7_7.toString());
        }
        v6 = separatorCellRange;
        return Integer.max(contentCellsWidth, v6 != null ? v6.getLength() : 1);
    }

    /*
     * WARNING - void declaration
     */
    private final Integer[] calculateNewCaretsPositions(String content2, TextRange cellRange) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        int it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = (Iterable)StringsKt.getIndices((CharSequence)content2);
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(content2.charAt(it) == '\n')) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it + cellRange.getStartOffset());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Integer[] positions = thisCollection$iv.toArray(new Integer[0]);
        int n = positions.length;
        for (int index = 0; index < n; ++index) {
            int n2 = index;
            positions[n2] = positions[n2] - index;
        }
        return positions;
    }

    private final void processCell(Document document, MarkdownTableCell cell, CellContentState state, int maxCellWidth, MarkdownTableSeparatorRow.CellAlignment alignment, boolean preventExpand) {
        String expectedContent = TableModificationUtils.INSTANCE.buildRealignedCellContent(state.getTrimmedContentWithCarets(), maxCellWidth + state.getCaretsInside().length, alignment);
        TextRange range = cell.getTextRange();
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence charSequence2 = charSequence;
        int n = range.getStartOffset();
        int n2 = range.getEndOffset();
        String cellContent = ((Object)charSequence2.subSequence(n, n2)).toString();
        if (preventExpand && cellContent.length() < maxCellWidth) {
            return;
        }
        String expectedContentWithoutCarets = StringsKt.replace$default((String)expectedContent, (String)"\n", (String)"", (boolean)false, (int)4, null);
        if (!Intrinsics.areEqual((Object)cellContent, (Object)expectedContentWithoutCarets)) {
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)expectedContentWithoutCarets);
            Intrinsics.checkNotNull((Object)range);
            Object[] caretsPositions = this.calculateNewCaretsPositions(expectedContent, range);
            if (!(caretsPositions.length == state.getCaretsInside().length)) {
                throw new IllegalStateException("Check failed.");
            }
            for (Pair pair : SequencesKt.zip((Sequence)ArraysKt.asSequence((Object[])state.getCaretsInside()), (Sequence)ArraysKt.asSequence((Object[])caretsPositions))) {
                Caret caret = (Caret)pair.component1();
                int position = ((Number)pair.component2()).intValue();
                caret.moveToOffset(position);
            }
        }
    }

    private final void processSeparator(Document document, MarkdownTableSeparatorRow separatorRow, int columnIndex, int maxCellWidth, boolean preventExpand) {
        TextRange textRange = MarkdownTableSeparatorRow.getCellRange$default(separatorRow, columnIndex, false, 2, null);
        Intrinsics.checkNotNull((Object)textRange);
        TextRange range = textRange;
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence charSequence2 = charSequence;
        int n = range.getStartOffset();
        int n2 = range.getEndOffset();
        String content2 = ((Object)charSequence2.subSequence(n, n2)).toString();
        if (preventExpand && content2.length() < maxCellWidth) {
            return;
        }
        MarkdownTableSeparatorRow.CellAlignment alignment = separatorRow.getCellAlignment(columnIndex);
        String expectedContent = TableModificationUtils.INSTANCE.buildSeparatorCellContent(alignment, maxCellWidth);
        if (!Intrinsics.areEqual((Object)content2, (Object)expectedContent)) {
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)expectedContent);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void reformatColumnOnChange(@NotNull MarkdownTable $this$reformatColumnOnChange, @NotNull Document document, @NotNull Iterable<? extends Caret> carets, int columnIndex, boolean trimToMaxContent, boolean preventExpand) {
        boolean bl;
        boolean bl2;
        Collection collection;
        Iterable iterable;
        MarkdownTableSeparatorRow separatorRow;
        List cellsStates;
        Object object;
        Collection destination$iv$iv;
        List cells;
        block6: {
            String $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$reformatColumnOnChange, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter(carets, (String)"carets");
            cells = CollectionsKt.asReversed(TableUtils.INSTANCE.getColumnCells($this$reformatColumnOnChange, columnIndex, true));
            Iterable $this$map$iv = cells;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                MarkdownTableCell markdownTableCell = (MarkdownTableCell)item$iv$iv;
                object = destination$iv$iv;
                boolean bl3 = false;
                object.add(INSTANCE.buildCellState((MarkdownTableCell)it, document, carets));
            }
            cellsStates = (List)destination$iv$iv;
            MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow($this$reformatColumnOnChange);
            if (markdownTableSeparatorRow == null) {
                $this$mapTo$iv$iv = "Required value was null.";
                throw new IllegalStateException($this$mapTo$iv$iv.toString());
            }
            separatorRow = markdownTableSeparatorRow;
            TextRange textRange = MarkdownTableSeparatorRow.getCellRange$default(separatorRow, columnIndex, false, 2, null);
            Intrinsics.checkNotNull((Object)textRange);
            TextRange separatorCellRange = textRange;
            Collection $i$f$mapTo22 = destination$iv$iv = separatorCellRange;
            iterable = cellsStates;
            collection = cells;
            object = this;
            boolean bl4 = false;
            Iterable<? extends Caret> $this$any$iv = carets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                Iterator<? extends Caret> bl3 = $this$any$iv.iterator();
                while (bl3.hasNext()) {
                    Caret element$iv;
                    Caret it = element$iv = bl3.next();
                    boolean bl5 = false;
                    if (!separatorCellRange.containsOffset(it.getOffset())) continue;
                    bl2 = true;
                    break block6;
                }
                bl2 = false;
            }
        }
        int maxCellWidth = super.calculateContentsMaxWidth(collection, iterable, (TextRange)((bl = bl2) ? destination$iv$iv : null), trimToMaxContent);
        MarkdownTableSeparatorRow.CellAlignment alignment = TableUtils.INSTANCE.getColumnAlignment($this$reformatColumnOnChange, columnIndex);
        Sequence contentCells = SequencesKt.takeWhile((Sequence)SequencesKt.zip((Sequence)CollectionsKt.asSequence((Iterable)cells), (Sequence)CollectionsKt.asSequence((Iterable)cellsStates)), TableFormattingUtils::reformatColumnOnChange$lambda$2);
        for (Pair pair : contentCells) {
            MarkdownTableCell cell = (MarkdownTableCell)pair.component1();
            CellContentState state = (CellContentState)pair.component2();
            this.processCell(document, cell, state, maxCellWidth, alignment, preventExpand);
        }
        this.processSeparator(document, separatorRow, columnIndex, maxCellWidth, preventExpand);
        this.processCell(document, (MarkdownTableCell)CollectionsKt.last((List)cells), (CellContentState)CollectionsKt.last((List)cellsStates), maxCellWidth, alignment, preventExpand);
    }

    public static /* synthetic */ void reformatColumnOnChange$default(TableFormattingUtils tableFormattingUtils, MarkdownTable markdownTable, Document document, Iterable iterable, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        tableFormattingUtils.reformatColumnOnChange(markdownTable, document, iterable, n, bl, bl2);
    }

    public final void reformatAllColumns(@NotNull MarkdownTable table, @NotNull Document document, boolean trimToMaxContent, boolean preventExpand) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        IntRange columnsIndices = TableUtils.INSTANCE.getColumnsIndices(table);
        int tableOffset = PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)table));
        int columnIndex = columnsIndices.getFirst();
        int n = columnsIndices.getLast();
        if (columnIndex <= n) {
            while (true) {
                MarkdownTable currentTable;
                PsiDocumentManager.getInstance((Project)table.getProject()).commitDocument(document);
                PsiFile psiFile = table.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                if (TableUtils.findTable(psiFile, tableOffset) == null) break;
                IntRange intRange = TableUtils.INSTANCE.getColumnsIndices(currentTable);
                int n2 = intRange.getFirst();
                boolean bl = columnIndex <= intRange.getLast() ? n2 <= columnIndex : false;
                if (!bl) break;
                this.reformatColumnOnChange(currentTable, document, CollectionsKt.emptyList(), columnIndex, trimToMaxContent, preventExpand);
                if (columnIndex == n) break;
                ++columnIndex;
            }
        }
    }

    public static /* synthetic */ void reformatAllColumns$default(TableFormattingUtils tableFormattingUtils, MarkdownTable markdownTable, Document document, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        tableFormattingUtils.reformatAllColumns(markdownTable, document, bl, bl2);
    }

    public final boolean isSoftWrapping(@NotNull MarkdownTable $this$isSoftWrapping, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)$this$isSoftWrapping, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        TextRange range = $this$isSoftWrapping.getTextRange();
        List list2 = editor2.getSoftWrapModel().getSoftWrapsForRange(range.getStartOffset(), range.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSoftWrapsForRange(...)");
        return !((Collection)list2).isEmpty();
    }

    private static final String calculateContentsMaxWidth$lambda$1(CellContentState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTrimmedContentWithoutCarets();
    }

    private static final boolean reformatColumnOnChange$lambda$2(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        MarkdownTableCell cell = (MarkdownTableCell)pair.component1();
        MarkdownTableRow markdownTableRow = cell.getParentRow();
        return markdownTableRow != null ? !TableUtils.INSTANCE.isHeaderRow(markdownTableRow) : false;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000e\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000f\u0010\nR\u001b\u0010\u0012\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/TableFormattingUtils$CellContentState;", "", "contentWithCarets", "", "caretsInside", "", "Lcom/intellij/openapi/editor/Caret;", "<init>", "(Ljava/lang/String;[Lcom/intellij/openapi/editor/Caret;)V", "getContentWithCarets", "()Ljava/lang/String;", "getCaretsInside", "()[Lcom/intellij/openapi/editor/Caret;", "[Lcom/intellij/openapi/editor/Caret;", "trimmedContentWithCarets", "getTrimmedContentWithCarets", "trimmedContentWithCarets$delegate", "Lkotlin/Lazy;", "trimmedContentWithoutCarets", "getTrimmedContentWithoutCarets", "trimmedContentWithoutCarets$delegate", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nTableFormattingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableFormattingUtils.kt\norg/intellij/plugins/markdown/editor/tables/TableFormattingUtils$CellContentState\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,172:1\n492#2,12:173\n*S KotlinDebug\n*F\n+ 1 TableFormattingUtils.kt\norg/intellij/plugins/markdown/editor/tables/TableFormattingUtils$CellContentState\n*L\n25#1:173,12\n*E\n"})
    private static final class CellContentState {
        @NotNull
        private final String contentWithCarets;
        @NotNull
        private final Caret[] caretsInside;
        @NotNull
        private final Lazy trimmedContentWithCarets$delegate;
        @NotNull
        private final Lazy trimmedContentWithoutCarets$delegate;

        public CellContentState(@NotNull String contentWithCarets, @NotNull Caret[] caretsInside) {
            Intrinsics.checkNotNullParameter((Object)contentWithCarets, (String)"contentWithCarets");
            Intrinsics.checkNotNullParameter((Object)caretsInside, (String)"caretsInside");
            this.contentWithCarets = contentWithCarets;
            this.caretsInside = caretsInside;
            this.trimmedContentWithCarets$delegate = LazyKt.lazy(() -> CellContentState.trimmedContentWithCarets_delegate$lambda$0(this));
            this.trimmedContentWithoutCarets$delegate = LazyKt.lazy(() -> CellContentState.trimmedContentWithoutCarets_delegate$lambda$0(this));
        }

        public /* synthetic */ CellContentState(String string, Caret[] caretArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                caretArray = new Caret[]{};
            }
            this(string, caretArray);
        }

        @NotNull
        public final String getContentWithCarets() {
            return this.contentWithCarets;
        }

        @NotNull
        public final Caret[] getCaretsInside() {
            return this.caretsInside;
        }

        @NotNull
        public final String getTrimmedContentWithCarets() {
            Lazy lazy = this.trimmedContentWithCarets$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public final String getTrimmedContentWithoutCarets() {
            Lazy lazy = this.trimmedContentWithoutCarets$delegate;
            return (String)lazy.getValue();
        }

        private static final String trimmedContentWithCarets_delegate$lambda$0(CellContentState this$0) {
            char[] cArray = new char[]{' '};
            return StringsKt.trim((String)this$0.contentWithCarets, (char[])cArray);
        }

        /*
         * WARNING - void declaration
         */
        private static final String trimmedContentWithoutCarets_delegate$lambda$0(CellContentState this$0) {
            void $this$filterNotTo$iv$iv;
            String $this$filterNot$iv = this$0.getTrimmedContentWithCarets();
            boolean $i$f$filterNot = false;
            CharSequence charSequence = $this$filterNot$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterNotTo = false;
            for (int i = 0; i < $this$filterNotTo$iv$iv.length(); ++i) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterNotTo$iv$iv.charAt(i);
                boolean bl = false;
                if (it == '\n') continue;
                destination$iv$iv.append(element$iv$iv);
            }
            return ((StringBuilder)destination$iv$iv).toString();
        }
    }
}

